/*
 * Decompiled with CFR 0.152.
 */
package com.uqm.crashsight.symtabtool.pdb.symbol;

import com.uqm.crashsight.symtabtool.common.utils.Log;
import com.uqm.crashsight.symtabtool.pdb.stream.ParseBuffer;
import com.uqm.crashsight.symtabtool.pdb.symbol.PSymbol;

public class SymbolIter {
    private ParseBuffer buffer;

    public SymbolIter(ParseBuffer parseBuffer) {
        this.buffer = parseBuffer;
    }

    public static SymbolIter empty() {
        return new SymbolIter(ParseBuffer.empty());
    }

    public void seek(long l) {
        this.buffer.pos(l);
    }

    public PSymbol skipTo(long l) {
        this.seek(l);
        return this.next();
    }

    public PSymbol next() {
        while (!this.buffer.isEmpty()) {
            long l = this.buffer.pos();
            long l2 = this.buffer.readU16();
            if (l2 < 2L) {
                Log.error("SymbolTooShort", new Object[0]);
                return null;
            }
            ParseBuffer parseBuffer = this.buffer.take(l2);
            PSymbol pSymbol = new PSymbol(l, parseBuffer.array());
            if (pSymbol.getRawKind() == 1031) continue;
            return pSymbol;
        }
        return null;
    }

    public ParseBuffer getBuffer() {
        return this.buffer;
    }

    public void setBuffer(ParseBuffer parseBuffer) {
        this.buffer = parseBuffer;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof SymbolIter)) {
            return false;
        }
        SymbolIter symbolIter = (SymbolIter)object;
        if (!symbolIter.canEqual(this)) {
            return false;
        }
        ParseBuffer parseBuffer = this.getBuffer();
        ParseBuffer parseBuffer2 = symbolIter.getBuffer();
        return !(parseBuffer == null ? parseBuffer2 != null : !((Object)parseBuffer).equals(parseBuffer2));
    }

    protected boolean canEqual(Object object) {
        return object instanceof SymbolIter;
    }

    public int hashCode() {
        int n = 59;
        int n2 = 1;
        ParseBuffer parseBuffer = this.getBuffer();
        n2 = n2 * 59 + (parseBuffer == null ? 43 : ((Object)parseBuffer).hashCode());
        return n2;
    }

    public String toString() {
        return "SymbolIter(buffer=" + this.getBuffer() + ")";
    }
}

