/*
 * Decompiled with CFR 0.152.
 */
package com.uqm.crashsight.symtabtool.pdb.symbol;

import com.uqm.crashsight.symtabtool.pdb.common.PdbInternalSectionOffset;
import com.uqm.crashsight.symtabtool.pdb.framedata.FrameTable;
import com.uqm.crashsight.symtabtool.pdb.module.source.Lines;
import com.uqm.crashsight.symtabtool.pdb.module.source.SourceLineCollector;
import com.uqm.crashsight.symtabtool.pdb.omap.AddressMap;
import com.uqm.crashsight.symtabtool.pdb.symbol.BlockInfo;
import com.uqm.crashsight.symtabtool.pdb.symbol.EBPInfo;
import com.uqm.crashsight.symtabtool.pdb.symbol.PDBSymbol;
import com.uqm.crashsight.symtabtool.pdb.symbol.ProcedureSymbol;
import com.uqm.crashsight.symtabtool.pdb.symbol.PublicSymbol;
import com.uqm.crashsight.symtabtool.pdb.tpi.TypeIndex;
import com.uqm.crashsight.symtabtool.pdb.types.PFuncName;
import com.uqm.crashsight.symtabtool.pdb.types.TypeDumper;
import java.util.List;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;

public class SelectedSymbol {
    String name;
    long typeIndex;
    boolean isPublic;
    boolean isMultiple;
    PdbInternalSectionOffset offset;
    PdbInternalSectionOffset symOffset;
    long len;
    long parameterSize;
    Lines source;
    List<EBPInfo> ebp;
    long id;

    public SelectedSymbol(String string, long l, boolean bl, boolean bl2, PdbInternalSectionOffset pdbInternalSectionOffset, PdbInternalSectionOffset pdbInternalSectionOffset2, long l2, long l3, Lines lines, List<EBPInfo> list, long l4) {
        this.name = string;
        this.typeIndex = l;
        this.isPublic = bl;
        this.isMultiple = bl2;
        this.offset = pdbInternalSectionOffset;
        this.symOffset = pdbInternalSectionOffset2;
        this.len = l2;
        this.parameterSize = l3;
        this.source = lines;
        this.ebp = list;
        this.id = l4;
    }

    public PFuncName getUnd(TypeDumper typeDumper) {
        PFuncName pFuncName = typeDumper.dumpFunction(this.name, new TypeIndex(this.typeIndex));
        if (pFuncName == null) {
            return PFuncName.getUnknown(this.name);
        }
        return pFuncName;
    }

    public long getStackParamSize(TypeDumper typeDumper, AddressMap addressMap, FrameTable frameTable) {
        if (this.ebp.isEmpty()) {
            return this.parameterSize;
        }
        long l = 0xFFFFFFFFL;
        long l2 = 0L;
        for (EBPInfo eBPInfo : this.ebp) {
            l = Math.min(l, eBPInfo.offset);
            l2 = Math.max(l2, eBPInfo.offset + typeDumper.getTypeSize(new TypeIndex(eBPInfo.typeIndex)));
        }
        l = Math.max(l, 4L);
        long l3 = 0L;
        if (l < l2) {
            l2 = l2 + 3L & 0xFFFFFFFFFFFFFFFCL;
            l3 = l2 - l;
        }
        this.parameterSize = l3;
        return l3;
    }

    public void updatePrivate(ProcedureSymbol procedureSymbol, BlockInfo blockInfo, SourceLineCollector sourceLineCollector) {
        this.isMultiple = true;
        String string = procedureSymbol.getName();
        if (string.compareTo(this.name) < 0) {
            this.name = string;
            this.typeIndex = procedureSymbol.getTypeIndex();
            this.offset = blockInfo.getOffset();
            this.len = blockInfo.getLen();
            this.source = sourceLineCollector.collectSourceLines(blockInfo.getOffset(), blockInfo.getLen());
        }
    }

    public void updatePublic(PublicSymbol publicSymbol) {
        if (this.isPublic) {
            this.isMultiple = true;
            String string = publicSymbol.getName();
            if (string.compareTo(this.name) < 0) {
                this.name = string;
                this.offset = publicSymbol.getOffset();
            }
        } else {
            String string;
            Object object;
            String string2 = publicSymbol.getName();
            if (this.typeIndex == 0L && (object = this.symOffset) != null && ((PdbInternalSectionOffset)object).isEq(publicSymbol.getOffset())) {
                this.name = string2;
            }
            if ((string = ((PFuncName)(object = PFuncName.getUnknown(string2))).getUnknown().getName()).equals(this.name) || string2.equals(this.name)) {
                this.name = string;
                this.parameterSize = ((PFuncName)object).getUnknown().getParamSize();
            }
        }
    }

    public Pair<PDBSymbol, PdbInternalSectionOffset> mvToPdbSymbol(TypeDumper typeDumper, long l, AddressMap addressMap, FrameTable frameTable) {
        long l2;
        String string;
        PFuncName pFuncName = this.getUnd(typeDumper);
        if (pFuncName.getUndecorated() != null) {
            string = pFuncName.getUndecorated().getName();
            l2 = this.getStackParamSize(typeDumper, addressMap, frameTable);
        } else {
            string = pFuncName.getUnknown().getName();
            l2 = pFuncName.getUnknown().getParamSize();
        }
        this.source.finalize(l, this.len, addressMap);
        PDBSymbol pDBSymbol = new PDBSymbol(string, this.isPublic, this.isMultiple, 0L, this.len, l2, this.source, this.id);
        return new ImmutablePair<PDBSymbol, PdbInternalSectionOffset>(pDBSymbol, this.offset);
    }

    public String getName() {
        return this.name;
    }

    public long getTypeIndex() {
        return this.typeIndex;
    }

    public boolean isPublic() {
        return this.isPublic;
    }

    public boolean isMultiple() {
        return this.isMultiple;
    }

    public PdbInternalSectionOffset getOffset() {
        return this.offset;
    }

    public PdbInternalSectionOffset getSymOffset() {
        return this.symOffset;
    }

    public long getLen() {
        return this.len;
    }

    public long getParameterSize() {
        return this.parameterSize;
    }

    public Lines getSource() {
        return this.source;
    }

    public List<EBPInfo> getEbp() {
        return this.ebp;
    }

    public long getId() {
        return this.id;
    }

    public void setName(String string) {
        this.name = string;
    }

    public void setTypeIndex(long l) {
        this.typeIndex = l;
    }

    public void setPublic(boolean bl) {
        this.isPublic = bl;
    }

    public void setMultiple(boolean bl) {
        this.isMultiple = bl;
    }

    public void setOffset(PdbInternalSectionOffset pdbInternalSectionOffset) {
        this.offset = pdbInternalSectionOffset;
    }

    public void setSymOffset(PdbInternalSectionOffset pdbInternalSectionOffset) {
        this.symOffset = pdbInternalSectionOffset;
    }

    public void setLen(long l) {
        this.len = l;
    }

    public void setParameterSize(long l) {
        this.parameterSize = l;
    }

    public void setSource(Lines lines) {
        this.source = lines;
    }

    public void setEbp(List<EBPInfo> list) {
        this.ebp = list;
    }

    public void setId(long l) {
        this.id = l;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof SelectedSymbol)) {
            return false;
        }
        SelectedSymbol selectedSymbol = (SelectedSymbol)object;
        if (!selectedSymbol.canEqual(this)) {
            return false;
        }
        if (this.getTypeIndex() != selectedSymbol.getTypeIndex()) {
            return false;
        }
        if (this.isPublic() != selectedSymbol.isPublic()) {
            return false;
        }
        if (this.isMultiple() != selectedSymbol.isMultiple()) {
            return false;
        }
        if (this.getLen() != selectedSymbol.getLen()) {
            return false;
        }
        if (this.getParameterSize() != selectedSymbol.getParameterSize()) {
            return false;
        }
        if (this.getId() != selectedSymbol.getId()) {
            return false;
        }
        String string = this.getName();
        String string2 = selectedSymbol.getName();
        if (string == null ? string2 != null : !string.equals(string2)) {
            return false;
        }
        PdbInternalSectionOffset pdbInternalSectionOffset = this.getOffset();
        PdbInternalSectionOffset pdbInternalSectionOffset2 = selectedSymbol.getOffset();
        if (pdbInternalSectionOffset == null ? pdbInternalSectionOffset2 != null : !((Object)pdbInternalSectionOffset).equals(pdbInternalSectionOffset2)) {
            return false;
        }
        PdbInternalSectionOffset pdbInternalSectionOffset3 = this.getSymOffset();
        PdbInternalSectionOffset pdbInternalSectionOffset4 = selectedSymbol.getSymOffset();
        if (pdbInternalSectionOffset3 == null ? pdbInternalSectionOffset4 != null : !((Object)pdbInternalSectionOffset3).equals(pdbInternalSectionOffset4)) {
            return false;
        }
        Lines lines = this.getSource();
        Lines lines2 = selectedSymbol.getSource();
        if (lines == null ? lines2 != null : !((Object)lines).equals(lines2)) {
            return false;
        }
        List<EBPInfo> list = this.getEbp();
        List<EBPInfo> list2 = selectedSymbol.getEbp();
        return !(list == null ? list2 != null : !((Object)list).equals(list2));
    }

    protected boolean canEqual(Object object) {
        return object instanceof SelectedSymbol;
    }

    public int hashCode() {
        int n = 59;
        int n2 = 1;
        long l = this.getTypeIndex();
        n2 = n2 * 59 + (int)(l >>> 32 ^ l);
        n2 = n2 * 59 + (this.isPublic() ? 79 : 97);
        n2 = n2 * 59 + (this.isMultiple() ? 79 : 97);
        long l2 = this.getLen();
        n2 = n2 * 59 + (int)(l2 >>> 32 ^ l2);
        long l3 = this.getParameterSize();
        n2 = n2 * 59 + (int)(l3 >>> 32 ^ l3);
        long l4 = this.getId();
        n2 = n2 * 59 + (int)(l4 >>> 32 ^ l4);
        String string = this.getName();
        n2 = n2 * 59 + (string == null ? 43 : string.hashCode());
        PdbInternalSectionOffset pdbInternalSectionOffset = this.getOffset();
        n2 = n2 * 59 + (pdbInternalSectionOffset == null ? 43 : ((Object)pdbInternalSectionOffset).hashCode());
        PdbInternalSectionOffset pdbInternalSectionOffset2 = this.getSymOffset();
        n2 = n2 * 59 + (pdbInternalSectionOffset2 == null ? 43 : ((Object)pdbInternalSectionOffset2).hashCode());
        Lines lines = this.getSource();
        n2 = n2 * 59 + (lines == null ? 43 : ((Object)lines).hashCode());
        List<EBPInfo> list = this.getEbp();
        n2 = n2 * 59 + (list == null ? 43 : ((Object)list).hashCode());
        return n2;
    }

    public String toString() {
        return "SelectedSymbol(name=" + this.getName() + ", typeIndex=" + this.getTypeIndex() + ", isPublic=" + this.isPublic() + ", isMultiple=" + this.isMultiple() + ", offset=" + this.getOffset() + ", symOffset=" + this.getSymOffset() + ", len=" + this.getLen() + ", parameterSize=" + this.getParameterSize() + ", source=" + this.getSource() + ", ebp=" + this.getEbp() + ", id=" + this.getId() + ")";
    }
}

