/*
 * Decompiled with CFR 0.152.
 */
package com.uqm.crashsight.symtabtool.pdb.symbol;

import com.uqm.crashsight.symtabtool.pdb.stream.ParseBuffer;
import com.uqm.crashsight.symtabtool.pdb.symbol.ExportSymbolFlags;
import com.uqm.crashsight.symtabtool.pdb.symbol.Utils;

public class ExportSymbol {
    int ordinal;
    ExportSymbolFlags flags;
    String name;

    public ExportSymbol(int n, ExportSymbolFlags exportSymbolFlags, String string) {
        this.ordinal = n;
        this.flags = exportSymbolFlags;
        this.name = string;
    }

    public static ExportSymbol parse(ParseBuffer parseBuffer, int n) {
        try {
            return new ExportSymbol(parseBuffer.readU16(), ExportSymbolFlags.parse(parseBuffer), Utils.parseSymbolName(parseBuffer, n));
        }
        catch (Exception exception) {
            return null;
        }
    }

    public int getOrdinal() {
        return this.ordinal;
    }

    public ExportSymbolFlags getFlags() {
        return this.flags;
    }

    public String getName() {
        return this.name;
    }

    public void setOrdinal(int n) {
        this.ordinal = n;
    }

    public void setFlags(ExportSymbolFlags exportSymbolFlags) {
        this.flags = exportSymbolFlags;
    }

    public void setName(String string) {
        this.name = string;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof ExportSymbol)) {
            return false;
        }
        ExportSymbol exportSymbol = (ExportSymbol)object;
        if (!exportSymbol.canEqual(this)) {
            return false;
        }
        if (this.getOrdinal() != exportSymbol.getOrdinal()) {
            return false;
        }
        ExportSymbolFlags exportSymbolFlags = this.getFlags();
        ExportSymbolFlags exportSymbolFlags2 = exportSymbol.getFlags();
        if (exportSymbolFlags == null ? exportSymbolFlags2 != null : !((Object)exportSymbolFlags).equals(exportSymbolFlags2)) {
            return false;
        }
        String string = this.getName();
        String string2 = exportSymbol.getName();
        return !(string == null ? string2 != null : !string.equals(string2));
    }

    protected boolean canEqual(Object object) {
        return object instanceof ExportSymbol;
    }

    public int hashCode() {
        int n = 59;
        int n2 = 1;
        n2 = n2 * 59 + this.getOrdinal();
        ExportSymbolFlags exportSymbolFlags = this.getFlags();
        n2 = n2 * 59 + (exportSymbolFlags == null ? 43 : ((Object)exportSymbolFlags).hashCode());
        String string = this.getName();
        n2 = n2 * 59 + (string == null ? 43 : string.hashCode());
        return n2;
    }

    public String toString() {
        return "ExportSymbol(ordinal=" + this.getOrdinal() + ", flags=" + this.getFlags() + ", name=" + this.getName() + ")";
    }
}

