/*
 * Decompiled with CFR 0.152.
 */
package com.uqm.crashsight.symtabtool.pdb.strings;

import com.uqm.crashsight.symtabtool.common.utils.Log;
import com.uqm.crashsight.symtabtool.pdb.stream.ParseBuffer;
import com.uqm.crashsight.symtabtool.pdb.strings.StringTableHashVersion;
import com.uqm.crashsight.symtabtool.pdb.strings.StringTableHeader;

public class StringTable {
    public static final long PDB_NMT_HDR = 0xEFFEEFFEL;
    StringTableHeader header;
    StringTableHashVersion hashVersion;
    ParseBuffer buffer;

    public static StringTable parse(ParseBuffer parseBuffer) {
        StringTable stringTable = new StringTable();
        StringTableHeader stringTableHeader = StringTableHeader.parse(parseBuffer);
        if (stringTableHeader.magic != 0xEFFEEFFEL) {
            Log.error("Unsupported symbol data format", new Object[0]);
            return null;
        }
        if (parseBuffer.len() < stringTableHeader.namesEnd()) {
            Log.error("UnexpectedEof", new Object[0]);
            return null;
        }
        stringTable.header = stringTableHeader;
        stringTable.hashVersion = StringTableHashVersion.from((int)stringTable.header.hashVersion);
        stringTable.buffer = parseBuffer;
        return stringTable;
    }

    public String get(long l) {
        if (l >= this.header.namesSize) {
            Log.error("UnexpectedEof", new Object[0]);
            return null;
        }
        long l2 = this.header.nameStart() + l;
        long l3 = this.buffer.pos();
        String string = this.buffer.readCString(l2);
        this.buffer.pos(l3);
        return string;
    }

    public StringTableHeader getHeader() {
        return this.header;
    }

    public StringTableHashVersion getHashVersion() {
        return this.hashVersion;
    }

    public ParseBuffer getBuffer() {
        return this.buffer;
    }

    public void setHeader(StringTableHeader stringTableHeader) {
        this.header = stringTableHeader;
    }

    public void setHashVersion(StringTableHashVersion stringTableHashVersion) {
        this.hashVersion = stringTableHashVersion;
    }

    public void setBuffer(ParseBuffer parseBuffer) {
        this.buffer = parseBuffer;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof StringTable)) {
            return false;
        }
        StringTable stringTable = (StringTable)object;
        if (!stringTable.canEqual(this)) {
            return false;
        }
        StringTableHeader stringTableHeader = this.getHeader();
        StringTableHeader stringTableHeader2 = stringTable.getHeader();
        if (stringTableHeader == null ? stringTableHeader2 != null : !((Object)stringTableHeader).equals(stringTableHeader2)) {
            return false;
        }
        StringTableHashVersion stringTableHashVersion = this.getHashVersion();
        StringTableHashVersion stringTableHashVersion2 = stringTable.getHashVersion();
        if (stringTableHashVersion == null ? stringTableHashVersion2 != null : !((Object)((Object)stringTableHashVersion)).equals((Object)stringTableHashVersion2)) {
            return false;
        }
        ParseBuffer parseBuffer = this.getBuffer();
        ParseBuffer parseBuffer2 = stringTable.getBuffer();
        return !(parseBuffer == null ? parseBuffer2 != null : !((Object)parseBuffer).equals(parseBuffer2));
    }

    protected boolean canEqual(Object object) {
        return object instanceof StringTable;
    }

    public int hashCode() {
        int n = 59;
        int n2 = 1;
        StringTableHeader stringTableHeader = this.getHeader();
        n2 = n2 * 59 + (stringTableHeader == null ? 43 : ((Object)stringTableHeader).hashCode());
        StringTableHashVersion stringTableHashVersion = this.getHashVersion();
        n2 = n2 * 59 + (stringTableHashVersion == null ? 43 : ((Object)((Object)stringTableHashVersion)).hashCode());
        ParseBuffer parseBuffer = this.getBuffer();
        n2 = n2 * 59 + (parseBuffer == null ? 43 : ((Object)parseBuffer).hashCode());
        return n2;
    }

    public String toString() {
        return "StringTable(header=" + this.getHeader() + ", hashVersion=" + (Object)((Object)this.getHashVersion()) + ", buffer=" + this.getBuffer() + ")";
    }
}

