/*
 * Decompiled with CFR 0.152.
 */
package com.uqm.crashsight.symtabtool.pdb.stream;

import com.uqm.crashsight.symtabtool.common.utils.Log;
import com.uqm.crashsight.symtabtool.pdb.PdbHeaderParser;
import com.uqm.crashsight.symtabtool.pdb.StreamPair;
import com.uqm.crashsight.symtabtool.pdb.Utils;
import com.uqm.crashsight.symtabtool.pdb.stream.ParseBuffer;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.List;

public class StreamManager {
    public static final int PDB_STREAM = 1;
    public static final int TPI_STREAM = 2;
    public static final int DBI_STREAM = 3;
    public static final int IPI_STREAM = 4;
    public static StreamManager instance = null;
    String filename;
    long pageSize;
    long numPages;
    RandomAccessFile randomAccessFile;
    List<StreamPair> streams;

    public static StreamManager init(String string) {
        instance = new StreamManager();
        StreamManager.instance.filename = string;
        instance.init();
        return instance;
    }

    private void init() {
        try {
            long l;
            PdbHeaderParser pdbHeaderParser = PdbHeaderParser.create(this.filename);
            assert (pdbHeaderParser != null);
            this.pageSize = pdbHeaderParser.pageSize;
            this.numPages = pdbHeaderParser.pagesUsed;
            long l2 = StreamManager.getNumPages(pdbHeaderParser.directorySize, this.pageSize);
            this.randomAccessFile = new RandomAccessFile(this.filename, "r");
            this.randomAccessFile.seek(52L);
            long l3 = Utils.readUInt(this.randomAccessFile);
            this.randomAccessFile.seek(l3 * this.pageSize);
            ByteBuffer byteBuffer = ByteBuffer.allocate(Utils.getBufferCapacity(l2 * this.pageSize));
            byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
            ParseBuffer parseBuffer = new ParseBuffer(byteBuffer);
            long[] lArray = new long[(int)l2];
            int n = 0;
            while ((long)n < l2) {
                lArray[n] = Utils.readUInt(this.randomAccessFile);
                ++n;
            }
            n = 0;
            while ((long)n < l2) {
                this.randomAccessFile.seek(lArray[n] * this.pageSize);
                this.randomAccessFile.read(byteBuffer.array(), byteBuffer.position(), (int)this.pageSize);
                byteBuffer.position((n + 1) * (int)this.pageSize);
                ++n;
            }
            byteBuffer.flip();
            long l4 = parseBuffer.readU32();
            this.streams = new ArrayList<StreamPair>((int)l4);
            int n2 = 0;
            while ((long)n2 < l4) {
                l = parseBuffer.readU32();
                this.streams.add(new StreamPair(l));
                ++n2;
            }
            n2 = 0;
            while ((long)n2 < l4) {
                l = this.streams.get((int)n2).size;
                if (l > 0L && l != 0xFFFFFFFFL) {
                    long l5 = StreamManager.getNumPages(l, this.pageSize);
                    this.streams.get((int)n2).pageIndices = new ArrayList<Long>((int)l5);
                    int n3 = 0;
                    while ((long)n3 < l5) {
                        this.streams.get((int)n2).pageIndices.add(parseBuffer.readU32());
                        ++n3;
                    }
                }
                ++n2;
            }
        }
        catch (Exception exception) {
            Log.error(exception);
        }
    }

    public static StreamManager getInstance() {
        assert (instance != null);
        return instance;
    }

    static long getNumPages(long l, long l2) {
        long l3 = l / l2;
        if (l % l2 != 0L) {
            ++l3;
        }
        return l3;
    }

    public static int getBufferCapacity(long l) throws Exception {
        if (l > Integer.MAX_VALUE) {
            throw new Exception("ByteBuffer capacity too big!");
        }
        return (int)l;
    }

    public ByteBuffer getBuffer(int n) {
        if (n < 0 || n >= this.streams.size()) {
            return null;
        }
        StreamPair streamPair = this.streams.get(n);
        return this.getBuffer(streamPair);
    }

    public ByteBuffer getBuffer(StreamPair streamPair) {
        try {
            ByteBuffer byteBuffer = ByteBuffer.allocate(StreamManager.getBufferCapacity(streamPair.size));
            byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
            for (int i = 0; i < streamPair.pageIndices.size(); ++i) {
                this.randomAccessFile.seek(streamPair.pageIndices.get(i) * this.pageSize);
                long l = this.pageSize;
                if (i == streamPair.pageIndices.size() - 1 && streamPair.size % this.pageSize != 0L) {
                    l = Math.min(this.pageSize, (long)((int)streamPair.size) % this.pageSize);
                }
                this.randomAccessFile.read(byteBuffer.array(), byteBuffer.position(), (int)l);
                byteBuffer.position(byteBuffer.position() + (int)l);
            }
            byteBuffer.flip();
            return byteBuffer;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public ParseBuffer getParseBuffer(int n) {
        ByteBuffer byteBuffer = this.getBuffer(n);
        if (byteBuffer == null) {
            return null;
        }
        return new ParseBuffer(byteBuffer);
    }
}

