/*
 * Decompiled with CFR 0.152.
 */
package com.uqm.crashsight.symtabtool.pdb.pdbi;

import com.uqm.crashsight.symtabtool.pdb.dbi.HeaderVersion;
import com.uqm.crashsight.symtabtool.pdb.pdbi.StreamName;
import com.uqm.crashsight.symtabtool.pdb.pdbi.StreamNames;
import com.uqm.crashsight.symtabtool.pdb.pdbi.Uuid;
import com.uqm.crashsight.symtabtool.pdb.stream.ParseBuffer;
import java.util.ArrayList;

public class PDBInformation {
    HeaderVersion version;
    long signature;
    long age;
    Uuid guid;
    long namesOffset;
    long namesSize;
    ParseBuffer buffer;

    public static PDBInformation parse(ParseBuffer parseBuffer) {
        PDBInformation pDBInformation = new PDBInformation();
        pDBInformation.version = HeaderVersion.fromInt((int)parseBuffer.readU32());
        pDBInformation.signature = parseBuffer.readU32();
        pDBInformation.age = parseBuffer.readU32();
        pDBInformation.guid = Uuid.parse(parseBuffer);
        pDBInformation.namesSize = parseBuffer.readU32();
        pDBInformation.namesOffset = parseBuffer.pos();
        pDBInformation.buffer = parseBuffer;
        return pDBInformation;
    }

    public StreamNames getStreamNames() {
        ArrayList<StreamName> arrayList = new ArrayList<StreamName>();
        this.buffer.pos((int)(this.namesOffset + this.namesSize));
        long l = this.buffer.readU32();
        long l2 = this.buffer.readU32();
        long l3 = this.buffer.readU32();
        byte[] byArray = this.buffer.readBytes(l3 * 4L);
        long l4 = this.buffer.readU32();
        byte[] byArray2 = this.buffer.readBytes(l4 * 4L);
        ParseBuffer parseBuffer = new ParseBuffer(this.buffer.getBuffer(), this.namesOffset, this.namesOffset + this.namesSize);
        int n = 0;
        while ((long)n < l) {
            long l5 = this.buffer.readU32();
            long l6 = this.buffer.readU32();
            String string = parseBuffer.readCString(l5);
            arrayList.add(new StreamName(string, (int)l6));
            ++n;
        }
        return new StreamNames(this.buffer, arrayList);
    }

    public HeaderVersion getVersion() {
        return this.version;
    }

    public long getSignature() {
        return this.signature;
    }

    public long getAge() {
        return this.age;
    }

    public Uuid getGuid() {
        return this.guid;
    }

    public long getNamesOffset() {
        return this.namesOffset;
    }

    public long getNamesSize() {
        return this.namesSize;
    }

    public ParseBuffer getBuffer() {
        return this.buffer;
    }

    public void setVersion(HeaderVersion headerVersion) {
        this.version = headerVersion;
    }

    public void setSignature(long l) {
        this.signature = l;
    }

    public void setAge(long l) {
        this.age = l;
    }

    public void setGuid(Uuid uuid) {
        this.guid = uuid;
    }

    public void setNamesOffset(long l) {
        this.namesOffset = l;
    }

    public void setNamesSize(long l) {
        this.namesSize = l;
    }

    public void setBuffer(ParseBuffer parseBuffer) {
        this.buffer = parseBuffer;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof PDBInformation)) {
            return false;
        }
        PDBInformation pDBInformation = (PDBInformation)object;
        if (!pDBInformation.canEqual(this)) {
            return false;
        }
        if (this.getSignature() != pDBInformation.getSignature()) {
            return false;
        }
        if (this.getAge() != pDBInformation.getAge()) {
            return false;
        }
        if (this.getNamesOffset() != pDBInformation.getNamesOffset()) {
            return false;
        }
        if (this.getNamesSize() != pDBInformation.getNamesSize()) {
            return false;
        }
        HeaderVersion headerVersion = this.getVersion();
        HeaderVersion headerVersion2 = pDBInformation.getVersion();
        if (headerVersion == null ? headerVersion2 != null : !((Object)((Object)headerVersion)).equals((Object)headerVersion2)) {
            return false;
        }
        Uuid uuid = this.getGuid();
        Uuid uuid2 = pDBInformation.getGuid();
        if (uuid == null ? uuid2 != null : !((Object)uuid).equals(uuid2)) {
            return false;
        }
        ParseBuffer parseBuffer = this.getBuffer();
        ParseBuffer parseBuffer2 = pDBInformation.getBuffer();
        return !(parseBuffer == null ? parseBuffer2 != null : !((Object)parseBuffer).equals(parseBuffer2));
    }

    protected boolean canEqual(Object object) {
        return object instanceof PDBInformation;
    }

    public int hashCode() {
        int n = 59;
        int n2 = 1;
        long l = this.getSignature();
        n2 = n2 * 59 + (int)(l >>> 32 ^ l);
        long l2 = this.getAge();
        n2 = n2 * 59 + (int)(l2 >>> 32 ^ l2);
        long l3 = this.getNamesOffset();
        n2 = n2 * 59 + (int)(l3 >>> 32 ^ l3);
        long l4 = this.getNamesSize();
        n2 = n2 * 59 + (int)(l4 >>> 32 ^ l4);
        HeaderVersion headerVersion = this.getVersion();
        n2 = n2 * 59 + (headerVersion == null ? 43 : ((Object)((Object)headerVersion)).hashCode());
        Uuid uuid = this.getGuid();
        n2 = n2 * 59 + (uuid == null ? 43 : ((Object)uuid).hashCode());
        ParseBuffer parseBuffer = this.getBuffer();
        n2 = n2 * 59 + (parseBuffer == null ? 43 : ((Object)parseBuffer).hashCode());
        return n2;
    }

    public String toString() {
        return "PDBInformation(version=" + (Object)((Object)this.getVersion()) + ", signature=" + this.getSignature() + ", age=" + this.getAge() + ", guid=" + this.getGuid() + ", namesOffset=" + this.getNamesOffset() + ", namesSize=" + this.getNamesSize() + ", buffer=" + this.getBuffer() + ")";
    }
}

