/*
 * Decompiled with CFR 0.152.
 */
package com.uqm.crashsight.symtabtool.pdb.omap;

import com.uqm.crashsight.symtabtool.pdb.omap.OMAPTable;
import com.uqm.crashsight.symtabtool.pdb.omap.PdbInternalRvaRangeIter;
import com.uqm.crashsight.symtabtool.pdb.omap.RangeIter;
import com.uqm.crashsight.symtabtool.pdb.omap.RvaRangeIter;
import com.uqm.crashsight.symtabtool.pdb.omap.SectionOffset;
import com.uqm.crashsight.symtabtool.pdb.pe.ImageSectionHeader;
import java.util.List;
import org.apache.commons.lang3.Range;

public class AddressMap {
    List<ImageSectionHeader> originalSections;
    List<ImageSectionHeader> transformedSections;
    OMAPTable transformedToOriginal;
    OMAPTable originalToTransformed;

    public AddressMap(List<ImageSectionHeader> list, List<ImageSectionHeader> list2, OMAPTable oMAPTable, OMAPTable oMAPTable2) {
        this.originalSections = list;
        this.transformedSections = list2;
        this.transformedToOriginal = oMAPTable;
        this.originalToTransformed = oMAPTable2;
    }

    public RvaRangeIter rvaRanges(Range<Long> range) {
        if (this.originalToTransformed != null) {
            return new RvaRangeIter(this.originalToTransformed.lookupRange(range));
        }
        return new RvaRangeIter(RangeIter.identity(range));
    }

    public PdbInternalRvaRangeIter internalRvaRanges(Range<Long> range) {
        if (this.transformedToOriginal != null) {
            return new PdbInternalRvaRangeIter(this.transformedToOriginal.lookupRange(range));
        }
        return new PdbInternalRvaRangeIter(RangeIter.identity(range));
    }

    public static SectionOffset getSectionOffset(List<ImageSectionHeader> list, long l) {
        int n;
        ImageSectionHeader imageSectionHeader = null;
        for (n = 0; n < list.size() && ((imageSectionHeader = list.get(n)).getVirtualAddress() > l || l >= imageSectionHeader.getVirtualAddress() + imageSectionHeader.getSizeOfRawData()); ++n) {
        }
        assert (imageSectionHeader != null);
        return new SectionOffset(l - imageSectionHeader.getVirtualAddress(), n + 1);
    }

    public static Long getVirtualAddress(List<ImageSectionHeader> list, int n, long l) {
        if (--n < 0 || n >= list.size()) {
            return null;
        }
        ImageSectionHeader imageSectionHeader = list.get(n);
        return imageSectionHeader.getVirtualAddress() + l;
    }

    public List<ImageSectionHeader> getOriginalSections() {
        return this.originalSections;
    }

    public List<ImageSectionHeader> getTransformedSections() {
        return this.transformedSections;
    }

    public OMAPTable getTransformedToOriginal() {
        return this.transformedToOriginal;
    }

    public OMAPTable getOriginalToTransformed() {
        return this.originalToTransformed;
    }

    public void setOriginalSections(List<ImageSectionHeader> list) {
        this.originalSections = list;
    }

    public void setTransformedSections(List<ImageSectionHeader> list) {
        this.transformedSections = list;
    }

    public void setTransformedToOriginal(OMAPTable oMAPTable) {
        this.transformedToOriginal = oMAPTable;
    }

    public void setOriginalToTransformed(OMAPTable oMAPTable) {
        this.originalToTransformed = oMAPTable;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof AddressMap)) {
            return false;
        }
        AddressMap addressMap = (AddressMap)object;
        if (!addressMap.canEqual(this)) {
            return false;
        }
        List<ImageSectionHeader> list = this.getOriginalSections();
        List<ImageSectionHeader> list2 = addressMap.getOriginalSections();
        if (list == null ? list2 != null : !((Object)list).equals(list2)) {
            return false;
        }
        List<ImageSectionHeader> list3 = this.getTransformedSections();
        List<ImageSectionHeader> list4 = addressMap.getTransformedSections();
        if (list3 == null ? list4 != null : !((Object)list3).equals(list4)) {
            return false;
        }
        OMAPTable oMAPTable = this.getTransformedToOriginal();
        OMAPTable oMAPTable2 = addressMap.getTransformedToOriginal();
        if (oMAPTable == null ? oMAPTable2 != null : !((Object)oMAPTable).equals(oMAPTable2)) {
            return false;
        }
        OMAPTable oMAPTable3 = this.getOriginalToTransformed();
        OMAPTable oMAPTable4 = addressMap.getOriginalToTransformed();
        return !(oMAPTable3 == null ? oMAPTable4 != null : !((Object)oMAPTable3).equals(oMAPTable4));
    }

    protected boolean canEqual(Object object) {
        return object instanceof AddressMap;
    }

    public int hashCode() {
        int n = 59;
        int n2 = 1;
        List<ImageSectionHeader> list = this.getOriginalSections();
        n2 = n2 * 59 + (list == null ? 43 : ((Object)list).hashCode());
        List<ImageSectionHeader> list2 = this.getTransformedSections();
        n2 = n2 * 59 + (list2 == null ? 43 : ((Object)list2).hashCode());
        OMAPTable oMAPTable = this.getTransformedToOriginal();
        n2 = n2 * 59 + (oMAPTable == null ? 43 : ((Object)oMAPTable).hashCode());
        OMAPTable oMAPTable2 = this.getOriginalToTransformed();
        n2 = n2 * 59 + (oMAPTable2 == null ? 43 : ((Object)oMAPTable2).hashCode());
        return n2;
    }

    public String toString() {
        return "AddressMap(originalSections=" + this.getOriginalSections() + ", transformedSections=" + this.getTransformedSections() + ", transformedToOriginal=" + this.getTransformedToOriginal() + ", originalToTransformed=" + this.getOriginalToTransformed() + ")";
    }
}

