/*
 * Decompiled with CFR 0.152.
 */
package com.uqm.crashsight.symtabtool.pdb.module.source;

import com.uqm.crashsight.symtabtool.pdb.common.PdbInternalSectionOffset;
import com.uqm.crashsight.symtabtool.pdb.module.source.FileInfo;
import com.uqm.crashsight.symtabtool.pdb.module.source.LineInfo;
import com.uqm.crashsight.symtabtool.pdb.module.source.LineIterator;
import com.uqm.crashsight.symtabtool.pdb.module.source.LineProgram;
import com.uqm.crashsight.symtabtool.pdb.module.source.Lines;
import com.uqm.crashsight.symtabtool.pdb.module.source.LinesKey;
import com.uqm.crashsight.symtabtool.pdb.module.source.SourceFiles;
import com.uqm.crashsight.symtabtool.pdb.omap.AddressMap;
import com.uqm.crashsight.symtabtool.pdb.omap.PdbInternalRva;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;

public class SourceLineCollector {
    AddressMap addressMap;
    SourceFiles sourceFiles;
    LinkedHashMap<LinesKey, LineInfo> lines;
    LineProgram lineProgram;
    Map<Long, TreeMap<Long, LineInfo>> sectionIndex;

    public SourceLineCollector(AddressMap addressMap, SourceFiles sourceFiles, LineProgram lineProgram) {
        LineInfo lineInfo;
        LinkedHashMap<LinesKey, LineInfo> linkedHashMap = new LinkedHashMap<LinesKey, LineInfo>();
        LineIterator lineIterator = lineProgram.getLines();
        while ((lineInfo = lineIterator.next()) != null) {
            PdbInternalSectionOffset pdbInternalSectionOffset = lineInfo.offset;
            linkedHashMap.put(new LinesKey(pdbInternalSectionOffset.getSection(), pdbInternalSectionOffset.getOffset()), lineInfo);
        }
        this.addressMap = addressMap;
        this.sourceFiles = sourceFiles;
        this.lines = linkedHashMap;
        this.lineProgram = lineProgram;
        this.sectionIndex = new HashMap<Long, TreeMap<Long, LineInfo>>();
        for (Map.Entry entry : linkedHashMap.entrySet()) {
            LinesKey linesKey = (LinesKey)entry.getKey();
            this.sectionIndex.computeIfAbsent(Long.valueOf(linesKey.section), l -> new TreeMap()).put(linesKey.offset, entry.getValue());
        }
    }

    public Lines collectSourceLines(PdbInternalSectionOffset pdbInternalSectionOffset, long l) {
        Lines lines = new Lines();
        if (this.lines.isEmpty()) {
            return lines;
        }
        long l2 = pdbInternalSectionOffset.getOffset();
        long l3 = Long.MAX_VALUE;
        long l4 = 0L;
        TreeMap<Long, LineInfo> treeMap = this.sectionIndex.get(pdbInternalSectionOffset.getSection());
        if (treeMap != null) {
            SortedMap<Long, LineInfo> sortedMap = treeMap.subMap(l2, l2 + l);
            for (LineInfo lineInfo : sortedMap.values()) {
                PdbInternalRva pdbInternalRva = lineInfo.getOffset().toInternalRva(this.addressMap);
                if (l3 != lineInfo.getFileIndex()) {
                    FileInfo fileInfo = this.lineProgram.getFileInfo(lineInfo.getFileIndex());
                    l3 = lineInfo.getFileIndex();
                    l4 = this.sourceFiles.getId(fileInfo.getName());
                }
                lines.addLine(pdbInternalRva.getAddress(), lineInfo.getLineStart(), l4);
            }
        }
        return lines;
    }
}

