/*
 * Decompiled with CFR 0.152.
 */
package com.uqm.crashsight.symtabtool.pdb.module.source;

import com.uqm.crashsight.symtabtool.pdb.Module;
import com.uqm.crashsight.symtabtool.pdb.PDBInfo;
import com.uqm.crashsight.symtabtool.pdb.dbi.DebugInformation;
import com.uqm.crashsight.symtabtool.pdb.dbi.ModuleIter;
import com.uqm.crashsight.symtabtool.pdb.mapping.PathMappings;
import com.uqm.crashsight.symtabtool.pdb.module.ModuleInfo;
import com.uqm.crashsight.symtabtool.pdb.module.source.FileInfo;
import com.uqm.crashsight.symtabtool.pdb.module.source.FileIterator;
import com.uqm.crashsight.symtabtool.pdb.module.source.LineProgram;
import com.uqm.crashsight.symtabtool.pdb.strings.StringTable;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class SourceFiles {
    StringTable stringTable;
    Map<Long, Long> refToId = new LinkedHashMap<Long, Long>(0);
    List<Long> idToRef = new ArrayList<Long>(0);
    Map<String, String> mapping = null;

    public SourceFiles(PDBInfo pDBInfo, DebugInformation debugInformation, PathMappings pathMappings) {
        Module module;
        this.stringTable = pDBInfo.getStringTable();
        if (this.stringTable == null) {
            return;
        }
        ModuleIter moduleIter = debugInformation.getModules();
        long l = 0L;
        while ((module = moduleIter.next()) != null) {
            FileInfo fileInfo;
            ModuleInfo moduleInfo = pDBInfo.getModuleInfo(module);
            if (moduleInfo == null) continue;
            if (moduleInfo.getLinesSize() + moduleInfo.getSymbolsSize() > (long)moduleInfo.getBuffer().getBuffer().limit()) break;
            LineProgram lineProgram = moduleInfo.getLineProgram();
            if (lineProgram.inner.getFileChecksums() == null) continue;
            FileIterator fileIterator = lineProgram.getFiles();
            while ((fileInfo = fileIterator.next()) != null) {
                if (this.refToId.containsKey(fileInfo.name)) continue;
                this.refToId.put(fileInfo.name, l);
                this.idToRef.add(fileInfo.name);
                ++l;
            }
        }
    }

    public long getId(long l) {
        return this.refToId.get(l);
    }

    public List<String> getMapping() {
        if (this.stringTable == null) {
            return new ArrayList<String>(0);
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Long l : this.idToRef) {
            String string = this.stringTable.get(l);
            if (string == null) continue;
            arrayList.add(string);
        }
        return arrayList;
    }

    public StringTable getStringTable() {
        return this.stringTable;
    }

    public Map<Long, Long> getRefToId() {
        return this.refToId;
    }

    public List<Long> getIdToRef() {
        return this.idToRef;
    }

    public void setStringTable(StringTable stringTable) {
        this.stringTable = stringTable;
    }

    public void setRefToId(Map<Long, Long> map) {
        this.refToId = map;
    }

    public void setIdToRef(List<Long> list) {
        this.idToRef = list;
    }

    public void setMapping(Map<String, String> map) {
        this.mapping = map;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof SourceFiles)) {
            return false;
        }
        SourceFiles sourceFiles = (SourceFiles)object;
        if (!sourceFiles.canEqual(this)) {
            return false;
        }
        StringTable stringTable = this.getStringTable();
        StringTable stringTable2 = sourceFiles.getStringTable();
        if (stringTable == null ? stringTable2 != null : !((Object)stringTable).equals(stringTable2)) {
            return false;
        }
        Map<Long, Long> map = this.getRefToId();
        Map<Long, Long> map2 = sourceFiles.getRefToId();
        if (map == null ? map2 != null : !((Object)map).equals(map2)) {
            return false;
        }
        List<Long> list = this.getIdToRef();
        List<Long> list2 = sourceFiles.getIdToRef();
        if (list == null ? list2 != null : !((Object)list).equals(list2)) {
            return false;
        }
        List<String> list3 = this.getMapping();
        List<String> list4 = sourceFiles.getMapping();
        return !(list3 == null ? list4 != null : !((Object)list3).equals(list4));
    }

    protected boolean canEqual(Object object) {
        return object instanceof SourceFiles;
    }

    public int hashCode() {
        int n = 59;
        int n2 = 1;
        StringTable stringTable = this.getStringTable();
        n2 = n2 * 59 + (stringTable == null ? 43 : ((Object)stringTable).hashCode());
        Map<Long, Long> map = this.getRefToId();
        n2 = n2 * 59 + (map == null ? 43 : ((Object)map).hashCode());
        List<Long> list = this.getIdToRef();
        n2 = n2 * 59 + (list == null ? 43 : ((Object)list).hashCode());
        List<String> list2 = this.getMapping();
        n2 = n2 * 59 + (list2 == null ? 43 : ((Object)list2).hashCode());
        return n2;
    }

    public String toString() {
        return "SourceFiles(stringTable=" + this.getStringTable() + ", refToId=" + this.getRefToId() + ", idToRef=" + this.getIdToRef() + ", mapping=" + this.getMapping() + ")";
    }
}

