/*
 * Decompiled with CFR 0.152.
 */
package com.uqm.crashsight.symtabtool.pdb.module.c13;

import com.uqm.crashsight.symtabtool.pdb.module.c13.LineEntry;
import com.uqm.crashsight.symtabtool.pdb.module.c13.LineMarkerEntry;
import com.uqm.crashsight.symtabtool.pdb.module.c13.LineMarkerKind;
import com.uqm.crashsight.symtabtool.pdb.module.c13.LineNumberEntry;
import com.uqm.crashsight.symtabtool.pdb.module.source.LineInfoKind;
import com.uqm.crashsight.symtabtool.pdb.stream.ParseBuffer;

public class LineNumberHeader {
    public static final int SIZE = 8;
    long offset;
    long flags;

    public static LineNumberHeader parse(ParseBuffer parseBuffer) {
        LineNumberHeader lineNumberHeader = new LineNumberHeader();
        lineNumberHeader.offset = parseBuffer.readU32();
        lineNumberHeader.flags = parseBuffer.readU32();
        return lineNumberHeader;
    }

    public LineEntry parse() {
        long l = this.flags & 0xFFFFFFL;
        LineMarkerKind lineMarkerKind = null;
        if (l == 0xFEEFEEL) {
            lineMarkerKind = LineMarkerKind.DoNotStepOnto;
        } else if (l == 0xF00F00L) {
            lineMarkerKind = LineMarkerKind.DoNotStepInto;
        }
        if (lineMarkerKind != null) {
            LineMarkerEntry lineMarkerEntry = new LineMarkerEntry(this.offset, lineMarkerKind);
            return new LineEntry(null, lineMarkerEntry);
        }
        long l2 = l & 0xFFFFFFFFFFFFFF80L;
        long l3 = this.flags & 0x7FL;
        long l4 = l2 | l3;
        if (l4 < l) {
            l4 += 128L;
        }
        LineInfoKind lineInfoKind = (this.flags & Integer.MIN_VALUE) != 0L ? LineInfoKind.Statement : LineInfoKind.Expression;
        LineNumberEntry lineNumberEntry = new LineNumberEntry(this.offset, l, l4, lineInfoKind);
        return new LineEntry(lineNumberEntry, null);
    }
}

