/*
 * Decompiled with CFR 0.152.
 */
package com.uqm.crashsight.symtabtool.pdb.dbi;

import com.uqm.crashsight.symtabtool.pdb.dbi.DBIHeader;
import com.uqm.crashsight.symtabtool.pdb.dbi.DBISectionContributionIter;
import com.uqm.crashsight.symtabtool.pdb.dbi.MachineType;
import com.uqm.crashsight.symtabtool.pdb.dbi.ModuleIter;
import com.uqm.crashsight.symtabtool.pdb.stream.ParseBuffer;

public class DebugInformation {
    ParseBuffer buffer = null;
    DBIHeader header = null;
    long headLen;

    public static DebugInformation parse(ParseBuffer parseBuffer) {
        DebugInformation debugInformation = new DebugInformation();
        debugInformation.buffer = parseBuffer;
        debugInformation.header = DBIHeader.parse(parseBuffer);
        debugInformation.headLen = parseBuffer.pos();
        return debugInformation;
    }

    public MachineType getMachineType() {
        return MachineType.fromInt(this.header.getMachineType());
    }

    public ModuleIter getModules() {
        this.buffer.pos(this.headLen);
        return new ModuleIter(this.buffer, this.header.moduleListSize + this.headLen);
    }

    public DBISectionContributionIter getSectionContributes() {
        this.buffer.pos(this.headLen + this.header.getModuleListSize());
        ParseBuffer parseBuffer = new ParseBuffer(this.buffer.getBuffer(), this.buffer.pos(), this.buffer.pos() + this.header.getSectionContributionSize());
        return DBISectionContributionIter.parse(parseBuffer);
    }

    public void delete() {
        this.buffer = null;
        this.header = null;
    }

    public ParseBuffer getBuffer() {
        return this.buffer;
    }

    public DBIHeader getHeader() {
        return this.header;
    }

    public long getHeadLen() {
        return this.headLen;
    }

    public void setBuffer(ParseBuffer parseBuffer) {
        this.buffer = parseBuffer;
    }

    public void setHeader(DBIHeader dBIHeader) {
        this.header = dBIHeader;
    }

    public void setHeadLen(long l) {
        this.headLen = l;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof DebugInformation)) {
            return false;
        }
        DebugInformation debugInformation = (DebugInformation)object;
        if (!debugInformation.canEqual(this)) {
            return false;
        }
        if (this.getHeadLen() != debugInformation.getHeadLen()) {
            return false;
        }
        ParseBuffer parseBuffer = this.getBuffer();
        ParseBuffer parseBuffer2 = debugInformation.getBuffer();
        if (parseBuffer == null ? parseBuffer2 != null : !((Object)parseBuffer).equals(parseBuffer2)) {
            return false;
        }
        DBIHeader dBIHeader = this.getHeader();
        DBIHeader dBIHeader2 = debugInformation.getHeader();
        return !(dBIHeader == null ? dBIHeader2 != null : !((Object)dBIHeader).equals(dBIHeader2));
    }

    protected boolean canEqual(Object object) {
        return object instanceof DebugInformation;
    }

    public int hashCode() {
        int n = 59;
        int n2 = 1;
        long l = this.getHeadLen();
        n2 = n2 * 59 + (int)(l >>> 32 ^ l);
        ParseBuffer parseBuffer = this.getBuffer();
        n2 = n2 * 59 + (parseBuffer == null ? 43 : ((Object)parseBuffer).hashCode());
        DBIHeader dBIHeader = this.getHeader();
        n2 = n2 * 59 + (dBIHeader == null ? 43 : ((Object)dBIHeader).hashCode());
        return n2;
    }

    public String toString() {
        return "DebugInformation(buffer=" + this.getBuffer() + ", header=" + this.getHeader() + ", headLen=" + this.getHeadLen() + ")";
    }
}

