/*
 * Decompiled with CFR 0.152.
 */
package com.uqm.crashsight.symtabtool.pdb.dbi;

import com.uqm.crashsight.symtabtool.pdb.dbi.DBIHeader;
import com.uqm.crashsight.symtabtool.pdb.dbi.DebugInformation;
import com.uqm.crashsight.symtabtool.pdb.stream.ParseBuffer;

public class DBIExtraStreams {
    int fpo = -1;
    int exception = -1;
    int fixup = -1;
    int omapToSrc = -1;
    int omapFromSrc = -1;
    int sectionHeaders = -1;
    int tokenRidMap = -1;
    int xdata = -1;
    int pdata = -1;
    int framedata = -1;
    int originalSectionHeaders = -1;

    public DBIExtraStreams(DebugInformation debugInformation) {
        ParseBuffer parseBuffer = debugInformation.getBuffer();
        DBIHeader dBIHeader = debugInformation.getHeader();
        long l = debugInformation.getHeadLen() + dBIHeader.getModuleListSize() + dBIHeader.sectionContributionSize + dBIHeader.sectionMapSize + dBIHeader.fileInfoSize + dBIHeader.typeServerMapSize + dBIHeader.mfcTypeServerIndex + dBIHeader.ecSubstreamSize;
        parseBuffer.pos(l);
        this.fpo = parseBuffer.readU16();
        this.exception = parseBuffer.readU16();
        this.fixup = parseBuffer.readU16();
        this.omapToSrc = parseBuffer.readU16();
        this.omapFromSrc = parseBuffer.readU16();
        this.sectionHeaders = parseBuffer.readU16();
        this.tokenRidMap = parseBuffer.readU16();
        this.xdata = parseBuffer.readU16();
        this.pdata = parseBuffer.readU16();
        this.framedata = parseBuffer.readU16();
        this.originalSectionHeaders = parseBuffer.readU16();
    }

    public int getFpo() {
        return this.fpo;
    }

    public int getException() {
        return this.exception;
    }

    public int getFixup() {
        return this.fixup;
    }

    public int getOmapToSrc() {
        return this.omapToSrc;
    }

    public int getOmapFromSrc() {
        return this.omapFromSrc;
    }

    public int getSectionHeaders() {
        return this.sectionHeaders;
    }

    public int getTokenRidMap() {
        return this.tokenRidMap;
    }

    public int getXdata() {
        return this.xdata;
    }

    public int getPdata() {
        return this.pdata;
    }

    public int getFramedata() {
        return this.framedata;
    }

    public int getOriginalSectionHeaders() {
        return this.originalSectionHeaders;
    }

    public void setFpo(int n) {
        this.fpo = n;
    }

    public void setException(int n) {
        this.exception = n;
    }

    public void setFixup(int n) {
        this.fixup = n;
    }

    public void setOmapToSrc(int n) {
        this.omapToSrc = n;
    }

    public void setOmapFromSrc(int n) {
        this.omapFromSrc = n;
    }

    public void setSectionHeaders(int n) {
        this.sectionHeaders = n;
    }

    public void setTokenRidMap(int n) {
        this.tokenRidMap = n;
    }

    public void setXdata(int n) {
        this.xdata = n;
    }

    public void setPdata(int n) {
        this.pdata = n;
    }

    public void setFramedata(int n) {
        this.framedata = n;
    }

    public void setOriginalSectionHeaders(int n) {
        this.originalSectionHeaders = n;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof DBIExtraStreams)) {
            return false;
        }
        DBIExtraStreams dBIExtraStreams = (DBIExtraStreams)object;
        if (!dBIExtraStreams.canEqual(this)) {
            return false;
        }
        if (this.getFpo() != dBIExtraStreams.getFpo()) {
            return false;
        }
        if (this.getException() != dBIExtraStreams.getException()) {
            return false;
        }
        if (this.getFixup() != dBIExtraStreams.getFixup()) {
            return false;
        }
        if (this.getOmapToSrc() != dBIExtraStreams.getOmapToSrc()) {
            return false;
        }
        if (this.getOmapFromSrc() != dBIExtraStreams.getOmapFromSrc()) {
            return false;
        }
        if (this.getSectionHeaders() != dBIExtraStreams.getSectionHeaders()) {
            return false;
        }
        if (this.getTokenRidMap() != dBIExtraStreams.getTokenRidMap()) {
            return false;
        }
        if (this.getXdata() != dBIExtraStreams.getXdata()) {
            return false;
        }
        if (this.getPdata() != dBIExtraStreams.getPdata()) {
            return false;
        }
        if (this.getFramedata() != dBIExtraStreams.getFramedata()) {
            return false;
        }
        return this.getOriginalSectionHeaders() == dBIExtraStreams.getOriginalSectionHeaders();
    }

    protected boolean canEqual(Object object) {
        return object instanceof DBIExtraStreams;
    }

    public int hashCode() {
        int n = 59;
        int n2 = 1;
        n2 = n2 * 59 + this.getFpo();
        n2 = n2 * 59 + this.getException();
        n2 = n2 * 59 + this.getFixup();
        n2 = n2 * 59 + this.getOmapToSrc();
        n2 = n2 * 59 + this.getOmapFromSrc();
        n2 = n2 * 59 + this.getSectionHeaders();
        n2 = n2 * 59 + this.getTokenRidMap();
        n2 = n2 * 59 + this.getXdata();
        n2 = n2 * 59 + this.getPdata();
        n2 = n2 * 59 + this.getFramedata();
        n2 = n2 * 59 + this.getOriginalSectionHeaders();
        return n2;
    }

    public String toString() {
        return "DBIExtraStreams(fpo=" + this.getFpo() + ", exception=" + this.getException() + ", fixup=" + this.getFixup() + ", omapToSrc=" + this.getOmapToSrc() + ", omapFromSrc=" + this.getOmapFromSrc() + ", sectionHeaders=" + this.getSectionHeaders() + ", tokenRidMap=" + this.getTokenRidMap() + ", xdata=" + this.getXdata() + ", pdata=" + this.getPdata() + ", framedata=" + this.getFramedata() + ", originalSectionHeaders=" + this.getOriginalSectionHeaders() + ")";
    }
}

