/*
 * Decompiled with CFR 0.152.
 */
package com.uqm.crashsight.symtabtool.pdb;

import com.uqm.crashsight.symtabtool.common.file.BinaryFileReader;
import com.uqm.crashsight.symtabtool.common.utils.Log;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;

public class PdbHeaderParser {
    public static final int HEADER_LENGTH = 52;
    public static final String SIGNATURE = "Microsoft C/C++ MSF 7.00\r\n\u001aDS\u0000\u0000";
    public String fileName = null;
    public BinaryFileReader binaryFileReader = null;
    public byte[] signature;
    public int pageSize;
    public int freePageMap;
    public int pagesUsed;
    public int directorySize;
    public long reserved;

    public PdbHeaderParser(String string) {
        this.fileName = string;
    }

    public static boolean isPdb(String string) {
        try {
            BinaryFileReader binaryFileReader = new BinaryFileReader(string);
            byte[] byArray = SIGNATURE.getBytes(StandardCharsets.UTF_8);
            byte[] byArray2 = new byte[byArray.length];
            binaryFileReader.readByteArray(byArray2);
            return Arrays.equals(byArray2, byArray);
        }
        catch (Exception exception) {
            Log.error(exception);
            return false;
        }
    }

    boolean parseHeader() {
        try {
            this.signature = new byte[32];
            this.binaryFileReader.readByteArray(this.signature);
            this.pageSize = this.binaryFileReader.readInt();
            this.freePageMap = this.binaryFileReader.readInt();
            this.pagesUsed = this.binaryFileReader.readInt();
            this.directorySize = this.binaryFileReader.readInt();
            this.reserved = this.binaryFileReader.readUInt();
            return true;
        }
        catch (Exception exception) {
            Log.error(exception);
            return false;
        }
    }

    private boolean openFile() {
        if (null != this.binaryFileReader) {
            this.close();
        }
        try {
            this.binaryFileReader = new BinaryFileReader(this.fileName);
        }
        catch (Exception exception) {
            Log.error(exception);
            return false;
        }
        return true;
    }

    public void close() {
        if (null == this.binaryFileReader) {
            return;
        }
        if (!this.binaryFileReader.close()) {
            Log.error("Failed to open file\uff1a%s", this.fileName);
            return;
        }
        this.binaryFileReader = null;
    }

    private boolean parse() {
        if (!this.openFile()) {
            return false;
        }
        if (!this.parseHeader()) {
            this.close();
            return false;
        }
        this.close();
        return true;
    }

    public static PdbHeaderParser create(String string) {
        PdbHeaderParser pdbHeaderParser = new PdbHeaderParser(string);
        if (!pdbHeaderParser.parse()) {
            return null;
        }
        return pdbHeaderParser;
    }
}

