/*
 * Decompiled with CFR 0.152.
 */
package com.uqm.crashsight.symtabtool.pdb;

import com.uqm.crashsight.symtabtool.pdb.PDBInfo;
import com.uqm.crashsight.symtabtool.pdb.pe.ImageSectionHeader;
import java.util.List;
import java.util.stream.Collectors;

public class PDBSections {
    public static final long IMAGE_SCN_CNT_CODE = 32L;
    public static final long IMAGE_SCN_MEM_EXECUTE = 0x20000000L;
    List<Boolean> sections;

    public PDBSections(PDBInfo pDBInfo) {
        List<ImageSectionHeader> list = pDBInfo.getSections();
        this.sections = list.stream().map(imageSectionHeader -> this.hasCode(imageSectionHeader.getCharacteristics())).collect(Collectors.toList());
    }

    public boolean hasCode(long l) {
        return (l & 0x20000020L) != 0L;
    }

    public boolean isCode(int n) {
        if (this.sections.size() > n) {
            return this.sections.get(n);
        }
        return false;
    }

    public List<Boolean> getSections() {
        return this.sections;
    }

    public void setSections(List<Boolean> list) {
        this.sections = list;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof PDBSections)) {
            return false;
        }
        PDBSections pDBSections = (PDBSections)object;
        if (!pDBSections.canEqual(this)) {
            return false;
        }
        List<Boolean> list = this.getSections();
        List<Boolean> list2 = pDBSections.getSections();
        return !(list == null ? list2 != null : !((Object)list).equals(list2));
    }

    protected boolean canEqual(Object object) {
        return object instanceof PDBSections;
    }

    public int hashCode() {
        int n = 59;
        int n2 = 1;
        List<Boolean> list = this.getSections();
        n2 = n2 * 59 + (list == null ? 43 : ((Object)list).hashCode());
        return n2;
    }

    public String toString() {
        return "PDBSections(sections=" + this.getSections() + ")";
    }
}

