/*
 * Decompiled with CFR 0.152.
 */
package com.uqm.crashsight.symtabtool.pdb;

import com.uqm.crashsight.symtabtool.common.utils.Log;
import com.uqm.crashsight.symtabtool.pdb.Collector;
import com.uqm.crashsight.symtabtool.pdb.Cpu;
import com.uqm.crashsight.symtabtool.pdb.DumpSymType;
import com.uqm.crashsight.symtabtool.pdb.Module;
import com.uqm.crashsight.symtabtool.pdb.PDBContributions;
import com.uqm.crashsight.symtabtool.pdb.PDBData;
import com.uqm.crashsight.symtabtool.pdb.PDBSections;
import com.uqm.crashsight.symtabtool.pdb.dbi.DBIExtraStreams;
import com.uqm.crashsight.symtabtool.pdb.dbi.DBIHeader;
import com.uqm.crashsight.symtabtool.pdb.dbi.DebugInformation;
import com.uqm.crashsight.symtabtool.pdb.dbi.MachineType;
import com.uqm.crashsight.symtabtool.pdb.framedata.FrameTable;
import com.uqm.crashsight.symtabtool.pdb.module.ModuleInfo;
import com.uqm.crashsight.symtabtool.pdb.module.PSymbolTable;
import com.uqm.crashsight.symtabtool.pdb.module.source.SourceFiles;
import com.uqm.crashsight.symtabtool.pdb.omap.AddressMap;
import com.uqm.crashsight.symtabtool.pdb.omap.OMAPTable;
import com.uqm.crashsight.symtabtool.pdb.pdbi.PDBInformation;
import com.uqm.crashsight.symtabtool.pdb.pdbi.StreamName;
import com.uqm.crashsight.symtabtool.pdb.pdbi.StreamNames;
import com.uqm.crashsight.symtabtool.pdb.pe.ImageSectionHeader;
import com.uqm.crashsight.symtabtool.pdb.stream.ParseBuffer;
import com.uqm.crashsight.symtabtool.pdb.stream.StreamManager;
import com.uqm.crashsight.symtabtool.pdb.strings.StringTable;
import com.uqm.crashsight.symtabtool.pdb.symbol.PDBSymbol;
import com.uqm.crashsight.symtabtool.pdb.symbol.PDBSymbols;
import com.uqm.crashsight.symtabtool.pdb.symbol.RvaSymbols;
import com.uqm.crashsight.symtabtool.pdb.symbol.Symbol;
import com.uqm.crashsight.symtabtool.pdb.tpi.ItemInformation;
import com.uqm.crashsight.symtabtool.pdb.types.DumperFlags;
import com.uqm.crashsight.symtabtool.pdb.types.TypeDumper;
import com.uqm.crashsight.symtabtool.pe.PeObject;
import java.io.BufferedWriter;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.codec.binary.Hex;

public class PDBInfo {
    PDBSymbols symbols;
    List<String> files;
    Cpu cpu;
    String debugId;
    String pdbName;
    String peName;
    String codeId;
    String stack;
    DBIExtraStreams dbiExtraStreams = null;
    PDBInformation pi = null;
    ParseBuffer oldStream = null;
    ParseBuffer newStream = null;
    FrameTable frameTable = null;
    boolean parsed = false;

    public PDBInfo(ParseBuffer parseBuffer, String string, String string2, PeObject peObject) {
        long l;
        String string3 = Paths.get(string, new String[0]).getFileName().toString();
        long l2 = l = System.currentTimeMillis();
        DebugInformation debugInformation = this.getDebugInformation();
        if (debugInformation == null) {
            Log.warn("The pdb file does not have debug infor header.", new Object[0]);
            return;
        }
        PDBInformation pDBInformation = this.getPdbInformation();
        FrameTable frameTable = this.getFrameTable();
        PDBSections pDBSections = new PDBSections(this);
        PDBContributions pDBContributions = new PDBContributions(debugInformation, pDBSections);
        l2 = System.currentTimeMillis();
        Log.info("prepare stream cost[%d]", l2 - l);
        l = l2;
        Cpu cpu = this.getCpu(debugInformation);
        if (!cpu.equals((Object)Cpu.X86_64)) {
            Log.warn("Unsupport pdb file which machine type is " + cpu.toString(), new Object[0]);
            return;
        }
        String string4 = this.getDebugId(debugInformation, pDBInformation);
        SourceFiles sourceFiles = new SourceFiles(this, debugInformation, null);
        l2 = System.currentTimeMillis();
        Log.info("SourceFiles cost[%d]", l2 - l);
        l = l2;
        PDBData pDBData = new PDBData(this.getAddressMap());
        Collector collector = new Collector(cpu, RvaSymbols.empty(), pDBSections, pDBContributions);
        pDBData.collectFunctions(this, debugInformation, collector, sourceFiles);
        l2 = System.currentTimeMillis();
        Log.info("collectFunctions cost[%d]", l2 - l);
        l = l2;
        PSymbolTable pSymbolTable = this.getGlobalSymbols(debugInformation.getHeader());
        debugInformation.delete();
        debugInformation = null;
        pDBData.collectPublicSymbols(pSymbolTable, collector);
        l2 = System.currentTimeMillis();
        Log.info("collectPublicSymbols cost[%d]", l2 - l);
        l = l2;
        pSymbolTable.delete();
        pSymbolTable = null;
        ItemInformation itemInformation = this.getTypeInformation();
        TypeDumper typeDumper = new TypeDumper(itemInformation, cpu.getPtrSize(), DumperFlags.empty());
        l2 = System.currentTimeMillis();
        Log.info("getTypeInformation cost[%d]", l2 - l);
        l = l2;
        peObject = new PeObject(string, "PDB");
        Log.info("begin to moveToPdbSymbols", new Object[0]);
        PDBSymbols pDBSymbols = collector.symbols.moveToPdbSymbols(typeDumper, pDBData.addressMap, frameTable);
        Log.info("moveToPdbSymbols cost[%d]", System.currentTimeMillis() - l);
        this.symbols = Symbol.appendDummySymbol(pDBSymbols, string2);
        this.files = sourceFiles.getMapping();
        this.cpu = cpu;
        this.debugId = string4;
        this.pdbName = string3;
        this.parsed = true;
    }

    public PDBInfo() {
    }

    public String parseDebugId() {
        long l = System.currentTimeMillis();
        DebugInformation debugInformation = this.getDebugInformation();
        if (debugInformation == null) {
            Log.warn("The pdb file does not have debug info header.", new Object[0]);
            return null;
        }
        PDBInformation pDBInformation = this.getPdbInformation();
        Log.info("parseDebugId cost[%d]", System.currentTimeMillis() - l);
        return this.getDebugId(debugInformation, pDBInformation);
    }

    public DebugInformation getDebugInformation() {
        ParseBuffer parseBuffer = StreamManager.getInstance().getParseBuffer(3);
        if (parseBuffer == null) {
            return null;
        }
        return DebugInformation.parse(parseBuffer);
    }

    private PDBInformation getPdbInformation() {
        if (this.pi == null) {
            ParseBuffer parseBuffer = StreamManager.getInstance().getParseBuffer(1);
            this.pi = PDBInformation.parse(parseBuffer);
        }
        return this.pi;
    }

    private PSymbolTable getGlobalSymbols(DBIHeader dBIHeader) {
        ParseBuffer parseBuffer = StreamManager.getInstance().getParseBuffer(dBIHeader.getSymbolRecordsStream());
        return new PSymbolTable(parseBuffer);
    }

    private DBIExtraStreams getExtraStreams() {
        DBIExtraStreams dBIExtraStreams;
        if (this.dbiExtraStreams != null) {
            return this.dbiExtraStreams;
        }
        DebugInformation debugInformation = this.getDebugInformation();
        this.dbiExtraStreams = dBIExtraStreams = new DBIExtraStreams(debugInformation);
        return dBIExtraStreams;
    }

    public List<ImageSectionHeader> getSections() {
        int n = this.getExtraStreams().getSectionHeaders();
        ParseBuffer parseBuffer = StreamManager.getInstance().getParseBuffer(n);
        ArrayList<ImageSectionHeader> arrayList = new ArrayList<ImageSectionHeader>();
        while (parseBuffer.getBuffer().hasRemaining()) {
            arrayList.add(ImageSectionHeader.parse(parseBuffer));
        }
        return arrayList;
    }

    public Cpu getCpu(DebugInformation debugInformation) {
        MachineType machineType = debugInformation.getMachineType();
        switch (machineType) {
            case X86: {
                return Cpu.X86;
            }
            case Amd64: 
            case Ia64: {
                return Cpu.X86_64;
            }
        }
        return Cpu.Unknown;
    }

    public String getDebugId(DebugInformation debugInformation, PDBInformation pDBInformation) {
        String string = Hex.encodeHexString(pDBInformation.getGuid().getBytes()).toUpperCase();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(string);
        stringBuilder.append(Long.toHexString(debugInformation.getHeader().getAge()));
        return stringBuilder.toString().toUpperCase();
    }

    public String getStackInfo(PeObject peObject) {
        return peObject.processCfi();
    }

    public ParseBuffer getNamedStream(String string) {
        PDBInformation pDBInformation = this.getPdbInformation();
        StreamNames streamNames = pDBInformation.getStreamNames();
        for (StreamName streamName : streamNames.getNames()) {
            if (!streamName.getName().equalsIgnoreCase(string)) continue;
            return StreamManager.getInstance().getParseBuffer(streamName.getStreamId());
        }
        Log.error("Name[%s] stream not found!", string);
        return null;
    }

    public StringTable getStringTable() {
        ParseBuffer parseBuffer = this.getNamedStream("/names");
        if (parseBuffer != null) {
            return StringTable.parse(parseBuffer);
        }
        return new StringTable();
    }

    public ModuleInfo getModuleInfo(Module module) {
        ParseBuffer parseBuffer = StreamManager.getInstance().getParseBuffer(module.getInfo().getStream());
        return ModuleInfo.parse(parseBuffer, module);
    }

    public ParseBuffer getOldStream() {
        if (this.oldStream != null) {
            return this.oldStream;
        }
        DBIExtraStreams dBIExtraStreams = this.getExtraStreams();
        this.oldStream = StreamManager.getInstance().getParseBuffer(dBIExtraStreams.getFpo());
        if (this.oldStream == null) {
            this.oldStream = ParseBuffer.empty();
        }
        return this.oldStream;
    }

    public ParseBuffer getNewStream() {
        if (this.newStream != null) {
            return this.newStream;
        }
        DBIExtraStreams dBIExtraStreams = this.getExtraStreams();
        this.newStream = StreamManager.getInstance().getParseBuffer(dBIExtraStreams.getFramedata());
        if (this.newStream == null) {
            this.newStream = ParseBuffer.empty();
        }
        return this.newStream;
    }

    public FrameTable getFrameTable() {
        if (this.frameTable != null) {
            return this.frameTable;
        }
        this.frameTable = FrameTable.parse(this.getOldStream(), this.getNewStream());
        return this.frameTable;
    }

    public List<ImageSectionHeader> getOriginSections() {
        int n = this.getExtraStreams().getOriginalSectionHeaders();
        ParseBuffer parseBuffer = StreamManager.getInstance().getParseBuffer(n);
        if (parseBuffer == null) {
            return null;
        }
        ArrayList<ImageSectionHeader> arrayList = new ArrayList<ImageSectionHeader>();
        while (parseBuffer.getBuffer().hasRemaining()) {
            arrayList.add(ImageSectionHeader.parse(parseBuffer));
        }
        return arrayList;
    }

    public OMAPTable getOmapFromSrc() {
        int n = this.getExtraStreams().getOmapFromSrc();
        ParseBuffer parseBuffer = StreamManager.getInstance().getParseBuffer(n);
        if (parseBuffer == null) {
            return null;
        }
        return OMAPTable.parse(parseBuffer);
    }

    public OMAPTable getOmapToSrc() {
        int n = this.getExtraStreams().getOmapToSrc();
        ParseBuffer parseBuffer = StreamManager.getInstance().getParseBuffer(n);
        if (parseBuffer == null) {
            return null;
        }
        return OMAPTable.parse(parseBuffer);
    }

    public AddressMap getAddressMap() {
        List<ImageSectionHeader> list = this.getSections();
        List<ImageSectionHeader> list2 = this.getOriginSections();
        if (list2 == null) {
            return new AddressMap(list, null, null, null);
        }
        OMAPTable oMAPTable = this.getOmapFromSrc();
        OMAPTable oMAPTable2 = this.getOmapToSrc();
        return new AddressMap(list2, list, oMAPTable, oMAPTable2);
    }

    public ItemInformation getTypeInformation() {
        ParseBuffer parseBuffer = StreamManager.getInstance().getParseBuffer(2);
        return ItemInformation.parse(parseBuffer);
    }

    public ItemInformation getIdInformation() {
        ParseBuffer parseBuffer = StreamManager.getInstance().getParseBuffer(4);
        return ItemInformation.parse(parseBuffer);
    }

    public void display(BufferedWriter bufferedWriter, DumpSymType dumpSymType) {
        try {
            bufferedWriter.write(String.format("MODULE windows %s %s %s\n", new Object[]{this.cpu, this.debugId, this.pdbName}));
            if (this.codeId != null && !this.codeId.isEmpty()) {
                bufferedWriter.write(String.format("INFO CODE_ID %s %s\n", this.codeId, this.peName));
            }
            if (dumpSymType == DumpSymType.DumpAll) {
                for (int i = 0; i < this.files.size(); ++i) {
                    bufferedWriter.write(String.format("FILE %d %s\n", i, this.files.get(i)));
                }
                for (PDBSymbol pDBSymbol : this.symbols.getMap().values()) {
                    pDBSymbol.display(bufferedWriter);
                }
            }
            bufferedWriter.write(String.format("%s\n", this.stack));
        }
        catch (Exception exception) {
            Log.error(exception);
        }
    }

    public PDBSymbols getSymbols() {
        return this.symbols;
    }

    public List<String> getFiles() {
        return this.files;
    }

    public Cpu getCpu() {
        return this.cpu;
    }

    public String getDebugId() {
        return this.debugId;
    }

    public String getPdbName() {
        return this.pdbName;
    }

    public String getPeName() {
        return this.peName;
    }

    public String getCodeId() {
        return this.codeId;
    }

    public String getStack() {
        return this.stack;
    }

    public DBIExtraStreams getDbiExtraStreams() {
        return this.dbiExtraStreams;
    }

    public PDBInformation getPi() {
        return this.pi;
    }

    public boolean isParsed() {
        return this.parsed;
    }

    public void setSymbols(PDBSymbols pDBSymbols) {
        this.symbols = pDBSymbols;
    }

    public void setFiles(List<String> list) {
        this.files = list;
    }

    public void setCpu(Cpu cpu) {
        this.cpu = cpu;
    }

    public void setDebugId(String string) {
        this.debugId = string;
    }

    public void setPdbName(String string) {
        this.pdbName = string;
    }

    public void setPeName(String string) {
        this.peName = string;
    }

    public void setCodeId(String string) {
        this.codeId = string;
    }

    public void setStack(String string) {
        this.stack = string;
    }

    public void setDbiExtraStreams(DBIExtraStreams dBIExtraStreams) {
        this.dbiExtraStreams = dBIExtraStreams;
    }

    public void setPi(PDBInformation pDBInformation) {
        this.pi = pDBInformation;
    }

    public void setOldStream(ParseBuffer parseBuffer) {
        this.oldStream = parseBuffer;
    }

    public void setNewStream(ParseBuffer parseBuffer) {
        this.newStream = parseBuffer;
    }

    public void setFrameTable(FrameTable frameTable) {
        this.frameTable = frameTable;
    }

    public void setParsed(boolean bl) {
        this.parsed = bl;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof PDBInfo)) {
            return false;
        }
        PDBInfo pDBInfo = (PDBInfo)object;
        if (!pDBInfo.canEqual(this)) {
            return false;
        }
        if (this.isParsed() != pDBInfo.isParsed()) {
            return false;
        }
        PDBSymbols pDBSymbols = this.getSymbols();
        PDBSymbols pDBSymbols2 = pDBInfo.getSymbols();
        if (pDBSymbols == null ? pDBSymbols2 != null : !((Object)pDBSymbols).equals(pDBSymbols2)) {
            return false;
        }
        List<String> list = this.getFiles();
        List<String> list2 = pDBInfo.getFiles();
        if (list == null ? list2 != null : !((Object)list).equals(list2)) {
            return false;
        }
        Cpu cpu = this.getCpu();
        Cpu cpu2 = pDBInfo.getCpu();
        if (cpu == null ? cpu2 != null : !((Object)((Object)cpu)).equals((Object)cpu2)) {
            return false;
        }
        String string = this.getDebugId();
        String string2 = pDBInfo.getDebugId();
        if (string == null ? string2 != null : !string.equals(string2)) {
            return false;
        }
        String string3 = this.getPdbName();
        String string4 = pDBInfo.getPdbName();
        if (string3 == null ? string4 != null : !string3.equals(string4)) {
            return false;
        }
        String string5 = this.getPeName();
        String string6 = pDBInfo.getPeName();
        if (string5 == null ? string6 != null : !string5.equals(string6)) {
            return false;
        }
        String string7 = this.getCodeId();
        String string8 = pDBInfo.getCodeId();
        if (string7 == null ? string8 != null : !string7.equals(string8)) {
            return false;
        }
        String string9 = this.getStack();
        String string10 = pDBInfo.getStack();
        if (string9 == null ? string10 != null : !string9.equals(string10)) {
            return false;
        }
        DBIExtraStreams dBIExtraStreams = this.getDbiExtraStreams();
        DBIExtraStreams dBIExtraStreams2 = pDBInfo.getDbiExtraStreams();
        if (dBIExtraStreams == null ? dBIExtraStreams2 != null : !((Object)dBIExtraStreams).equals(dBIExtraStreams2)) {
            return false;
        }
        PDBInformation pDBInformation = this.getPi();
        PDBInformation pDBInformation2 = pDBInfo.getPi();
        if (pDBInformation == null ? pDBInformation2 != null : !((Object)pDBInformation).equals(pDBInformation2)) {
            return false;
        }
        ParseBuffer parseBuffer = this.getOldStream();
        ParseBuffer parseBuffer2 = pDBInfo.getOldStream();
        if (parseBuffer == null ? parseBuffer2 != null : !((Object)parseBuffer).equals(parseBuffer2)) {
            return false;
        }
        ParseBuffer parseBuffer3 = this.getNewStream();
        ParseBuffer parseBuffer4 = pDBInfo.getNewStream();
        if (parseBuffer3 == null ? parseBuffer4 != null : !((Object)parseBuffer3).equals(parseBuffer4)) {
            return false;
        }
        FrameTable frameTable = this.getFrameTable();
        FrameTable frameTable2 = pDBInfo.getFrameTable();
        return !(frameTable == null ? frameTable2 != null : !((Object)frameTable).equals(frameTable2));
    }

    protected boolean canEqual(Object object) {
        return object instanceof PDBInfo;
    }

    public int hashCode() {
        int n = 59;
        int n2 = 1;
        n2 = n2 * 59 + (this.isParsed() ? 79 : 97);
        PDBSymbols pDBSymbols = this.getSymbols();
        n2 = n2 * 59 + (pDBSymbols == null ? 43 : ((Object)pDBSymbols).hashCode());
        List<String> list = this.getFiles();
        n2 = n2 * 59 + (list == null ? 43 : ((Object)list).hashCode());
        Cpu cpu = this.getCpu();
        n2 = n2 * 59 + (cpu == null ? 43 : ((Object)((Object)cpu)).hashCode());
        String string = this.getDebugId();
        n2 = n2 * 59 + (string == null ? 43 : string.hashCode());
        String string2 = this.getPdbName();
        n2 = n2 * 59 + (string2 == null ? 43 : string2.hashCode());
        String string3 = this.getPeName();
        n2 = n2 * 59 + (string3 == null ? 43 : string3.hashCode());
        String string4 = this.getCodeId();
        n2 = n2 * 59 + (string4 == null ? 43 : string4.hashCode());
        String string5 = this.getStack();
        n2 = n2 * 59 + (string5 == null ? 43 : string5.hashCode());
        DBIExtraStreams dBIExtraStreams = this.getDbiExtraStreams();
        n2 = n2 * 59 + (dBIExtraStreams == null ? 43 : ((Object)dBIExtraStreams).hashCode());
        PDBInformation pDBInformation = this.getPi();
        n2 = n2 * 59 + (pDBInformation == null ? 43 : ((Object)pDBInformation).hashCode());
        ParseBuffer parseBuffer = this.getOldStream();
        n2 = n2 * 59 + (parseBuffer == null ? 43 : ((Object)parseBuffer).hashCode());
        ParseBuffer parseBuffer2 = this.getNewStream();
        n2 = n2 * 59 + (parseBuffer2 == null ? 43 : ((Object)parseBuffer2).hashCode());
        FrameTable frameTable = this.getFrameTable();
        n2 = n2 * 59 + (frameTable == null ? 43 : ((Object)frameTable).hashCode());
        return n2;
    }

    public String toString() {
        return "PDBInfo(symbols=" + this.getSymbols() + ", files=" + this.getFiles() + ", cpu=" + (Object)((Object)this.getCpu()) + ", debugId=" + this.getDebugId() + ", pdbName=" + this.getPdbName() + ", peName=" + this.getPeName() + ", codeId=" + this.getCodeId() + ", stack=" + this.getStack() + ", dbiExtraStreams=" + this.getDbiExtraStreams() + ", pi=" + this.getPi() + ", oldStream=" + this.getOldStream() + ", newStream=" + this.getNewStream() + ", frameTable=" + this.getFrameTable() + ", parsed=" + this.isParsed() + ")";
    }
}

