/*
 * Decompiled with CFR 0.152.
 */
package com.uqm.crashsight.symtabtool.mach;

import com.uqm.crashsight.symtabtool.common.Section;
import com.uqm.crashsight.symtabtool.common.Subroutine;
import com.uqm.crashsight.symtabtool.common.file.BinaryFileReader;
import com.uqm.crashsight.symtabtool.common.utils.Log;
import com.uqm.crashsight.symtabtool.common.utils.Utils;
import com.uqm.crashsight.symtabtool.dwarf.DwarfInfoBean;
import com.uqm.crashsight.symtabtool.dwarf.DwarfParser;
import com.uqm.crashsight.symtabtool.mach.MachCommandParser;
import com.uqm.crashsight.symtabtool.mach.MachHeaderParser;
import com.uqm.crashsight.symtabtool.mach.MachStringParser;
import com.uqm.crashsight.symtabtool.mach.MachSymtabParser;
import com.uqm.crashsight.symtabtool.symtab.SymbolTable;
import com.uqm.crashsight.symtabtool.symtab.SymtabMerger;
import java.util.HashMap;
import java.util.Vector;

public class MachParser {
    public static final long INVALID_ADDRESS = -1L;
    public static final long FILE_FORMAT_INVALID = 0L;
    public static final long FILE_FORMAT_32 = 32L;
    public static final long FILE_FORMAT_64 = 64L;
    public static final String TEXT_SECTION = "__text";
    public static final String DEBUG_INFO_SECTION = "__debug_info";
    public static final String DEBUG_ABBREV_SECTION = "__debug_abbrev";
    public static final String DEBUG_LINE_SECTION = "__debug_line";
    public static final String DEBUG_RANGES_SECTION = "__debug_ranges";
    public static final String DEBUG_STR_SECTION = "__debug_str";
    public static final String DEBUG_PUBNAMES_SECTION = "__debug_pubnames";
    public static final String DEBUG_STR_OFFS_SECTION = "__debug_str_offs";
    public static final String DEBUG_LINE_STR_SECTION = "__debug_line_str";
    public static final String DEBUG_RNGLISTS_SECTION = "__debug_rnglists";
    public static final String DEBUG_ADDR_SECTION = "__debug_addr";
    private String fileName = null;
    private BinaryFileReader binaryFileReader = null;
    private MachHeaderParser header = null;
    private long fileFormat = 0L;
    private long endian = 0L;
    private byte[] uuid = null;
    private long vmAddr = -1L;
    private HashMap<String, Section> sectionTable = null;
    private Vector<Subroutine> subroutineTable = null;
    private SymbolTable symbolTable = null;

    public String getFileName() {
        return this.fileName;
    }

    public long getFileFormat() {
        return this.fileFormat;
    }

    public long getEndian() {
        return this.endian;
    }

    public String getArch() {
        return this.header.getArch();
    }

    public static String getArch(String string, long l) {
        MachParser machParser = new MachParser(string);
        Log.info("Begin to parse file: %s", string);
        if (!machParser.openFile()) {
            return null;
        }
        if (!machParser.binaryFileReader.skip(l)) {
            return null;
        }
        if (!machParser.parseHeaderInfo()) {
            Log.error("Failed to parse header", new Object[0]);
            return null;
        }
        Log.info("Architecture: %s", machParser.header.getArch());
        String string2 = machParser.header.getArch();
        machParser.closeFile();
        return string2;
    }

    public String getUuid() {
        return Utils.byteArrayToHexString(this.uuid);
    }

    public static String getUuid(String string, long l) {
        MachParser machParser = new MachParser(string);
        Log.info("Begin to parse file: %s", string);
        if (!machParser.openFile()) {
            return null;
        }
        if (!machParser.binaryFileReader.skip(l)) {
            return null;
        }
        if (!machParser.parseHeaderInfo()) {
            Log.error("Failed to parse header", new Object[0]);
            return null;
        }
        Log.info("Architecture: %s", machParser.header.getArch());
        if (!machParser.parseCommand(l)) {
            Log.error("Failed to parse command", new Object[0]);
            return null;
        }
        Log.info("Successfully parsed the file!", new Object[0]);
        String string2 = machParser.getUuid();
        machParser.closeFile();
        return string2;
    }

    public long getVmAddr() {
        return this.vmAddr;
    }

    public SymbolTable getSymbolTable() {
        return this.symbolTable;
    }

    public HashMap<String, Section> getSectionTable() {
        return this.sectionTable;
    }

    private void setFileName(String string) {
        this.fileName = string;
    }

    private void setFileFormat(long l) {
        this.fileFormat = l;
    }

    private void setEndian(long l) {
        this.endian = l;
    }

    private void setSymbolTable(SymbolTable symbolTable) {
        this.symbolTable = symbolTable;
    }

    private void closeFile() {
        if (null != this.binaryFileReader) {
            this.binaryFileReader.close();
            this.binaryFileReader = null;
        }
    }

    public void close() {
        this.closeFile();
    }

    private boolean openFile() {
        if (null != this.binaryFileReader) {
            this.closeFile();
        }
        try {
            this.binaryFileReader = new BinaryFileReader(this.fileName);
        }
        catch (Exception exception) {
            Log.error(exception);
            return false;
        }
        return true;
    }

    private MachParser(String string) {
        this.setFileName(string);
    }

    private boolean parseHeaderInfo() {
        this.header = new MachHeaderParser();
        if (!this.header.parse(this.binaryFileReader)) {
            return false;
        }
        this.setFileFormat(this.header.getFileFormat());
        this.setEndian(this.header.getEndian());
        return true;
    }

    private boolean parseSectionInfoTable(Vector<Section> vector, long l) {
        if (null == vector || vector.isEmpty()) {
            return false;
        }
        this.sectionTable = new HashMap();
        long l2 = 0L;
        boolean bl = true;
        for (Section section : vector) {
            if (section.getSegmentName().equals("__DWARF")) {
                if (bl) {
                    bl = false;
                    l2 = section.getOffset();
                }
                section.setOffset(l2 + l);
                l2 += section.getSize();
            } else {
                section.setOffset(l + section.getOffset());
            }
            this.sectionTable.put(section.getName(), section);
        }
        return true;
    }

    private boolean parseSubroutineTable(long l, MachCommandParser.MachSymtabCommand machSymtabCommand, Vector<Section> vector) {
        long l2;
        long l3 = machSymtabCommand.getStrtabOffset() + l;
        long l4 = machSymtabCommand.getStrtabSize();
        MachStringParser machStringParser = new MachStringParser(this.fileName, l3, l4);
        MachSymtabParser machSymtabParser = new MachSymtabParser(this.fileName, this.fileFormat, this.endian);
        long l5 = machSymtabCommand.getSymtabOffset() + l;
        Vector<MachSymtabParser.MachSymtabEntry> vector2 = machSymtabParser.getSubroutineTable(l5, l2 = machSymtabCommand.getEntryNumber());
        if (null == vector2) {
            return false;
        }
        this.fillSymtab(vector2, vector, machStringParser);
        return true;
    }

    private void fillSymtab(Vector<MachSymtabParser.MachSymtabEntry> vector, Vector<Section> vector2, MachStringParser machStringParser) {
        this.subroutineTable = new Vector();
        if (vector.isEmpty()) {
            return;
        }
        Section section = null;
        for (int i = 0; i < vector.size() - 1; ++i) {
            MachSymtabParser.MachSymtabEntry machSymtabEntry = vector.get(i);
            int n = (int)machSymtabEntry.getSectionIndex() - 1;
            if (n >= vector2.size()) {
                Log.warn("MACH file may be corrupted for table index '%d' is out of bound '%d'.", n, vector2.size());
                continue;
            }
            if (n < 0) {
                Log.warn("MACH file may be corrupted for table index '%d' is out of bound '%d'.", n, vector2.size());
                continue;
            }
            section = vector2.get(n);
            if (machSymtabEntry.getValue() < section.getAddress()) continue;
            Subroutine subroutine = new Subroutine();
            subroutine.setLowPc(machSymtabEntry.getValue());
            subroutine.setName(machStringParser.getString(machSymtabEntry.getName()));
            long l = -1L;
            l = machSymtabEntry.getSectionIndex() != vector.get(i + 1).getSectionIndex() ? section.getAddress() + section.getSize() : vector.get(i + 1).getValue();
            subroutine.setHighPc(l);
            this.subroutineTable.add(subroutine);
        }
        MachSymtabParser.MachSymtabEntry machSymtabEntry = vector.lastElement();
        int n = (int)machSymtabEntry.getSectionIndex() - 1;
        if (n >= vector2.size()) {
            Log.warn("MACH file may be corrupted for table index '%d' is out of bound '%d'.", n, vector2.size());
            return;
        }
        section = vector2.get(n);
        long l = section.getAddress() + section.getSize();
        Subroutine subroutine = new Subroutine();
        subroutine.setName(machStringParser.getString(machSymtabEntry.getName()));
        subroutine.setLowPc(machSymtabEntry.getValue());
        subroutine.setHighPc(l);
        this.subroutineTable.add(subroutine);
    }

    private boolean parseCommand(long l) {
        MachCommandParser machCommandParser = MachCommandParser.create(this.binaryFileReader, this.fileFormat, this.header.getCommandNumber());
        if (null == machCommandParser) {
            return false;
        }
        this.uuid = machCommandParser.getUuid();
        this.vmAddr = machCommandParser.getVmAddr();
        Vector<Section> vector = machCommandParser.getSectionInfoTable();
        if (!this.parseSectionInfoTable(vector, l)) {
            Log.error("Failed to parse section info", new Object[0]);
            return false;
        }
        if (!this.parseSubroutineTable(l, machCommandParser.getMachSymtabCommand(), vector)) {
            Log.error("Failed to parse subroutine table", new Object[0]);
            return false;
        }
        return true;
    }

    private boolean parseCommandForRebuild(long l) {
        MachCommandParser machCommandParser = MachCommandParser.create(this.binaryFileReader, this.fileFormat, this.header.getCommandNumber());
        if (null == machCommandParser) {
            return false;
        }
        this.uuid = machCommandParser.getUuid();
        this.vmAddr = machCommandParser.getVmAddr();
        Vector<Section> vector = machCommandParser.getSectionInfoTable();
        if (!this.parseSectionInfoTable(vector, l)) {
            Log.error("Failed to parse section info", new Object[0]);
            return false;
        }
        return true;
    }

    public boolean parse(long l) {
        Log.info("Begin to parse file: %s", this.fileName);
        if (!this.openFile()) {
            return false;
        }
        if (!this.binaryFileReader.skip(l)) {
            return false;
        }
        if (!this.parseHeaderInfo()) {
            Log.error("Failed to parse header", new Object[0]);
            return false;
        }
        Log.info("Architecture: %s", this.header.getArch());
        if (!this.parseCommand(l)) {
            Log.error("Failed to parse command", new Object[0]);
            return false;
        }
        Log.info("Successfully parsed the file!", new Object[0]);
        Log.info("Begin to extract symbol table...", new Object[0]);
        DwarfInfoBean dwarfInfoBean = this.getDwarfInfoBean();
        SymbolTable symbolTable = null;
        if (null == dwarfInfoBean) {
            Log.warn("Failed to get DWARF info!", new Object[0]);
            symbolTable = SymtabMerger.getSymtabTable(this.subroutineTable);
            symbolTable.setHasDwarfInfo(false);
        } else {
            if (dwarfInfoBean != null) {
                symbolTable = DwarfParser.getSymbolTable(this.subroutineTable, dwarfInfoBean);
                if (null == symbolTable) {
                    Log.error("Failed to extract symbol table from DWARF section!", new Object[0]);
                    return false;
                }
            } else {
                symbolTable = new SymbolTable();
            }
            symbolTable.setHasDwarfInfo(true);
        }
        this.setSymbolTable(symbolTable);
        Log.info("Successfully to extract symbol table!", new Object[0]);
        return true;
    }

    public boolean parseForRebuild(long l) {
        Log.info("Begin to parse file: %s", this.fileName);
        if (!this.openFile()) {
            return false;
        }
        if (!this.binaryFileReader.skip(l)) {
            return false;
        }
        if (!this.parseHeaderInfo()) {
            Log.error("Failed to parse header", new Object[0]);
            return false;
        }
        Log.info("Architecture: %s", this.header.getArch());
        if (!this.parseCommandForRebuild(l)) {
            Log.error("Failed to parse command", new Object[0]);
            return false;
        }
        Log.info("Successfully parsed the file!", new Object[0]);
        return true;
    }

    private DwarfInfoBean getDwarfInfoBean() {
        Section section;
        Section section2;
        Section section3;
        Section section4;
        DwarfInfoBean dwarfInfoBean = new DwarfInfoBean();
        dwarfInfoBean.setFileName(this.fileName);
        dwarfInfoBean.set32bitElf(this.fileFormat == 32L);
        dwarfInfoBean.setLittleEndian(this.endian == BinaryFileReader.LITTLE_ENDIAN);
        Section section5 = this.sectionTable.get(DEBUG_ABBREV_SECTION);
        if (null == section5) {
            Log.error("No debug_abbrev section in the mach-o file.", new Object[0]);
            return null;
        }
        dwarfInfoBean.setDebugAbbrevOffset(section5.getOffset());
        dwarfInfoBean.setDebugAbbrevSize(section5.getSize());
        Section section6 = this.sectionTable.get(DEBUG_INFO_SECTION);
        if (null == section6) {
            Log.error("No debug_info section in the file.", new Object[0]);
            return null;
        }
        dwarfInfoBean.setDebugInfoOffset(section6.getOffset());
        dwarfInfoBean.setDebugInfoSize(section6.getSize());
        Section section7 = this.sectionTable.get(DEBUG_LINE_SECTION);
        if (null == section7) {
            Log.error("No debug_line section in the file.", new Object[0]);
            return null;
        }
        dwarfInfoBean.setDebugLineOffset(section7.getOffset());
        dwarfInfoBean.setDebugLineSize(section7.getSize());
        Section section8 = this.sectionTable.get(DEBUG_RANGES_SECTION);
        if (null != section8) {
            dwarfInfoBean.setDebugRangesOffset(section8.getOffset());
            dwarfInfoBean.setDebugRangesSize(section8.getSize());
        }
        if (null == (section4 = this.sectionTable.get(DEBUG_STR_SECTION))) {
            Log.error("No debug_str section in the file", new Object[0]);
        } else {
            dwarfInfoBean.setDebugStrOffset(section4.getOffset());
            dwarfInfoBean.setDebugStrSize(section4.getSize());
        }
        Section section9 = this.sectionTable.get(DEBUG_PUBNAMES_SECTION);
        if (null == section9) {
            Log.error("No %s section in the file", DEBUG_PUBNAMES_SECTION);
        } else {
            dwarfInfoBean.setDebugPubnamesOffset(section9.getOffset());
            dwarfInfoBean.setDebugPubnamesSize(section9.getSize());
        }
        Section section10 = this.sectionTable.get(DEBUG_STR_OFFS_SECTION);
        if (section10 != null) {
            dwarfInfoBean.setDebugStrOffsetsOffset(section10.getOffset());
            dwarfInfoBean.setDebugStrOffsetsSize(section10.getSize());
        }
        if ((section3 = this.sectionTable.get(DEBUG_LINE_STR_SECTION)) != null) {
            dwarfInfoBean.setDebugLineStrOffset(section3.getOffset());
            dwarfInfoBean.setDebugLineStrSize(section3.getSize());
        }
        if ((section2 = this.sectionTable.get(DEBUG_RNGLISTS_SECTION)) != null) {
            dwarfInfoBean.setDebugRngListOffset(section2.getOffset());
            dwarfInfoBean.setDebugRngListSize(section2.getSize());
        }
        if ((section = this.sectionTable.get(DEBUG_ADDR_SECTION)) != null) {
            dwarfInfoBean.setDebugAddrOffset(section.getOffset());
            dwarfInfoBean.setDebugAddrSize(section.getSize());
        }
        dwarfInfoBean.setPlatform("iOS");
        return dwarfInfoBean;
    }

    public static MachParser create(String string, long l, boolean bl) {
        MachParser machParser = new MachParser(string);
        if (bl) {
            if (!machParser.parseForRebuild(l)) {
                machParser.closeFile();
                return null;
            }
        } else if (!machParser.parse(l)) {
            machParser.closeFile();
            return null;
        }
        return machParser;
    }

    public static boolean isMach(String string) {
        return MachHeaderParser.isMach(string);
    }
}

