/*
 * Decompiled with CFR 0.152.
 */
package com.uqm.crashsight.symtabtool.mach;

import com.uqm.crashsight.symtabtool.common.file.BinaryFileReader;
import com.uqm.crashsight.symtabtool.common.utils.Log;
import java.io.IOException;
import java.util.Vector;

public class MachFatHeaderParser {
    public static final long MAGIC_MACH_FAT_LE = 3405691582L;
    public static final long MAGIC_MACH_FAT_BE = 3199925962L;
    private String fileName = null;
    private BinaryFileReader binaryFileReader = null;
    private long endian = 0L;
    private long magic = 0L;

    public void setFileName(String string) {
        this.fileName = string;
    }

    public MachFatHeaderParser(String string) {
        this.setFileName(string);
    }

    public void close() {
        if (null == this.binaryFileReader) {
            return;
        }
        if (!this.binaryFileReader.close()) {
            Log.error("Failed to open file\uff1a%s", this.fileName);
            return;
        }
        this.binaryFileReader = null;
    }

    private boolean openFile() {
        if (null != this.binaryFileReader) {
            this.close();
        }
        try {
            this.binaryFileReader = new BinaryFileReader(this.fileName);
        }
        catch (Exception exception) {
            Log.error(exception);
            return false;
        }
        return true;
    }

    private boolean parseMagic() {
        if (3405691582L == this.magic) {
            this.endian = BinaryFileReader.LITTLE_ENDIAN;
        } else if (3199925962L == this.magic) {
            this.endian = BinaryFileReader.BIG_ENDIAN;
        } else {
            return false;
        }
        this.binaryFileReader.setEndian(this.endian);
        return true;
    }

    private Vector<Long> parseHeader() {
        try {
            Vector<Long> vector = new Vector<Long>();
            this.magic = this.binaryFileReader.readUInt();
            if (!this.parseMagic()) {
                vector.add(new Long(0L));
                return vector;
            }
            long l = this.binaryFileReader.readUInt();
            int n = 0;
            while ((long)n < l) {
                long l2 = this.binaryFileReader.readUInt();
                long l3 = this.binaryFileReader.readUInt();
                long l4 = this.binaryFileReader.readUInt();
                long l5 = this.binaryFileReader.readUInt();
                long l6 = this.binaryFileReader.readUInt();
                vector.add(new Long(l4));
                ++n;
            }
            return vector;
        }
        catch (IOException iOException) {
            Log.error(iOException);
            return null;
        }
    }

    public Vector<Long> getOffsetTable() {
        if (!this.openFile()) {
            this.close();
            return null;
        }
        return this.parseHeader();
    }
}

