/*
 * Decompiled with CFR 0.152.
 */
package com.uqm.crashsight.symtabtool.mach;

import com.uqm.crashsight.symtabtool.common.Section;
import com.uqm.crashsight.symtabtool.common.file.BinaryFileReader;
import com.uqm.crashsight.symtabtool.common.utils.Log;
import com.uqm.crashsight.symtabtool.mach.MachSegmentParser;
import java.io.IOException;
import java.util.Vector;

public class MachCommandParser {
    private static final long LOAD_COMMAND_SIZE = 8L;
    private static final int SYMTAB_COMMAND = 2;
    private static final int SEGMENT_COMMAND = 1;
    private static final int SEGMENT_64_COMMAND = 25;
    private static final int UUID_COMMAND = 27;
    private long fileFormat = 0L;
    private BinaryFileReader binaryFileReader = null;
    private byte[] uuid = new byte[16];
    private Vector<Section> sectionInfoTable = new Vector();
    private MachSymtabCommand machSymtabCommand = null;
    private long vmAddr = -1L;

    public byte[] getUuid() {
        return this.uuid;
    }

    public long getVmAddr() {
        return this.vmAddr;
    }

    public Vector<Section> getSectionInfoTable() {
        return this.sectionInfoTable;
    }

    public MachSymtabCommand getMachSymtabCommand() {
        return this.machSymtabCommand;
    }

    private void setFileFormat(long l) {
        this.fileFormat = l;
    }

    private void setBinaryFileReader(BinaryFileReader binaryFileReader) {
        this.binaryFileReader = binaryFileReader;
    }

    private MachCommandParser(BinaryFileReader binaryFileReader, long l) {
        this.setBinaryFileReader(binaryFileReader);
        this.setFileFormat(l);
    }

    private boolean parseSegmentCommand() {
        MachSegmentParser machSegmentParser;
        Vector<Section> vector;
        MachSegmentCommand machSegmentCommand = new MachSegmentCommand();
        if (!machSegmentCommand.parse(this.binaryFileReader, this.fileFormat)) {
            return false;
        }
        if (machSegmentCommand.getSegmentName().equals("__TEXT")) {
            this.vmAddr = machSegmentCommand.getVmAddr();
        }
        if (null == (vector = (machSegmentParser = new MachSegmentParser(this.binaryFileReader, this.fileFormat)).getSectionInfoTable(machSegmentCommand.getSectionNumber()))) {
            Log.error("Failed to get section table", new Object[0]);
            return false;
        }
        this.sectionInfoTable.addAll(vector);
        return true;
    }

    private boolean parseSymtabCommand() {
        this.machSymtabCommand = new MachSymtabCommand();
        if (!this.machSymtabCommand.parse(this.binaryFileReader)) {
            this.machSymtabCommand = null;
            return false;
        }
        return true;
    }

    private boolean parseCommand(long l) {
        if (l <= 0L) {
            return false;
        }
        long l2 = -1L;
        long l3 = -1L;
        int n = 0;
        while ((long)n < l) {
            try {
                l2 = this.binaryFileReader.readUInt();
                l3 = this.binaryFileReader.readUInt();
            }
            catch (IOException iOException) {
                Log.error(iOException);
                return false;
            }
            switch ((int)l2) {
                case 27: {
                    if (this.binaryFileReader.readByteArray(this.uuid)) break;
                    Log.error("Faile to parse UUID", new Object[0]);
                    break;
                }
                case 1: 
                case 25: {
                    if (this.parseSegmentCommand()) break;
                    Log.error("Faile to parse segment command", new Object[0]);
                    break;
                }
                case 2: {
                    if (this.parseSymtabCommand()) break;
                    Log.error("Faile to parse symtab command", new Object[0]);
                    break;
                }
                default: {
                    this.binaryFileReader.skip(l3 - 8L);
                }
            }
            ++n;
        }
        return true;
    }

    private boolean parse(long l) {
        return this.parseCommand(l);
    }

    public static MachCommandParser create(BinaryFileReader binaryFileReader, long l, long l2) {
        MachCommandParser machCommandParser = new MachCommandParser(binaryFileReader, l);
        if (!machCommandParser.parse(l2)) {
            return null;
        }
        return machCommandParser;
    }

    public static class MachSymtabCommand {
        private long symtabOffset = 0L;
        private long entryNumber = 0L;
        private long strtabOffset = 0L;
        private long strtabSize = 0L;

        public long getSymtabOffset() {
            return this.symtabOffset;
        }

        public long getEntryNumber() {
            return this.entryNumber;
        }

        public long getStrtabOffset() {
            return this.strtabOffset;
        }

        public long getStrtabSize() {
            return this.strtabSize;
        }

        public boolean parse(BinaryFileReader binaryFileReader) {
            try {
                this.symtabOffset = binaryFileReader.readUInt();
                this.entryNumber = binaryFileReader.readUInt();
                this.strtabOffset = binaryFileReader.readUInt();
                this.strtabSize = binaryFileReader.readUInt();
            }
            catch (IOException iOException) {
                Log.error(iOException);
                return false;
            }
            return true;
        }
    }

    public static class MachSegmentCommand {
        private String segmentName = null;
        private long vmAddr = 0L;
        private long vmSize = 0L;
        private long fileOffset = 0L;
        private long fileSize = 0L;
        private long maxProt = 0L;
        private long initProt = 0L;
        private long sectionNumber = 0L;
        private long flags = 0L;

        public String getSegmentName() {
            return this.segmentName;
        }

        public long getVmAddr() {
            return this.vmAddr;
        }

        public long getVmSize() {
            return this.vmSize;
        }

        public long getFileOffset() {
            return this.fileOffset;
        }

        public long getFileSize() {
            return this.fileSize;
        }

        public long getMaxProt() {
            return this.maxProt;
        }

        public long getInitProt() {
            return this.initProt;
        }

        public long getSectionNumber() {
            return this.sectionNumber;
        }

        public long getFlags() {
            return this.flags;
        }

        private String parseName(BinaryFileReader binaryFileReader) {
            byte[] byArray = new byte[16];
            if (!binaryFileReader.readByteArray(byArray)) {
                return null;
            }
            return MachSegmentParser.byteArraytoString(byArray);
        }

        public boolean parse(BinaryFileReader binaryFileReader, long l) {
            try {
                this.segmentName = this.parseName(binaryFileReader);
                if (null == this.segmentName) {
                    return false;
                }
                if (32L == l) {
                    this.vmAddr = binaryFileReader.readUInt();
                    this.vmSize = binaryFileReader.readUInt();
                    this.fileOffset = binaryFileReader.readUInt();
                    this.fileSize = binaryFileReader.readUInt();
                } else if (64L == l) {
                    this.vmAddr = binaryFileReader.readULong();
                    this.vmSize = binaryFileReader.readULong();
                    this.fileOffset = binaryFileReader.readULong();
                    this.fileSize = binaryFileReader.readULong();
                } else {
                    Log.error("File format error", new Object[0]);
                    return false;
                }
                this.maxProt = binaryFileReader.readUInt();
                this.initProt = binaryFileReader.readUInt();
                this.sectionNumber = binaryFileReader.readUInt();
                this.flags = binaryFileReader.readUInt();
            }
            catch (IOException iOException) {
                Log.error(iOException);
                return false;
            }
            return true;
        }
    }
}

