/*
 * Decompiled with CFR 0.152.
 */
package com.uqm.crashsight.symtabtool.generic.extractor;

import com.google.gson.JsonObject;
import com.uqm.crashsight.symtabparser.SymtabFileParser;
import com.uqm.crashsight.symtabparser.stif.SymtabIndexFile;
import com.uqm.crashsight.symtabtool.common.file.FileHelper;
import com.uqm.crashsight.symtabtool.common.utils.Log;
import com.uqm.crashsight.symtabtool.elf.ElfParser;
import com.uqm.crashsight.symtabtool.generic.ArgsParser;
import com.uqm.crashsight.symtabtool.generic.SymtabToolClient;
import com.uqm.crashsight.symtabtool.symtabfile.SymtabFile;
import com.uqm.crashsight.symtabtool.symtabfile.SymtabFileInfoBean;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Vector;

public class SymtabExtractorLinux {
    private SymtabExtractorLinux() {
    }

    private static SymtabFileInfoBean getSymtabFileInfoBean(ArgsParser argsParser, ElfParser elfParser, String string) {
        SymtabFileInfoBean symtabFileInfoBean = new SymtabFileInfoBean();
        symtabFileInfoBean.setFileType("LINUX_ELF");
        symtabFileInfoBean.setFileFormat(elfParser.getFileFormat());
        symtabFileInfoBean.setArch(elfParser.getArch());
        symtabFileInfoBean.setSha1(elfParser.getUuid());
        if (elfParser.getSoVersion() != null) {
            symtabFileInfoBean.setSoVersion(elfParser.getSoVersion());
        }
        symtabFileInfoBean.setFileName(string);
        symtabFileInfoBean.setAppName(argsParser.getSoName(string));
        symtabFileInfoBean.setVmAddr(elfParser.getModuleBase());
        symtabFileInfoBean.setSymbolTable(elfParser.getSymbolTable());
        symtabFileInfoBean.setSymtabToolVersion("3.2.1024");
        symtabFileInfoBean.setPvaddr(elfParser.getProgramVaddr().get(0));
        symtabFileInfoBean.setModuleBase(elfParser.getModuleBase());
        return symtabFileInfoBean;
    }

    public static String[] extract(ArgsParser argsParser) {
        if (null == argsParser) {
            return null;
        }
        String string = argsParser.getPathName();
        StringBuilder stringBuilder = new StringBuilder(argsParser.getPathName() + "crashsightSymbol");
        StringBuilder stringBuilder2 = new StringBuilder(argsParser.getPathName() + "crashsightBreakpadSymbol");
        HashMap<String, File> hashMap = new HashMap<String, File>();
        HashMap<String, File> hashMap2 = new HashMap<String, File>();
        Vector<File> vector = argsParser.getSoFiles();
        if (vector.isEmpty()) {
            return null;
        }
        if (vector.size() == 1) {
            Log.info("Extracting symtab file: %s", vector.get(0).getName());
        } else if (vector.size() > 1) {
            Log.info("Extracting symtab files of directory: %s", string);
        }
        HashSet<String> hashSet = new HashSet<String>();
        int n = 0;
        for (File iterator2 : vector) {
            long file = System.currentTimeMillis();
            Log.info("Processing file: %s", iterator2.getAbsolutePath());
            String string2 = null;
            try {
                string2 = iterator2.getCanonicalPath();
            }
            catch (IOException iOException) {
                Log.error(iOException);
                return null;
            }
            ElfParser elfParser = ElfParser.create(string2);
            if (null == elfParser) {
                SymtabToolClient.getErrorInfo().addErrorMsg("Failed to parse the file:" + string2);
                Log.error("Failed to parse the file!", new Object[0]);
                continue;
            }
            Log.info("UUID: " + elfParser.getUuid(), new Object[0]);
            hashSet.add(elfParser.getUuid());
            Log.info("stif file name %s", string2);
            SymtabFileInfoBean symtabFileInfoBean = SymtabExtractorLinux.getSymtabFileInfoBean(argsParser, elfParser, string2);
            symtabFileInfoBean.setSha1(elfParser.getBreakpadDebugId());
            SymtabFile symtabFile = SymtabFile.create(symtabFileInfoBean);
            if (symtabFile == null) {
                SymtabToolClient.getErrorInfo().addErrorMsg("SymtabExtractor: Failed to create symtab file!");
                Log.error("SymtabExtractor: Failed to create symtab file!", new Object[0]);
                continue;
            }
            String string3 = symtabFile.getSymtabFileName();
            if (string3 == null) continue;
            if (elfParser.getSectionTable().get(".debug_abbrev") != null) {
                SymtabExtractorLinux.generateStifFile(symtabFileInfoBean, argsParser, symtabFile, elfParser, hashMap);
                if (n++ < 2) {
                    stringBuilder.append("_").append(argsParser.getSoName(string2));
                    stringBuilder.append("_").append(elfParser.getArch());
                    stringBuilder.append("-").append(elfParser.getUuid().substring(0, 5)).append(".zip");
                }
            } else if (elfParser.getSectionTable().get(".eh_frame") != null) {
                SymtabExtractorLinux.generateSymFile(symtabFileInfoBean, argsParser, symtabFile, elfParser, hashMap2);
                if (n++ < 2) {
                    stringBuilder2.append("_").append(argsParser.getSoName(string2));
                    stringBuilder2.append("_").append(elfParser.getArch());
                    stringBuilder2.append("-").append(elfParser.getUuid().substring(0, 5)).append(".zip");
                }
            }
            long l = System.currentTimeMillis();
            JsonObject jsonObject = new JsonObject();
            jsonObject.addProperty("name", iterator2.getName());
            jsonObject.addProperty("time", l - file);
            SymtabToolClient.getJsonArray().add(jsonObject);
        }
        String[] stringArray = new String[2];
        if (argsParser.getSymZipFileName() != null && !argsParser.getSymZipFileName().isEmpty()) {
            Log.info("symZipFileName is  " + argsParser.getSymZipFileName(), new Object[0]);
            stringBuilder2 = new StringBuilder(argsParser.getSymZipFileName());
        }
        if (argsParser.getStifZipFileName() != null && !argsParser.getStifZipFileName().isEmpty()) {
            Log.info("stifZipFileName is  " + argsParser.getStifZipFileName(), new Object[0]);
            stringBuilder = new StringBuilder(argsParser.getStifZipFileName());
        }
        if (hashMap.size() == 0) {
            stringArray[0] = "";
        } else {
            FileHelper.zipFiles(new Vector<File>(hashMap.values()), stringBuilder.toString());
            stringArray[0] = stringBuilder.toString();
        }
        if (hashMap2.size() == 0) {
            stringArray[1] = "";
        } else {
            FileHelper.zipFiles(new Vector<File>(hashMap2.values()), stringBuilder2.toString());
            stringArray[1] = stringBuilder2.toString();
        }
        for (File file : hashMap.values()) {
            if (file.delete()) continue;
            file.deleteOnExit();
        }
        for (File file : hashMap2.values()) {
            if (file.delete()) continue;
            file.deleteOnExit();
        }
        return stringArray;
    }

    public static Vector<String> getUuid(ArgsParser argsParser) {
        if (null == argsParser) {
            return null;
        }
        String string = argsParser.getPathName();
        Vector<File> vector = argsParser.getSoFiles();
        if (vector.isEmpty()) {
            return null;
        }
        if (vector.size() == 1) {
            Log.info("Extracting symtab file: %s", vector.get(0).getName());
        } else if (vector.size() > 1) {
            Log.info("Extracting symtab files of directory: %s", string);
        }
        Vector<String> vector2 = new Vector<String>();
        for (File file : vector) {
            String string2 = null;
            try {
                string2 = file.getCanonicalPath();
            }
            catch (IOException iOException) {
                Log.error(iOException);
                return null;
            }
            vector2.add(ElfParser.getUuid(string2, false));
        }
        return vector2;
    }

    private static boolean generateStifFile(SymtabFileInfoBean symtabFileInfoBean, ArgsParser argsParser, SymtabFile symtabFile, ElfParser elfParser, Map<String, File> map) {
        SymtabIndexFile.vmAddr = -symtabFileInfoBean.getModuleBase();
        SymtabIndexFile.moduleBase = symtabFileInfoBean.getModuleBase();
        SymtabIndexFile.pvAddr = -symtabFileInfoBean.getModuleBase();
        SymtabIndexFile.fileType = symtabFileInfoBean.getFileType();
        String string = symtabFile.getSymtabFileName();
        if (string == null) {
            return false;
        }
        File file = new File(string);
        if (!SymtabFileParser.parseFile(string, file.getParent(), symtabFileInfoBean.getSymbolTable())) {
            Log.warn("Failed to parse symbol file: " + string, new Object[0]);
        } else {
            String string2 = FileHelper.changeFileSuffix(string, "stif");
            File file2 = new File(string2);
            Log.info("Add stif to symtab zip file: " + string2, new Object[0]);
            String string3 = string;
            if (string.lastIndexOf(".") > 0) {
                string3 = string.substring(0, string.lastIndexOf(".")) + "0.stif";
            }
            File file3 = new File(string3);
            file2.renameTo(file3);
            map.put(string2, file3);
        }
        if (null != symtabFileInfoBean.getSymbolTable()) {
            symtabFileInfoBean.getSymbolTable().close();
        }
        if (argsParser.dumpSymbol()) {
            Log.info("Add symbol to symtab zip file: " + string, new Object[0]);
            map.put(string, file);
        } else if (!file.delete()) {
            file.deleteOnExit();
        }
        return true;
    }

    private static boolean generateSymFile(SymtabFileInfoBean symtabFileInfoBean, ArgsParser argsParser, SymtabFile symtabFile, ElfParser elfParser, Map<String, File> map) {
        symtabFile.setUuid(elfParser.getBreakpadDebugId());
        Log.info("Breakpad UUID: " + elfParser.getBreakpadDebugId(), new Object[0]);
        if (symtabFile.createBreakpadSymtab(elfParser, true)) {
            Log.info("createBreakpadSymtab success", new Object[0]);
            String string = symtabFile.getBreakpadSymtabFileName();
            Log.info("Add sym to breakpad symtab zip file: " + string, new Object[0]);
            map.put(string, new File(string));
            String string2 = symtabFile.getSymtabFileName();
            if (string2 == null) {
                return false;
            }
            File file = new File(string2);
            if (!file.delete()) {
                file.deleteOnExit();
            }
        } else {
            SymtabToolClient.getErrorInfo().addErrorMsg("Make breakpad failed");
            Log.error("Make breakpad failed", new Object[0]);
        }
        return true;
    }
}

