/*
 * Decompiled with CFR 0.152.
 */
package com.uqm.crashsight.symtabtool.generic.extractor;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.uqm.crashsight.symtabparser.SymtabFileParser;
import com.uqm.crashsight.symtabparser.stif.SymtabIndexFile;
import com.uqm.crashsight.symtabtool.common.file.FileHelper;
import com.uqm.crashsight.symtabtool.common.utils.Log;
import com.uqm.crashsight.symtabtool.generic.ArgsParser;
import com.uqm.crashsight.symtabtool.generic.SymtabToolClient;
import com.uqm.crashsight.symtabtool.mach.MachFatHeaderParser;
import com.uqm.crashsight.symtabtool.mach.MachParser;
import com.uqm.crashsight.symtabtool.symtabfile.SymtabFile;
import com.uqm.crashsight.symtabtool.symtabfile.SymtabFileInfoBean;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Vector;
import org.apache.commons.lang3.StringUtils;

public class SymtabExtractorIos {
    private SymtabExtractorIos() {
    }

    private static SymtabFileInfoBean getSymtabFileInfoBean(ArgsParser argsParser, MachParser machParser, String string) {
        SymtabFileInfoBean symtabFileInfoBean = new SymtabFileInfoBean();
        symtabFileInfoBean.setFileType("Mach-O");
        symtabFileInfoBean.setFileFormat(machParser.getFileFormat());
        symtabFileInfoBean.setArch(machParser.getArch());
        symtabFileInfoBean.setUuid(machParser.getUuid());
        symtabFileInfoBean.setFileName(string);
        symtabFileInfoBean.setAppName(argsParser.getDsymName(string));
        symtabFileInfoBean.setVmAddr(machParser.getVmAddr());
        symtabFileInfoBean.setSymbolTable(machParser.getSymbolTable());
        symtabFileInfoBean.setSymtabToolVersion("3.2.1024");
        return symtabFileInfoBean;
    }

    public static String extract(ArgsParser argsParser) {
        if (null == argsParser) {
            return null;
        }
        String string = argsParser.getPathName();
        StringBuilder stringBuilder = new StringBuilder("crashsightSymbol");
        HashMap<String, File> hashMap = new HashMap<String, File>();
        Vector<File> vector = argsParser.getdSymFiles();
        if (vector.isEmpty()) {
            return null;
        }
        if (vector.size() == 1) {
            Log.info("Extracting symtab file: %s", vector.get(0).getName());
        } else if (vector.size() > 1) {
            Log.info("Extracting symtab files of directory: %s with %d files", string, vector.size());
        }
        if (argsParser.uploadDsym()) {
            for (File file : vector) {
                hashMap.put(file.getAbsolutePath(), file);
            }
        } else {
            int n = 0;
            boolean bl = false;
            Serializable serializable = new HashSet<String>();
            for (File file : vector) {
                Object object;
                long l = System.currentTimeMillis();
                String string2 = null;
                try {
                    string2 = file.getCanonicalPath();
                }
                catch (IOException iOException) {
                    Log.error(iOException);
                    return null;
                }
                MachFatHeaderParser machFatHeaderParser = new MachFatHeaderParser(string2);
                Vector<Long> vector2 = machFatHeaderParser.getOffsetTable();
                machFatHeaderParser.close();
                if (null == vector2) {
                    SymtabToolClient.getErrorInfo().addErrorMsg("Failed to read Mach-0 file");
                    Log.error("SymtabExtractor Mach-O\u6587\u4ef6\u8bfb\u53d6\u5931\u8d25\uff01", new Object[0]);
                    continue;
                }
                for (Long object32 : vector2) {
                    Object object2 = MachParser.getUuid(string2, object32);
                    if (((HashSet)serializable).contains(object2)) {
                        bl = true;
                        break;
                    }
                    ((HashSet)serializable).add(object2);
                }
                if (bl) {
                    Log.info("Ignore this dSYM file for it has been processed before: " + string2, new Object[0]);
                    continue;
                }
                StringBuilder stringBuilder2 = new StringBuilder();
                for (Object object2 : vector2) {
                    object = MachParser.create(string2, (Long)object2, false);
                    if (null == object) {
                        SymtabToolClient.getErrorInfo().addErrorMsg("Failed to parse the file!");
                        Log.error("Failed to parse the file!", new Object[0]);
                        return null;
                    }
                    SymtabFileInfoBean symtabFileInfoBean = SymtabExtractorIos.getSymtabFileInfoBean(argsParser, (MachParser)object, string2);
                    SymtabFile symtabFile = SymtabFile.create(symtabFileInfoBean);
                    SymtabIndexFile.fileType = symtabFileInfoBean.getFileType();
                    if (null == symtabFile) {
                        SymtabToolClient.getErrorInfo().addErrorMsg("SymtabExtractor: Failed to create symtab file!");
                        Log.error("SymtabExtractor: Failed to create symtab file!", new Object[0]);
                        continue;
                    }
                    String string3 = symtabFile.getSymtabFileName();
                    if (string3 == null) continue;
                    File file2 = new File(string3);
                    if (!SymtabFileParser.parseFile(string3, file2.getParent(), symtabFileInfoBean.getSymbolTable())) {
                        Log.warn("Failed to parse symbol file: " + string3, new Object[0]);
                    } else {
                        String string4 = FileHelper.changeFileSuffix(string3, "stif");
                        File file3 = new File(string4);
                        if (file3.exists()) {
                            Log.info("Add stif to symtab zip file: " + string4, new Object[0]);
                            hashMap.put(string4, file3);
                        }
                    }
                    if (argsParser.dumpSymbol()) {
                        Log.info("Add symbol to symtab zip file: " + string3, new Object[0]);
                        hashMap.put(string3, file2);
                    } else if (!file2.delete()) {
                        file2.deleteOnExit();
                    }
                    stringBuilder2.append("_").append(((MachParser)object).getArch());
                    stringBuilder2.append("-").append(((MachParser)object).getUuid().substring(0, 5));
                    ((MachParser)object).close();
                }
                if (n++ < 2) {
                    stringBuilder.append("_").append(argsParser.getDsymName(string2)).append((CharSequence)stringBuilder2);
                }
                long l2 = System.currentTimeMillis();
                object = new JsonObject();
                ((JsonObject)object).addProperty("name", file.getName());
                ((JsonObject)object).addProperty("time", l2 - l);
                SymtabToolClient.getJsonArray().add((JsonElement)object);
            }
            if (hashMap.isEmpty()) {
                Log.error("Files is empty.", new Object[0]);
                return null;
            }
            Log.info("There are %d stif files", hashMap.size());
        }
        stringBuilder.append(".zip");
        if (StringUtils.isNotEmpty(argsParser.getStifZipFileName())) {
            stringBuilder = new StringBuilder(argsParser.getStifZipFileName());
        } else if (argsParser.uploadDsym()) {
            stringBuilder = new StringBuilder(string + argsParser.getFileName() + ".zip");
        } else {
            stringBuilder.insert(0, string);
        }
        Log.info("Begin to zip symtab file: " + stringBuilder, new Object[0]);
        boolean bl = FileHelper.zipFiles(new Vector<File>(hashMap.values()), stringBuilder.toString());
        if (bl) {
            Log.info("Successfully zipped symtab file!", new Object[0]);
        } else {
            SymtabToolClient.getErrorInfo().addErrorMsg("SymtabExtractor: Failed to zip file!");
            Log.error("SymtabExtractor: Failed to zip file!", new Object[0]);
        }
        if (!argsParser.uploadDsym()) {
            for (Serializable serializable : hashMap.values()) {
                if (((File)serializable).delete()) continue;
                ((File)serializable).deleteOnExit();
            }
        }
        return stringBuilder.toString();
    }

    public static Vector<String> getUuid(ArgsParser argsParser) {
        if (null == argsParser) {
            return null;
        }
        String string = argsParser.getPathName();
        Vector<File> vector = argsParser.getdSymFiles();
        if (vector.isEmpty()) {
            return null;
        }
        if (vector.size() == 1) {
            Log.info("Extracting symtab file: %s", vector.get(0).getName());
        } else if (vector.size() > 1) {
            Log.info("Extracting symtab files of directory: %s", string);
        }
        Vector<String> vector2 = new Vector<String>();
        for (File file : vector) {
            String string2 = null;
            try {
                string2 = file.getCanonicalPath();
            }
            catch (IOException iOException) {
                Log.error(iOException);
                return null;
            }
            MachFatHeaderParser machFatHeaderParser = new MachFatHeaderParser(string2);
            Vector<Long> vector3 = machFatHeaderParser.getOffsetTable();
            machFatHeaderParser.close();
            if (null == vector3) {
                SymtabToolClient.getErrorInfo().addErrorMsg("Failed to read Mach-O file\uff01");
                Log.error("SymtabExtractor Mach-O\u6587\u4ef6\u8bfb\u53d6\u5931\u8d25\uff01", new Object[0]);
                return null;
            }
            for (Long l : vector3) {
                vector2.add(MachParser.getUuid(string2, l));
            }
        }
        return vector2;
    }
}

