/*
 * Decompiled with CFR 0.152.
 */
package com.uqm.crashsight.symtabtool.elf;

import com.uqm.crashsight.symtabtool.common.Section;
import com.uqm.crashsight.symtabtool.common.file.BinaryFileReader;
import com.uqm.crashsight.symtabtool.common.utils.Log;
import com.uqm.crashsight.symtabtool.dwarf.ParseBuffer;
import com.uqm.crashsight.symtabtool.elf.ElfStringParser;
import java.io.IOException;
import java.nio.ByteOrder;
import java.util.HashMap;
import java.util.Vector;

public class ElfSectionParser {
    private String fileName = null;
    private long fileFormat = 0L;
    private long endian = 0L;
    private BinaryFileReader binaryFileReader = null;
    private Vector<String> sectionNameTable = null;

    private void setFileName(String string) {
        this.fileName = string;
    }

    private void setFileFormat(long l) {
        this.fileFormat = l;
    }

    private void setEndian(long l) {
        this.endian = l;
    }

    public Vector<String> getSectionNameTable() {
        return this.sectionNameTable;
    }

    public ElfSectionParser(String string, long l, long l2) {
        this.setFileName(string);
        this.setFileFormat(l);
        this.setEndian(l2);
    }

    private void close() {
        if (null == this.binaryFileReader) {
            return;
        }
        if (!this.binaryFileReader.close()) {
            return;
        }
        this.binaryFileReader = null;
    }

    private boolean openFile() {
        if (null != this.binaryFileReader) {
            this.close();
        }
        try {
            this.binaryFileReader = new BinaryFileReader(this.fileName, this.endian);
        }
        catch (Exception exception) {
            Log.error(exception);
            return false;
        }
        return true;
    }

    private ElfSectionInfo parseSectionInfo() {
        ElfSectionInfo elfSectionInfo;
        block8: {
            elfSectionInfo = new ElfSectionInfo();
            try {
                elfSectionInfo.setNameIndex(this.binaryFileReader.readUInt());
                elfSectionInfo.setType(this.binaryFileReader.readUInt());
                if (32L == this.fileFormat) {
                    elfSectionInfo.setFlag(this.binaryFileReader.readUInt());
                    elfSectionInfo.setAddress(this.binaryFileReader.readUInt());
                    elfSectionInfo.setOffset(this.binaryFileReader.readUInt());
                    elfSectionInfo.setSize(this.binaryFileReader.readUInt());
                } else if (64L == this.fileFormat) {
                    elfSectionInfo.setFlag(this.binaryFileReader.readULong());
                    elfSectionInfo.setAddress(this.binaryFileReader.readULong());
                    elfSectionInfo.setOffset(this.binaryFileReader.readULong());
                    elfSectionInfo.setSize(this.binaryFileReader.readULong());
                } else {
                    Log.error("File format error", new Object[0]);
                    return null;
                }
                elfSectionInfo.setLink(this.binaryFileReader.readUInt());
                elfSectionInfo.setInfo(this.binaryFileReader.readUInt());
                if (32L == this.fileFormat) {
                    elfSectionInfo.setAddressAlign(this.binaryFileReader.readUInt());
                    elfSectionInfo.setEntrySize(this.binaryFileReader.readUInt());
                    break block8;
                }
                if (64L == this.fileFormat) {
                    elfSectionInfo.setAddressAlign(this.binaryFileReader.readULong());
                    elfSectionInfo.setEntrySize(this.binaryFileReader.readULong());
                    break block8;
                }
                Log.error("File format error", new Object[0]);
                return null;
            }
            catch (IOException iOException) {
                Log.error(iOException);
                return null;
            }
        }
        return elfSectionInfo;
    }

    private HashMap<String, Section> getSectionInfoTable(long l, long l2) {
        Vector<ElfSectionInfo> vector = new Vector<ElfSectionInfo>();
        this.sectionNameTable = new Vector();
        int n = 0;
        while ((long)n < l) {
            vector.add(this.parseSectionInfo());
            ++n;
        }
        ElfSectionInfo elfSectionInfo = (ElfSectionInfo)vector.get((int)l2);
        ElfStringParser elfStringParser = new ElfStringParser(this.fileName, elfSectionInfo.getOffset(), elfSectionInfo.getSize());
        HashMap<String, Section> hashMap = new HashMap<String, Section>();
        for (ElfSectionInfo elfSectionInfo2 : vector) {
            String string = elfStringParser.getString(elfSectionInfo2.getNameIndex());
            Section section = new Section();
            section.setName(string);
            section.setAddress(elfSectionInfo2.getAddress());
            section.setOffset(elfSectionInfo2.getOffset());
            section.setSize(elfSectionInfo2.getSize());
            section.setEntrySize(elfSectionInfo2.getEntrySize());
            section.setAddrAlign(elfSectionInfo2.getAddressAlign());
            section.setFlags((int)elfSectionInfo2.getFlag());
            hashMap.put(string, section);
            this.sectionNameTable.add(string);
        }
        elfStringParser.close();
        return hashMap;
    }

    public HashMap<String, Section> getSectionInfoTable(long l, long l2, long l3) {
        if (!this.openFile()) {
            this.close();
            return null;
        }
        if (!this.binaryFileReader.skip(l)) {
            this.close();
            return null;
        }
        HashMap<String, Section> hashMap = this.getSectionInfoTable(l2, l3);
        this.close();
        return hashMap;
    }

    public ParseBuffer getSectionData(Section section) {
        if (!this.openFile()) {
            this.close();
            return null;
        }
        if (!this.binaryFileReader.skip(section.getOffset())) {
            this.close();
            return null;
        }
        byte[] byArray = new byte[(int)section.getSize()];
        this.binaryFileReader.readByteArray(byArray);
        this.close();
        return new ParseBuffer(byArray, this.endian == 1L ? ByteOrder.LITTLE_ENDIAN : ByteOrder.BIG_ENDIAN);
    }

    public static class ElfSectionInfo {
        private long nameIndex = -1L;
        private long type = 0L;
        private long flag = 0L;
        private long address = -1L;
        private long offset = -1L;
        private long size = 0L;
        private long link = 0L;
        private long info = 0L;
        private long addressAlign = 0L;
        private long entrySize = 0L;

        public long getNameIndex() {
            return this.nameIndex;
        }

        public long getType() {
            return this.type;
        }

        public long getFlag() {
            return this.flag;
        }

        public long getAddress() {
            return this.address;
        }

        public long getOffset() {
            return this.offset;
        }

        public long getSize() {
            return this.size;
        }

        public long getLink() {
            return this.link;
        }

        public long getInfo() {
            return this.info;
        }

        public long getAddressAlign() {
            return this.addressAlign;
        }

        public long getEntrySize() {
            return this.entrySize;
        }

        public void setNameIndex(long l) {
            this.nameIndex = l;
        }

        public void setType(long l) {
            this.type = l;
        }

        public void setFlag(long l) {
            this.flag = l;
        }

        public void setOffset(long l) {
            this.offset = l;
        }

        public void setAddress(long l) {
            this.address = l;
        }

        public void setSize(long l) {
            this.size = l;
        }

        public void setLink(long l) {
            this.link = l;
        }

        public void setInfo(long l) {
            this.info = l;
        }

        public void setAddressAlign(long l) {
            this.addressAlign = l;
        }

        public void setEntrySize(long l) {
            this.entrySize = l;
        }
    }
}

