/*
 * Decompiled with CFR 0.152.
 */
package com.uqm.crashsight.symtabtool.dwarf;

import com.uqm.crashsight.symtabtool.dwarf.CfaRule;
import com.uqm.crashsight.symtabtool.dwarf.Register;
import com.uqm.crashsight.symtabtool.dwarf.RegisterRule;
import com.uqm.crashsight.symtabtool.dwarf.RegisterRuleMap;
import com.uqm.crashsight.symtabtool.dwarf.UnwindTableRow;

class UnwindContext {
    public static final int MAX_UNWIND_STACK_DEPTH = 4;
    UnwindTableRow[] stackStorage = new UnwindTableRow[4];
    long stackLen = 0L;
    RegisterRuleMap initialRules = RegisterRuleMap._default();
    boolean isInitialized = false;

    public UnwindContext() {
        this.reset();
    }

    public void reset() {
        this.stackLen = 0L;
        boolean bl = this.tryPush(UnwindTableRow._default());
        assert (bl);
        this.initialRules.clear();
        this.isInitialized = false;
        this.assertFullyUninitialized();
    }

    public boolean tryPush(UnwindTableRow unwindTableRow) {
        if (this.stackLen < 4L) {
            this.stackStorage[(int)this.stackLen] = unwindTableRow;
            ++this.stackLen;
            return true;
        }
        return false;
    }

    public void assertFullyUninitialized() {
        assert (!this.isInitialized);
        assert (this.initialRules.rules().length == 0);
        assert (this.stack().length == 1);
        assert (this.stack()[0].isDefault());
    }

    UnwindTableRow[] stack() {
        int n = (int)this.stackLen;
        UnwindTableRow[] unwindTableRowArray = new UnwindTableRow[n];
        System.arraycopy(this.stackStorage, 0, unwindTableRowArray, 0, n);
        return unwindTableRowArray;
    }

    public UnwindTableRow row() {
        return this.stack()[(int)(this.stackLen - 1L)];
    }

    public void setStartAddress(long l) {
        UnwindTableRow unwindTableRow = this.row();
        unwindTableRow.startAddress = l;
    }

    public long startAddress() {
        return this.row().startAddress;
    }

    public void setCfa(CfaRule cfaRule) {
        this.row().cfa = cfaRule;
    }

    public CfaRule cfa() {
        return this.row().cfa;
    }

    public void setRegisterRule(Register register, RegisterRule registerRule) {
        this.row().registers.set(register, registerRule);
    }

    public RegisterRule getInitialRule(Register register) {
        if (!this.isInitialized) {
            return null;
        }
        return this.initialRules.get(register);
    }

    public void pushRow() {
        UnwindTableRow unwindTableRow = this.row()._clone();
        if (!this.tryPush(unwindTableRow)) {
            throw new RuntimeException("CfiStackFull");
        }
    }

    public void popRow() {
        assert (this.stack().length > 1);
        --this.stackLen;
    }

    public void saveInitialRules() {
        assert (!this.isInitialized);
        RegisterRuleMap registerRuleMap = this.row().registers;
        this.initialRules = registerRuleMap._clone();
        this.isInitialized = true;
    }
}

