/*
 * Decompiled with CFR 0.152.
 */
package com.uqm.crashsight.symtabtool.dwarf;

import com.uqm.crashsight.symtabtool.common.Pair;
import com.uqm.crashsight.symtabtool.dwarf.Register;
import com.uqm.crashsight.symtabtool.dwarf.RegisterRule;
import com.uqm.crashsight.symtabtool.dwarf.RegisterRulePair;

class RegisterRuleMap {
    public static final int MAX_RULES = 192;
    RegisterRulePair[] rulesStorage = new RegisterRulePair[192];
    long rulesLen;

    RegisterRuleMap() {
    }

    public static RegisterRuleMap _default() {
        RegisterRuleMap registerRuleMap = new RegisterRuleMap();
        for (int i = 0; i < registerRuleMap.rulesStorage.length; ++i) {
            registerRuleMap.rulesStorage[i] = new RegisterRulePair();
        }
        registerRuleMap.rulesLen = 0L;
        return registerRuleMap;
    }

    public RegisterRuleMap _clone() {
        RegisterRuleMap registerRuleMap = new RegisterRuleMap();
        for (int i = 0; i < this.rulesStorage.length; ++i) {
            if (this.rulesStorage[i] == null) continue;
            registerRuleMap.rulesStorage[i] = this.rulesStorage[i]._clone();
        }
        registerRuleMap.rulesLen = this.rulesLen;
        return registerRuleMap;
    }

    public void clear() {
        this.rulesLen = 0L;
    }

    public RegisterRulePair[] rules() {
        RegisterRulePair[] registerRulePairArray = new RegisterRulePair[(int)this.rulesLen];
        System.arraycopy(this.rulesStorage, 0, registerRulePairArray, 0, registerRulePairArray.length);
        return registerRulePairArray;
    }

    public Pair<RegisterRulePair[], RegisterRulePair[]> splitAt(int n) {
        RegisterRulePair[] registerRulePairArray = this.rules();
        RegisterRulePair[] registerRulePairArray2 = new RegisterRulePair[n];
        System.arraycopy(registerRulePairArray, 0, registerRulePairArray2, 0, registerRulePairArray2.length);
        RegisterRulePair[] registerRulePairArray3 = new RegisterRulePair[registerRulePairArray.length - registerRulePairArray2.length];
        System.arraycopy(registerRulePairArray, registerRulePairArray2.length, registerRulePairArray3, 0, registerRulePairArray3.length);
        return new Pair<RegisterRulePair[], RegisterRulePair[]>(registerRulePairArray2, registerRulePairArray3);
    }

    public boolean isDefault() {
        return this.rulesLen == 0L;
    }

    public int find(Register register) {
        RegisterRulePair[] registerRulePairArray = this.rules();
        for (int i = 0; i < registerRulePairArray.length; ++i) {
            if (this.rulesStorage[i].register.val != register.val) continue;
            return i;
        }
        return -1;
    }

    public void push(Register register, RegisterRule registerRule) {
        if (this.rulesLen >= 192L) {
            throw new RuntimeException("TooManyRegisterRules");
        }
        this.rulesStorage[(int)this.rulesLen] = new RegisterRulePair(register, registerRule);
        ++this.rulesLen;
    }

    public void set(Register register, RegisterRule registerRule) {
        if (!registerRule.isDefined()) {
            int n = this.find(register);
            if (n != -1) {
                Pair<RegisterRulePair[], RegisterRulePair[]> pair = this.splitAt(n + 1);
                RegisterRulePair[] registerRulePairArray = pair.getKey();
                RegisterRulePair[] registerRulePairArray2 = pair.getValue();
                if (registerRulePairArray2.length > 0) {
                    RegisterRulePair registerRulePair = registerRulePairArray[registerRulePairArray.length - 1];
                    registerRulePairArray[registerRulePairArray.length - 1] = registerRulePairArray2[registerRulePairArray2.length - 1];
                    registerRulePairArray2[registerRulePairArray2.length - 1] = registerRulePair;
                }
                --this.rulesLen;
            }
            return;
        }
        for (RegisterRulePair registerRulePair : this.rules()) {
            assert (registerRulePair.registerRule.isDefined());
            if (registerRulePair.register.val != register.val) continue;
            registerRulePair.registerRule = registerRule;
            return;
        }
        this.push(register, registerRule);
    }

    public RegisterRule get(Register register) {
        int n = this.find(register);
        if (n >= 0) {
            RegisterRulePair registerRulePair = this.rulesStorage[n];
            return registerRulePair.registerRule;
        }
        return RegisterRule.undefined();
    }
}

