/*
 * Decompiled with CFR 0.152.
 */
package com.uqm.crashsight.symtabtool.dwarf;

import com.uqm.crashsight.symtabtool.common.Pair;
import com.uqm.crashsight.symtabtool.common.utils.Log;
import com.uqm.crashsight.symtabtool.dwarf.Endianity;
import com.uqm.crashsight.symtabtool.dwarf.Format;

interface Reader {
    public Endianity endian();

    public Long len();

    public void empty();

    public Long offsetFrom(Reader var1);

    public void readSlice(byte[] var1);

    public short readU8();

    public int readU16();

    public long readU32();

    public long readU64();

    public short readI16();

    public int readI32();

    public long readI64();

    public long readULeb128();

    public long readSLeb128();

    default public long readAddress(short s2) {
        switch (s2) {
            case 1: {
                return this.readU8();
            }
            case 2: {
                return this.readU16();
            }
            case 4: {
                return this.readU32();
            }
            case 8: {
                return this.readU64();
            }
        }
        throw new RuntimeException("UnsupportedAddressSize");
    }

    public Long find(byte var1);

    public void skip(Long var1);

    default public Reader readNullTerminatedSlice() {
        Long l = this.find((byte)0);
        Reader reader = this.split(l);
        this.skip(1L);
        return reader;
    }

    default public Pair<Long, Format> readInitialLength() {
        long l = 0xFFFFFFF0L;
        long l2 = 0xFFFFFFFFL;
        long l3 = this.readU32();
        if (l3 < l) {
            return new Pair<Long, Format>(l3, Format.Dwarf32);
        }
        if (l3 == l2) {
            l3 = this.readU64();
            return new Pair<Long, Format>(l3, Format.Dwarf64);
        }
        Log.error("UnknownReservedLength", new Object[0]);
        return null;
    }

    public Reader split(Long var1);

    default public boolean isEmpty() {
        return this.len() == 0L;
    }

    public Long offsetId();

    public Reader _clone();
}

