/*
 * Decompiled with CFR 0.152.
 */
package com.uqm.crashsight.symtabtool.dwarf;

import com.uqm.crashsight.symtabtool.dwarf.Endianity;
import com.uqm.crashsight.symtabtool.dwarf.ParseBuffer;
import com.uqm.crashsight.symtabtool.dwarf.Reader;

class EndianSlice<Endian extends Endianity>
implements Reader {
    ParseBuffer slice;
    Endian endian;

    public EndianSlice(ParseBuffer parseBuffer, Endian Endian) {
        this.slice = parseBuffer;
        this.endian = Endian;
    }

    public ParseBuffer buf() {
        return this.slice;
    }

    public long offsetFrom(EndianSlice<Endian> endianSlice) {
        long l = endianSlice.slice.getPtr();
        long l2 = this.slice.getPtr();
        assert (l <= l2);
        assert (l2 + this.slice.len() <= l + endianSlice.slice.len());
        return l2 - l;
    }

    public ParseBuffer readSlice(long l) {
        if (this.slice.len() < l) {
            throw new RuntimeException("UnexpectedEof");
        }
        ParseBuffer[] parseBufferArray = this.slice.take(l);
        this.slice = parseBufferArray[1];
        return parseBufferArray[0];
    }

    private long _find(byte by) {
        return this.slice.find(by);
    }

    @Override
    public Endianity endian() {
        return this.endian;
    }

    @Override
    public EndianSlice<Endian> _clone() {
        ParseBuffer parseBuffer = this.slice.copy();
        return new EndianSlice<Endian>(parseBuffer, this.endian);
    }

    @Override
    public Long len() {
        return null;
    }

    @Override
    public boolean isEmpty() {
        return this.slice.isEmpty();
    }

    @Override
    public Long offsetId() {
        return this.slice.getSectionOffset();
    }

    @Override
    public void empty() {
    }

    @Override
    public Long offsetFrom(Reader reader) {
        return this.offsetFrom((EndianSlice)reader);
    }

    @Override
    public void readSlice(byte[] byArray) {
    }

    @Override
    public short readU8() {
        return this.slice.readU8();
    }

    @Override
    public int readU16() {
        return this.slice.readU16();
    }

    @Override
    public long readU32() {
        return this.slice.readU32();
    }

    @Override
    public long readU64() {
        return this.slice.readI64();
    }

    @Override
    public short readI16() {
        return this.slice.readI16();
    }

    @Override
    public int readI32() {
        return this.slice.readI32();
    }

    @Override
    public long readI64() {
        return this.slice.readI64();
    }

    @Override
    public long readULeb128() {
        return this.slice.parseULeb128();
    }

    @Override
    public long readSLeb128() {
        return this.slice.parseSLeb128();
    }

    @Override
    public Long find(byte by) {
        long l = this._find(by);
        if (l == -1L) {
            throw new RuntimeException("UnexpectedEof:" + this.offsetId());
        }
        return l;
    }

    @Override
    public void skip(Long l) {
        if (this.slice.len() < l) {
            throw new RuntimeException("UnexpectedEof:" + this.offsetId());
        }
        this.readSlice(l);
    }

    @Override
    public Reader split(Long l) {
        ParseBuffer parseBuffer = this.readSlice(l);
        return new EndianSlice<Endian>(parseBuffer, this.endian);
    }
}

