/*
 * Decompiled with CFR 0.152.
 */
package com.uqm.crashsight.symtabtool.dwarf;

import com.uqm.crashsight.symtabtool.dwarf.EndianSlice;
import com.uqm.crashsight.symtabtool.dwarf.Endianity;
import com.uqm.crashsight.symtabtool.dwarf.Format;
import com.uqm.crashsight.symtabtool.dwarf.ParseBuffer;
import com.uqm.crashsight.symtabtool.dwarf.Reader;
import com.uqm.crashsight.symtabtool.dwarf.UnwindSectionExt;

class DebugFrame<Endian extends Endianity>
implements UnwindSectionExt {
    Reader section;
    byte addressSize;
    byte segmentSize;

    DebugFrame() {
    }

    @Override
    public void setAddressSize(byte by) {
        this.addressSize = by;
    }

    public void setSegmentSize(byte by) {
        this.segmentSize = by;
    }

    public static <Endian extends Endianity> DebugFrame<Endian> from(EndianSlice<Endian> endianSlice) {
        DebugFrame<Endian> debugFrame = new DebugFrame<Endian>();
        debugFrame.section = endianSlice;
        debugFrame.addressSize = (byte)8;
        debugFrame.segmentSize = 0;
        return debugFrame;
    }

    public static <Endian extends Endianity> DebugFrame<Endian> _new(ParseBuffer parseBuffer, Endian Endian) {
        EndianSlice<Endian> endianSlice = new EndianSlice<Endian>(parseBuffer, Endian);
        return DebugFrame.from(endianSlice);
    }

    @Override
    public boolean isCie(Format format, long l) {
        if (format == Format.Dwarf32) {
            return l == 0xFFFFFFFFL;
        }
        if (format == Format.Dwarf64) {
            return l == -1L;
        }
        return false;
    }

    @Override
    public Reader section() {
        return this.section;
    }

    @Override
    public boolean lengthValueIsEndOfEntries(Long l) {
        return false;
    }

    @Override
    public boolean hasAddressAndSegmentSizes(short s2) {
        return s2 == 4;
    }

    @Override
    public short addressSize() {
        return this.addressSize;
    }

    @Override
    public short segmentSize() {
        return this.segmentSize;
    }

    @Override
    public Long resolveCieOffset(long l, long l2) {
        return l2;
    }
}

