/*
 * Decompiled with CFR 0.152.
 */
package com.uqm.crashsight.symtabtool.dwarf;

import com.uqm.crashsight.symtabtool.dwarf.RegisterNames;

enum CpuFamily {
    Unknown(0),
    Intel32(1),
    Amd64(2),
    Arm32(3),
    Arm64(4),
    Ppc32(5),
    Ppc64(6),
    Mips32(7),
    Mips64(8),
    Arm64_32(9),
    Wasm32(10);

    private final int val;

    private CpuFamily(int n2) {
        this.val = n2;
    }

    public Long pointerSize() {
        switch (this) {
            case Wasm32: 
            case Intel32: 
            case Arm32: 
            case Ppc32: 
            case Mips32: {
                return 4L;
            }
            case Arm64: 
            case Amd64: 
            case Ppc64: 
            case Mips64: 
            case Arm64_32: {
                return 8L;
            }
        }
        return null;
    }

    public String cfiRegisterName(int n) {
        switch (this) {
            case Intel32: {
                if (n >= RegisterNames.I386.length) {
                    return null;
                }
                return RegisterNames.I386[n];
            }
            case Amd64: {
                if (n >= RegisterNames.X86_64.length) {
                    return null;
                }
                return RegisterNames.X86_64[n];
            }
            case Arm64: 
            case Arm64_32: {
                if (n >= RegisterNames.ARM64.length) {
                    return null;
                }
                return RegisterNames.ARM64[n];
            }
            case Arm32: {
                if (n >= RegisterNames.ARM.length) {
                    return null;
                }
                return RegisterNames.ARM[n];
            }
            case Mips32: 
            case Mips64: {
                if (n >= RegisterNames.MIPS.length) {
                    return null;
                }
                return RegisterNames.MIPS[n];
            }
        }
        return null;
    }
}

