/*
 * Decompiled with CFR 0.152.
 */
package com.uqm.crashsight.symtabtool.dwarf;

import com.uqm.crashsight.symtabtool.dwarf.CpuFamily;

enum Arch {
    Unknown(0),
    X86(101),
    X86Unknown(199),
    Amd64(201),
    Amd64h(202),
    Amd64Unknown(299),
    Arm(301),
    ArmV5(302),
    ArmV6(303),
    ArmV6m(304),
    ArmV7(305),
    ArmV7f(306),
    ArmV7s(307),
    ArmV7k(308),
    ArmV7m(309),
    ArmV7em(310),
    ArmUnknown(399),
    Arm64(401),
    Arm64V8(402),
    Arm64e(403),
    Arm64Unknown(499),
    Ppc(501),
    Ppc64(601),
    Mips(701),
    Mips64(801),
    Arm64_32(901),
    Arm64_32V8(902),
    Arm64_32Unknown(999),
    Wasm32(1001);

    private final int val;

    private Arch(int n2) {
        this.val = n2;
    }

    CpuFamily cpuFamily() {
        switch (this) {
            case Unknown: {
                return CpuFamily.Unknown;
            }
            case X86: 
            case X86Unknown: {
                return CpuFamily.Intel32;
            }
            case Amd64: 
            case Amd64h: 
            case Amd64Unknown: {
                return CpuFamily.Amd64;
            }
            case Arm64: 
            case Arm64V8: 
            case Arm64e: 
            case Arm64Unknown: {
                return CpuFamily.Arm64;
            }
            case Arm: 
            case ArmV5: 
            case ArmV6: 
            case ArmV6m: 
            case ArmV7: 
            case ArmV7f: 
            case ArmV7s: 
            case ArmV7k: 
            case ArmV7m: 
            case ArmV7em: 
            case ArmUnknown: {
                return CpuFamily.Arm32;
            }
            case Ppc: {
                return CpuFamily.Ppc32;
            }
            case Ppc64: {
                return CpuFamily.Ppc64;
            }
            case Mips: {
                return CpuFamily.Mips32;
            }
            case Mips64: {
                return CpuFamily.Mips64;
            }
            case Arm64_32: 
            case Arm64_32V8: 
            case Arm64_32Unknown: {
                return CpuFamily.Arm64_32;
            }
            case Wasm32: {
                return CpuFamily.Wasm32;
            }
        }
        return CpuFamily.Unknown;
    }

    public String _name() {
        switch (this) {
            case Wasm32: {
                return "wasm32";
            }
            case X86: {
                return "x86";
            }
            case X86Unknown: {
                return "x86_unknown";
            }
            case Amd64: {
                return "x86_64";
            }
            case Amd64h: {
                return "x86_64h";
            }
            case Amd64Unknown: {
                return "x86_64_unknown";
            }
            case Arm64: {
                return "arm64";
            }
            case Arm64V8: {
                return "arm64v8";
            }
            case Arm64e: {
                return "arm64e";
            }
            case Arm64Unknown: {
                return "arm64_unknown";
            }
            case Arm: {
                return "arm";
            }
            case ArmV5: {
                return "armv5";
            }
            case ArmV6: {
                return "armv6";
            }
            case ArmV6m: {
                return "armv6m";
            }
            case ArmV7: {
                return "armv7";
            }
            case ArmV7f: {
                return "armv7f";
            }
            case ArmV7s: {
                return "armv7s";
            }
            case ArmV7k: {
                return "armv7k";
            }
            case ArmV7m: {
                return "armv7m";
            }
            case ArmV7em: {
                return "armv7em";
            }
            case ArmUnknown: {
                return "arm_unknown";
            }
            case Ppc: {
                return "ppc";
            }
            case Ppc64: {
                return "ppc64";
            }
            case Mips: {
                return "mips";
            }
            case Mips64: {
                return "mips64";
            }
            case Arm64_32: {
                return "arm64_32";
            }
            case Arm64_32V8: {
                return "arm64_32_v8";
            }
            case Arm64_32Unknown: {
                return "arm64_32_unknown";
            }
        }
        return "unknown";
    }
}

