/*
 * Decompiled with CFR 0.152.
 */
package com.uqm.crashsight.symtabtool.common.utils;

import com.uqm.crashsight.symtabtool.common.utils.Log;
import com.uqm.crashsight.symtabtool.pe.Section;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;

public class Utils {
    public static final long FIX_UBYTE = 255L;
    public static final long FIX_USHORT = 65535L;
    public static final long FIX_UINT = 0xFFFFFFFFL;
    private static HashMap<String, Long> recordTimes = new HashMap();
    private static HashMap<String, Long> startTimes = new HashMap();
    private static HashMap<String, Long> totalTimes = new HashMap();
    private static final String DEFAULT_RECORD_KEY = "default_record";
    private static final String ALGORITHM = "SHA1";
    private static final int ENCODE_BUFFER_SIZE = 4096;
    private static final char[] HEX_ARRAY = "0123456789abcdef".toCharArray();

    public static long unsignedToLong(byte by) {
        return (long)by & 0xFFL;
    }

    public static long unsignedToLong(short s2) {
        return (long)s2 & 0xFFFFL;
    }

    public static long unsignedToLong(int n) {
        return (long)n & 0xFFFFFFFFL;
    }

    public static void recordTime(String string) {
        String string2;
        String string3 = string2 = string == null ? DEFAULT_RECORD_KEY : string;
        if (recordTimes.containsKey(string2)) {
            Utils.printUsedTime(string, recordTimes.get(string2), System.nanoTime());
        }
        recordTimes.put(string2, System.nanoTime());
    }

    public static void recordTime() {
        Utils.recordTime(null);
    }

    public static void recordBegin(String string) {
        if (string == null) {
            return;
        }
        startTimes.put(string, System.nanoTime());
    }

    public static void recordEnd(String string) {
        if (string == null) {
            return;
        }
        if (!startTimes.containsKey(string)) {
            return;
        }
        long l = System.nanoTime() - startTimes.get(string);
        if (totalTimes.containsKey(string)) {
            l += totalTimes.get(string).longValue();
        }
        totalTimes.put(string, l);
    }

    public static void printRecordTime(String string) {
        if (string == null) {
            return;
        }
        if (!totalTimes.containsKey(string)) {
            return;
        }
        Utils.printTotalUsedTime(string, totalTimes.get(string));
    }

    public static void printUsedTime(String string, long l, long l2) {
        Utils.printTotalUsedTime(string, l2 - l);
    }

    public static void printTotalUsedTime(String string, long l) {
        String string2 = "";
        string2 = null != string ? "<" + string + "> time Used: " : "Time Used: ";
        Log.info(string2 + Utils.getUsedTimeString(l), new Object[0]);
    }

    public static String getUsedTimeString(long l) {
        StringBuilder stringBuilder = new StringBuilder();
        if (l > 60000000000L) {
            long l2 = l / 60000000000L;
            l %= 60000000000L;
            stringBuilder.append(String.valueOf(l2) + "min ");
        }
        double d = (double)l / 1.0E9;
        NumberFormat numberFormat = NumberFormat.getNumberInstance();
        numberFormat.setMaximumFractionDigits(2);
        stringBuilder.append(numberFormat.format(d) + "s");
        return stringBuilder.toString();
    }

    public static String getDateTime() {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");
        return simpleDateFormat.format(new Date());
    }

    public static String byteArrayToHexString(byte[] byArray) {
        StringBuilder stringBuilder = new StringBuilder();
        for (byte by : byArray) {
            int n = by & 0xFF;
            if (n < 16) {
                stringBuilder.append('0');
            }
            stringBuilder.append(Integer.toHexString(n));
        }
        return stringBuilder.toString();
    }

    public static String bytesToHex(byte[] byArray) {
        char[] cArray = new char[byArray.length * 2];
        for (int i = 0; i < byArray.length; ++i) {
            int n = byArray[i] & 0xFF;
            cArray[i * 2] = HEX_ARRAY[n >>> 4];
            cArray[i * 2 + 1] = HEX_ARRAY[n & 0xF];
        }
        return new String(cArray);
    }

    public static void reverseByteArray(byte[] byArray, int n, int n2) {
        int n3 = n;
        for (int i = n2 - 1; n3 < i; ++n3, --i) {
            byte by = byArray[n3];
            byArray[n3] = byArray[i];
            byArray[i] = by;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getFileSha1(String string) {
        if (null == string) {
            return null;
        }
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(new File(string));
        }
        catch (FileNotFoundException fileNotFoundException) {
            Log.error(fileNotFoundException);
            return null;
        }
        MessageDigest messageDigest = null;
        try {
            messageDigest = MessageDigest.getInstance(ALGORITHM);
            byte[] byArray = new byte[4096];
            int n = 0;
            while ((n = fileInputStream.read(byArray)) > 0) {
                messageDigest.update(byArray, 0, n);
            }
            String string2 = Utils.byteArrayToHexString(messageDigest.digest());
            return string2;
        }
        catch (IOException iOException) {
            Log.error(iOException);
            String string3 = null;
            return string3;
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            Log.error(noSuchAlgorithmException);
            String string4 = null;
            return string4;
        }
        finally {
            try {
                fileInputStream.close();
            }
            catch (IOException iOException) {
                Log.error(iOException);
            }
        }
    }

    public static String urlEncodeString(String string) {
        try {
            return URLEncoder.encode(string, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            Log.error(unsupportedEncodingException);
            return null;
        }
    }

    public static void sleep(long l) {
        try {
            Thread.sleep(l);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public static long findOffset(long l, Section[] sectionArray, long l2) {
        long l3 = -1L;
        int n = 511;
        for (int i = 0; i < sectionArray.length; ++i) {
            if (!sectionArray[i].is_in_section(l, l2)) continue;
            l3 = l - sectionArray[i].virtualAddress + (sectionArray[i].pointerToRawData & (long)(~n));
            break;
        }
        return l3;
    }
}

