/*
 * Decompiled with CFR 0.152.
 */
package com.uqm.crashsight.symtabtool.common.utils;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;

public class Log {
    public static final int DEBUG_LEVEL = 0;
    public static final int INFO_LEVEL = 1;
    public static final int WARN_LEVEL = 2;
    public static final int ERROR_LEVEL = 3;
    private static LogPrinter printer = null;
    private static final boolean isPrintDebug = false;
    private static boolean isDebug = false;
    private static boolean isEnable = false;
    private static Thread printThread = null;
    private static final Object PRINT_THREAD_LOCK = new Object();

    public static void setDebugMode(boolean bl) {
        isDebug = bl;
    }

    public static void setEnable(boolean bl) {
        isEnable = bl;
    }

    public static LogPrinter getPrinter() {
        if (printer == null) {
            printer = new DefaultLogPrinter();
        }
        return printer;
    }

    public static void setPrinter(LogPrinter logPrinter) {
        System.setProperty("file.encoding", "UTF-8");
        printer = logPrinter;
    }

    public static String format(String string, Object ... objectArray) {
        if (string == null) {
            string = "";
        }
        if (objectArray == null || objectArray.length == 0) {
            return String.format("%s", string);
        }
        return String.format("%s", String.format(Locale.US, string, objectArray));
    }

    private static boolean print(int n, String string, Object ... objectArray) {
        Log.stopBusyingLog();
        if (!isEnable) {
            return false;
        }
        LogPrinter logPrinter = Log.getPrinter();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String string2 = simpleDateFormat.format(new Date());
        System.out.print(string2 + " ");
        String string3 = Log.format(string, objectArray);
        switch (n) {
            case 0: {
                if (isDebug) {
                    logPrinter.printDebug(string3);
                }
                return true;
            }
            case 1: {
                logPrinter.printInfo(string3);
                return true;
            }
            case 2: {
                logPrinter.printWarn(string3);
                return true;
            }
            case 3: {
                logPrinter.printError(string3);
                return true;
            }
        }
        return false;
    }

    private static boolean print(int n, Throwable throwable) {
        String string = Log.parseThrowable(throwable);
        return Log.print(n, string, new Object[0]);
    }

    public static boolean info(String string, Object ... objectArray) {
        return Log.print(1, string, objectArray);
    }

    public static boolean debug(String string, Object ... objectArray) {
        return false;
    }

    public static boolean warn(String string, Object ... objectArray) {
        return Log.print(2, string, objectArray);
    }

    public static boolean warn(Throwable throwable) {
        return Log.print(2, throwable);
    }

    public static boolean error(String string, Object ... objectArray) {
        return Log.print(3, string, objectArray);
    }

    public static boolean error(Throwable throwable) {
        return Log.print(3, throwable);
    }

    public static String parseThrowable(Throwable throwable) {
        if (throwable == null) {
            return "";
        }
        try {
            StringWriter stringWriter = new StringWriter();
            throwable.printStackTrace(new PrintWriter(stringWriter));
            return stringWriter.getBuffer().toString();
        }
        catch (Throwable throwable2) {
            if (!Log.warn(throwable2)) {
                throwable2.printStackTrace();
            }
            return "fail";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void printBusyingLog(String string, final long l) {
        if (printThread != null) {
            Log.stopBusyingLog();
        }
        Object object = PRINT_THREAD_LOCK;
        synchronized (object) {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            String string2 = simpleDateFormat.format(new Date());
            System.out.print(string2 + " ");
            System.out.print(Log.getPrinter().infoTag + string);
            printThread = new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        while (true) {
                            Thread.sleep(l);
                            System.out.print(".");
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        return;
                    }
                }
            });
            printThread.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void stopBusyingLog() {
        if (printThread == null) {
            return;
        }
        Object object = PRINT_THREAD_LOCK;
        synchronized (object) {
            if (printThread == null) {
                return;
            }
            printThread.interrupt();
            if (!printThread.isInterrupted()) {
                printThread.stop();
            }
            printThread = null;
            System.out.println();
        }
    }

    private static class DefaultLogPrinter
    extends LogPrinter {
        private DefaultLogPrinter() {
        }

        @Override
        protected void setTag() {
            this.infoTag = "[I] ";
            this.debugTag = "[D] ";
            this.warnTag = "[W] ";
            this.errorTag = "[E] ";
        }
    }

    public static abstract class LogPrinter {
        public String infoTag = null;
        public String debugTag = null;
        public String warnTag = null;
        public String errorTag = null;

        public LogPrinter() {
            this.setTag();
        }

        protected abstract void setTag();

        public void printInfo(String string) {
            if (this.infoTag != null) {
                System.out.print(this.infoTag);
            }
            System.out.println(string);
        }

        public void printDebug(String string) {
            if (this.debugTag != null) {
                System.out.print(this.debugTag);
            }
            System.out.println(string);
        }

        public void printWarn(String string) {
            if (this.warnTag != null) {
                System.out.print(this.warnTag);
            }
            System.out.println(string);
        }

        public void printError(String string) {
            if (this.errorTag != null) {
                System.out.print(this.errorTag);
            }
            System.out.println(string);
        }
    }
}

