/*
 * Decompiled with CFR 0.152.
 */
package com.uqm.crashsight.symtabtool.common.file;

import com.uqm.crashsight.symtabtool.common.utils.Log;
import com.uqm.crashsight.symtabtool.dwarf.SectionParseBuffer;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.ByteOrder;
import java.util.Arrays;
import org.apache.commons.logging.LogFactory;

public class SectionReader {
    private static final long MEM_READ_THRESHOLD = 0x3FFFFFFFL;
    private static final long FIX_LEB128 = 127L;
    private static final org.apache.commons.logging.Log log = LogFactory.getLog(SectionReader.class);
    public static long INVALID_ENDIAN = -1L;
    public static long BIG_ENDIAN = 0L;
    public static long LITTLE_ENDIAN = 1L;
    private final byte[] shortByteArray = new byte[2];
    private final byte[] intByteArray = new byte[4];
    private final byte[] longByteArray = new byte[8];
    private static final int LONG_BYTES_NUMBER = 8;
    private static final int INT_BYTES_NUMBER = 4;
    private static final int SHORT_BYTES_NUMBER = 2;
    private static final long FIX_UBYTE = 255L;
    private static final long FIX_USHORT = 65535L;
    private static final long FIX_UINT = 0xFFFFFFFFL;
    private long endian = LITTLE_ENDIAN;
    private String fileName = null;
    private long sectionOffset = 0L;
    private long sectionSize = 0L;
    private BufferedInputStream bis = null;
    private long offset = 0L;
    private long readBytes = 0L;
    private boolean useParseBuffer = false;
    SectionParseBuffer parseBuffer = null;

    public SectionReader(String string, long l, long l2, boolean bl) throws Exception {
        this.fileName = string;
        this.sectionOffset = l;
        this.sectionSize = l2;
        this.endian = bl ? LITTLE_ENDIAN : BIG_ENDIAN;
        this.open();
    }

    private void open() throws Exception {
        if (null == this.fileName) {
            throw new Exception("File name is null!");
        }
        if (this.sectionSize <= 0x3FFFFFFFL) {
            this.useParseBuffer = true;
            this.parseBuffer = new SectionParseBuffer(this.fileName, this.sectionOffset, (int)this.sectionSize, this.endian == LITTLE_ENDIAN ? ByteOrder.LITTLE_ENDIAN : ByteOrder.BIG_ENDIAN);
        } else {
            this.bis = new BufferedInputStream(new FileInputStream(this.fileName));
            this.skip(this.sectionOffset);
            this.offset = 0L;
            this.readBytes = 0L;
        }
    }

    public long getReadBytesNum() {
        return this.readBytes;
    }

    public void resetReadBytes() {
        this.readBytes = 0L;
    }

    public long getSectionRestLength() {
        return this.sectionSize - this.getOffset();
    }

    public long getOffset() {
        if (this.useParseBuffer) {
            return this.parseBuffer.pos();
        }
        return this.offset;
    }

    public long getFileOffset() {
        if (this.useParseBuffer) {
            return this.parseBuffer.pos() + this.sectionOffset;
        }
        return this.offset + this.sectionOffset;
    }

    public boolean close() {
        try {
            this.fileName = null;
            if (this.useParseBuffer) {
                return true;
            }
            if (null != this.bis) {
                this.bis.close();
            }
            this.bis = null;
            this.offset = 0L;
            this.readBytes = 0L;
            return true;
        }
        catch (IOException iOException) {
            Log.error(iOException);
            return false;
        }
    }

    public boolean skip(long l) {
        if (this.useParseBuffer) {
            this.parseBuffer.skip(l);
            return true;
        }
        if (null == this.bis) {
            Log.error("Please open file first\uff01", new Object[0]);
            return false;
        }
        if (0L == l) {
            return true;
        }
        for (long i = l; i > 0L; i -= this.bis.skip(i)) {
            try {
                continue;
            }
            catch (IOException iOException) {
                Log.error("Failed to skip file pointer\uff01", new Object[0]);
                return false;
            }
        }
        this.offset += l;
        return true;
    }

    public byte readByte() throws IOException {
        if (this.useParseBuffer) {
            ++this.readBytes;
            return this.parseBuffer.readByte();
        }
        byte by = 0;
        if (null == this.bis) {
            Log.error("Failed to skip file pointer\uff01", new Object[0]);
            return by;
        }
        by = (byte)this.bis.read();
        ++this.offset;
        ++this.readBytes;
        return by;
    }

    public short readShort() throws IOException {
        if (this.useParseBuffer) {
            this.readBytes += 2L;
            return this.parseBuffer.readI16();
        }
        short s2 = 0;
        if (null == this.bis) {
            Log.error("Failed to skip file pointer\uff01", new Object[0]);
            return s2;
        }
        this.bis.read(this.shortByteArray);
        s2 = SectionReader.byteArrayToShort(this.shortByteArray, this.endian);
        this.offset += 2L;
        this.readBytes += 2L;
        return s2;
    }

    public int readInt() throws IOException {
        if (this.useParseBuffer) {
            this.readBytes += 4L;
            return this.parseBuffer.readI32();
        }
        int n = 0;
        if (null == this.bis) {
            Log.error("Failed to skip file pointer\uff01", new Object[0]);
            return n;
        }
        this.bis.read(this.intByteArray);
        n = SectionReader.byteArrayToInt(this.intByteArray, this.endian);
        this.offset += 4L;
        this.readBytes += 4L;
        return n;
    }

    public long readLong() throws IOException {
        if (this.useParseBuffer) {
            this.readBytes += 8L;
            return this.parseBuffer.readI64();
        }
        long l = 0L;
        if (null == this.bis) {
            Log.error("Failed to skip file pointer\uff01", new Object[0]);
            return l;
        }
        this.bis.read(this.longByteArray);
        l = SectionReader.byteArrayToLong(this.longByteArray, this.endian);
        this.offset += 8L;
        this.readBytes += 8L;
        return l;
    }

    public long readUByte() throws IOException {
        return (long)this.readByte() & 0xFFL;
    }

    public long readUShort() throws IOException {
        return (long)this.readShort() & 0xFFFFL;
    }

    public long readUInt() throws IOException {
        return (long)this.readInt() & 0xFFFFFFFFL;
    }

    public long readULong() throws IOException {
        return this.readLong();
    }

    private static short byteArrayToShortLE(byte[] byArray) {
        if (null == byArray || byArray.length > 2) {
            return -1;
        }
        return (short)SectionReader.byteArrayToIntLE(byArray);
    }

    private static int byteArrayToIntLE(byte[] byArray) {
        if (null == byArray || byArray.length > 4) {
            return -1;
        }
        return (int)SectionReader.byteArrayToLongLE(byArray);
    }

    private static long byteArrayToLongLE(byte[] byArray) {
        if (null == byArray || byArray.length > 8) {
            return -1L;
        }
        long l = 0L;
        for (int i = byArray.length - 1; i >= 0; --i) {
            l <<= 8;
            l |= (long)byArray[i] & 0xFFL;
        }
        return l;
    }

    private static short byteArrayToShortBE(byte[] byArray) {
        if (null == byArray || byArray.length > 2) {
            return -1;
        }
        return (short)SectionReader.byteArrayToIntBE(byArray);
    }

    private static int byteArrayToIntBE(byte[] byArray) {
        if (null == byArray || byArray.length > 4) {
            return -1;
        }
        return (int)SectionReader.byteArrayToLongBE(byArray);
    }

    private static long byteArrayToLongBE(byte[] byArray) {
        if (null == byArray || byArray.length > 8) {
            return -1L;
        }
        long l = 0L;
        for (byte by : byArray) {
            l <<= 8;
            l |= (long)by & 0xFFL;
        }
        return l;
    }

    public static short byteArrayToShort(byte[] byArray, long l) {
        if (LITTLE_ENDIAN == l) {
            return SectionReader.byteArrayToShortLE(byArray);
        }
        return SectionReader.byteArrayToShortBE(byArray);
    }

    public static int byteArrayToInt(byte[] byArray, long l) {
        if (LITTLE_ENDIAN == l) {
            return SectionReader.byteArrayToIntLE(byArray);
        }
        return SectionReader.byteArrayToIntBE(byArray);
    }

    public static long byteArrayToLong(byte[] byArray, long l) {
        if (LITTLE_ENDIAN == l) {
            return SectionReader.byteArrayToLongLE(byArray);
        }
        return SectionReader.byteArrayToLongBE(byArray);
    }

    public long parseULeb128() throws IOException {
        byte by;
        long l = 0L;
        long l2 = 0L;
        long l3 = 0L;
        do {
            by = this.readByte();
            l |= ((long)by & 0x7FL) << (int)l2;
            l2 += 7L;
        } while ((by & 0x80) != 0 && ++l3 <= 1000L);
        return l;
    }

    public long parseSLeb128() throws IOException {
        byte by;
        long l = 0L;
        long l2 = 0L;
        boolean bl = false;
        do {
            by = this.readByte();
            l |= ((long)by & 0x7FL) << (int)l2;
            l2 += 7L;
            boolean bl2 = bl = (by & 0x40) != 0;
        } while ((by & 0x80) != 0);
        if (bl) {
            l |= (long)(-(1 << (int)l2));
        }
        return l;
    }

    public boolean readByteArray(byte[] byArray) {
        try {
            if (this.useParseBuffer) {
                for (int i = 0; i < byArray.length; ++i) {
                    ++this.readBytes;
                    byArray[i] = this.parseBuffer.readByte();
                }
                return true;
            }
            this.bis.read(byArray);
        }
        catch (IOException iOException) {
            Log.error(iOException);
            return false;
        }
        this.offset += (long)byArray.length;
        this.readBytes += (long)byArray.length;
        return true;
    }

    public Context getParseBufferContext() {
        if (this.useParseBuffer) {
            return new Context(this.getOffset(), this.readBytes);
        }
        return null;
    }

    public void loadParseBufferContext(Context context) {
        if (!this.useParseBuffer) {
            return;
        }
        if (context == null) {
            return;
        }
        this.readBytes = context.readBytes;
        this.parseBuffer.pos(context.offset);
    }

    public void resetParseBuffer() {
        this.offset = 0L;
        this.readBytes = 0L;
        this.parseBuffer.pos(this.offset);
    }

    public byte[] getShortByteArray() {
        return this.shortByteArray;
    }

    public byte[] getIntByteArray() {
        return this.intByteArray;
    }

    public byte[] getLongByteArray() {
        return this.longByteArray;
    }

    public long getEndian() {
        return this.endian;
    }

    public String getFileName() {
        return this.fileName;
    }

    public long getSectionOffset() {
        return this.sectionOffset;
    }

    public long getSectionSize() {
        return this.sectionSize;
    }

    public BufferedInputStream getBis() {
        return this.bis;
    }

    public long getReadBytes() {
        return this.readBytes;
    }

    public boolean isUseParseBuffer() {
        return this.useParseBuffer;
    }

    public SectionParseBuffer getParseBuffer() {
        return this.parseBuffer;
    }

    public void setEndian(long l) {
        this.endian = l;
    }

    public void setFileName(String string) {
        this.fileName = string;
    }

    public void setSectionOffset(long l) {
        this.sectionOffset = l;
    }

    public void setSectionSize(long l) {
        this.sectionSize = l;
    }

    public void setBis(BufferedInputStream bufferedInputStream) {
        this.bis = bufferedInputStream;
    }

    public void setOffset(long l) {
        this.offset = l;
    }

    public void setReadBytes(long l) {
        this.readBytes = l;
    }

    public void setUseParseBuffer(boolean bl) {
        this.useParseBuffer = bl;
    }

    public void setParseBuffer(SectionParseBuffer sectionParseBuffer) {
        this.parseBuffer = sectionParseBuffer;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof SectionReader)) {
            return false;
        }
        SectionReader sectionReader = (SectionReader)object;
        if (!sectionReader.canEqual(this)) {
            return false;
        }
        if (this.getEndian() != sectionReader.getEndian()) {
            return false;
        }
        if (this.getSectionOffset() != sectionReader.getSectionOffset()) {
            return false;
        }
        if (this.getSectionSize() != sectionReader.getSectionSize()) {
            return false;
        }
        if (this.getOffset() != sectionReader.getOffset()) {
            return false;
        }
        if (this.getReadBytes() != sectionReader.getReadBytes()) {
            return false;
        }
        if (this.isUseParseBuffer() != sectionReader.isUseParseBuffer()) {
            return false;
        }
        if (!Arrays.equals(this.getShortByteArray(), sectionReader.getShortByteArray())) {
            return false;
        }
        if (!Arrays.equals(this.getIntByteArray(), sectionReader.getIntByteArray())) {
            return false;
        }
        if (!Arrays.equals(this.getLongByteArray(), sectionReader.getLongByteArray())) {
            return false;
        }
        String string = this.getFileName();
        String string2 = sectionReader.getFileName();
        if (string == null ? string2 != null : !string.equals(string2)) {
            return false;
        }
        BufferedInputStream bufferedInputStream = this.getBis();
        BufferedInputStream bufferedInputStream2 = sectionReader.getBis();
        if (bufferedInputStream == null ? bufferedInputStream2 != null : !bufferedInputStream.equals(bufferedInputStream2)) {
            return false;
        }
        SectionParseBuffer sectionParseBuffer = this.getParseBuffer();
        SectionParseBuffer sectionParseBuffer2 = sectionReader.getParseBuffer();
        return !(sectionParseBuffer == null ? sectionParseBuffer2 != null : !((Object)sectionParseBuffer).equals(sectionParseBuffer2));
    }

    protected boolean canEqual(Object object) {
        return object instanceof SectionReader;
    }

    public int hashCode() {
        int n = 59;
        int n2 = 1;
        long l = this.getEndian();
        n2 = n2 * 59 + (int)(l >>> 32 ^ l);
        long l2 = this.getSectionOffset();
        n2 = n2 * 59 + (int)(l2 >>> 32 ^ l2);
        long l3 = this.getSectionSize();
        n2 = n2 * 59 + (int)(l3 >>> 32 ^ l3);
        long l4 = this.getOffset();
        n2 = n2 * 59 + (int)(l4 >>> 32 ^ l4);
        long l5 = this.getReadBytes();
        n2 = n2 * 59 + (int)(l5 >>> 32 ^ l5);
        n2 = n2 * 59 + (this.isUseParseBuffer() ? 79 : 97);
        n2 = n2 * 59 + Arrays.hashCode(this.getShortByteArray());
        n2 = n2 * 59 + Arrays.hashCode(this.getIntByteArray());
        n2 = n2 * 59 + Arrays.hashCode(this.getLongByteArray());
        String string = this.getFileName();
        n2 = n2 * 59 + (string == null ? 43 : string.hashCode());
        BufferedInputStream bufferedInputStream = this.getBis();
        n2 = n2 * 59 + (bufferedInputStream == null ? 43 : bufferedInputStream.hashCode());
        SectionParseBuffer sectionParseBuffer = this.getParseBuffer();
        n2 = n2 * 59 + (sectionParseBuffer == null ? 43 : ((Object)sectionParseBuffer).hashCode());
        return n2;
    }

    public String toString() {
        return "SectionReader(shortByteArray=" + Arrays.toString(this.getShortByteArray()) + ", intByteArray=" + Arrays.toString(this.getIntByteArray()) + ", longByteArray=" + Arrays.toString(this.getLongByteArray()) + ", endian=" + this.getEndian() + ", fileName=" + this.getFileName() + ", sectionOffset=" + this.getSectionOffset() + ", sectionSize=" + this.getSectionSize() + ", bis=" + this.getBis() + ", offset=" + this.getOffset() + ", readBytes=" + this.getReadBytes() + ", useParseBuffer=" + this.isUseParseBuffer() + ", parseBuffer=" + this.getParseBuffer() + ")";
    }

    public static class Context {
        long offset = 0L;
        long readBytes = 0L;

        public Context(long l, long l2) {
            this.offset = l;
            this.readBytes = l2;
        }

        public long getOffset() {
            return this.offset;
        }

        public long getReadBytes() {
            return this.readBytes;
        }

        public void setOffset(long l) {
            this.offset = l;
        }

        public void setReadBytes(long l) {
            this.readBytes = l;
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (!(object instanceof Context)) {
                return false;
            }
            Context context = (Context)object;
            if (!context.canEqual(this)) {
                return false;
            }
            if (this.getOffset() != context.getOffset()) {
                return false;
            }
            return this.getReadBytes() == context.getReadBytes();
        }

        protected boolean canEqual(Object object) {
            return object instanceof Context;
        }

        public int hashCode() {
            int n = 59;
            int n2 = 1;
            long l = this.getOffset();
            n2 = n2 * 59 + (int)(l >>> 32 ^ l);
            long l2 = this.getReadBytes();
            n2 = n2 * 59 + (int)(l2 >>> 32 ^ l2);
            return n2;
        }

        public String toString() {
            return "SectionReader.Context(offset=" + this.getOffset() + ", readBytes=" + this.getReadBytes() + ")";
        }
    }
}

