/*
 * Decompiled with CFR 0.152.
 */
package com.uqm.crashsight.symtabparser.common.utils;

import com.sun.jna.Native;
import com.sun.jna.NativeLibrary;
import com.sun.jna.Platform;
import com.uqm.crashsight.symtabparser.common.utils.IDemangle;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import org.springframework.core.io.ClassPathResource;

public class DemangleFactory {
    public static IDemangle createLibrary() {
        ClassPathResource classPathResource = null;
        String string = null;
        if (Platform.isWindows()) {
            classPathResource = new ClassPathResource("demangle.dll");
            string = "demangle.dll";
        } else if (Platform.isLinux()) {
            classPathResource = new ClassPathResource("demangle.so");
            string = "demangle.so";
        }
        if (classPathResource == null) {
            return null;
        }
        try {
            File file = new File(System.getProperty("java.io.tmpdir"));
            File file2 = new File(file, string);
            Files.copy(classPathResource.getInputStream(), file2.toPath(), StandardCopyOption.REPLACE_EXISTING);
            NativeLibrary.addSearchPath(string, file.getCanonicalPath());
            return Native.loadLibrary(string, IDemangle.class);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return null;
        }
    }
}

