/*
 * Decompiled with CFR 0.152.
 */
package com.uqm.crashsight.symtabparser;

import com.uqm.crashsight.symtabtool.common.utils.Log;
import java.io.File;
import java.io.IOException;

public class ArgsParser {
    private static final String INPUT_ARGS = "-i";
    private static final String OUT_ARGS = "-o";
    private String fileName = null;
    private String outputDirName = null;

    private ArgsParser() {
    }

    private static void printHelp() {
        System.out.println("\n\u7b26\u53f7\u8868\u6587\u4ef6\u89e3\u6790\u5de5\u5177\n-----------------------------\n");
        System.out.println("\u7528\u6cd5 -- Usage\nJava -jar SymtabParser.jar -i <input> [-o <outputDir>]\n");
        System.out.println("\u53c2\u6570\u8bf4\u660e\n<input>   \u6307\u5b9aSymbol\u6587\u4ef6\u8def\u5f84\n\n<outputDirName>  \u8f93\u51fa\u8def\u5f84\uff0c\u5fc5\u987b\u662f\u76ee\u5f55\n");
    }

    public String getFileName() {
        return this.fileName;
    }

    public String getOutputDirName() {
        return this.outputDirName;
    }

    private boolean verify() {
        if (null != this.fileName) {
            return true;
        }
        Log.error("The file to input should be specified!", new Object[0]);
        ArgsParser.printHelp();
        return false;
    }

    private boolean parseFileName(String string) {
        if (null == string) {
            Log.error("The file to input should be specified!", new Object[0]);
            return false;
        }
        File file = new File(string);
        try {
            this.fileName = file.getCanonicalPath();
            Log.info("%s", this.fileName);
            return true;
        }
        catch (IOException iOException) {
            Log.error("Failed to parse file's path name!", new Object[0]);
            return false;
        }
    }

    private boolean parseOutputDir(String string) {
        if (null == string) {
            return false;
        }
        File file = new File(string);
        if (!file.isDirectory()) {
            Log.error("The input specified is not a directory, please check!", new Object[0]);
            return false;
        }
        try {
            this.outputDirName = new File(string).getCanonicalPath();
            return true;
        }
        catch (IOException iOException) {
            Log.error("Failed to parse the zip name!", new Object[0]);
            return false;
        }
    }

    private boolean parse(String[] stringArray) {
        if (null == stringArray) {
            return false;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals(INPUT_ARGS)) {
                if (i + 1 >= stringArray.length) {
                    Log.error("The arguments are not enough!", new Object[0]);
                    break;
                }
                this.parseFileName(stringArray[i + 1]);
                continue;
            }
            if (!stringArray[i].equals(OUT_ARGS)) continue;
            if (i + 1 >= stringArray.length) {
                Log.error("The arguments are not enough!", new Object[0]);
                break;
            }
            this.parseOutputDir(stringArray[i + 1]);
        }
        return this.verify();
    }

    public static ArgsParser create(String[] stringArray) {
        ArgsParser argsParser = new ArgsParser();
        if (!argsParser.parse(stringArray)) {
            return null;
        }
        return argsParser;
    }
}

