/*
 * Decompiled with CFR 0.152.
 */
package com.tencentcloudapi.common.http;

import com.squareup.okhttp.Authenticator;
import com.squareup.okhttp.Headers;
import com.squareup.okhttp.Interceptor;
import com.squareup.okhttp.MediaType;
import com.squareup.okhttp.OkHttpClient;
import com.squareup.okhttp.Request;
import com.squareup.okhttp.RequestBody;
import com.squareup.okhttp.Response;
import com.tencentcloudapi.common.exception.TencentCloudSDKException;
import java.io.IOException;
import java.net.Proxy;
import java.util.concurrent.TimeUnit;

public class HttpConnection {
    private OkHttpClient client = new OkHttpClient();

    public HttpConnection(Integer n, Integer n2, Integer n3) {
        this.client.setConnectTimeout(n.intValue(), TimeUnit.SECONDS);
        this.client.setReadTimeout(n2.intValue(), TimeUnit.SECONDS);
        this.client.setWriteTimeout(n3.intValue(), TimeUnit.SECONDS);
    }

    public void addInterceptors(Interceptor interceptor) {
        this.client.interceptors().add(interceptor);
    }

    public void setProxy(Proxy proxy) {
        this.client.setProxy(proxy);
    }

    public void setAuthenticator(Authenticator authenticator) {
        this.client.setAuthenticator(authenticator);
    }

    public Response doRequest(Request request) throws TencentCloudSDKException {
        Response response = null;
        try {
            response = this.client.newCall(request).execute();
        }
        catch (IOException iOException) {
            throw new TencentCloudSDKException(iOException.getClass().getName() + "-" + iOException.getMessage());
        }
        return response;
    }

    public Response getRequest(String string) throws TencentCloudSDKException {
        Request request = null;
        try {
            request = new Request.Builder().url(string).get().build();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new TencentCloudSDKException(illegalArgumentException.getClass().getName() + "-" + illegalArgumentException.getMessage());
        }
        return this.doRequest(request);
    }

    public Response getRequest(String string, Headers headers) throws TencentCloudSDKException {
        Request request = null;
        try {
            request = new Request.Builder().url(string).headers(headers).get().build();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new TencentCloudSDKException(illegalArgumentException.getClass().getName() + "-" + illegalArgumentException.getMessage());
        }
        return this.doRequest(request);
    }

    public Response postRequest(String string, String string2) throws TencentCloudSDKException {
        MediaType mediaType = MediaType.parse("application/x-www-form-urlencoded");
        Request request = null;
        try {
            request = new Request.Builder().url(string).post(RequestBody.create(mediaType, string2)).build();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new TencentCloudSDKException(illegalArgumentException.getClass().getName() + "-" + illegalArgumentException.getMessage());
        }
        return this.doRequest(request);
    }

    public Response postRequest(String string, String string2, Headers headers) throws TencentCloudSDKException {
        MediaType mediaType = MediaType.parse(headers.get("Content-Type"));
        Request request = null;
        try {
            request = new Request.Builder().url(string).post(RequestBody.create(mediaType, string2)).headers(headers).build();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new TencentCloudSDKException(illegalArgumentException.getClass().getName() + "-" + illegalArgumentException.getMessage());
        }
        return this.doRequest(request);
    }

    public Response postRequest(String string, byte[] byArray, Headers headers) throws TencentCloudSDKException {
        MediaType mediaType = MediaType.parse(headers.get("Content-Type"));
        Request request = null;
        try {
            request = new Request.Builder().url(string).post(RequestBody.create(mediaType, byArray)).headers(headers).build();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new TencentCloudSDKException(illegalArgumentException.getClass().getName() + "-" + illegalArgumentException.getMessage());
        }
        return this.doRequest(request);
    }
}

