/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.okhttp.internal.tls;

import com.squareup.okhttp.internal.tls.TrustRootIndex;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.security.auth.x500.X500Principal;

public final class RealTrustRootIndex
implements TrustRootIndex {
    private final Map<X500Principal, List<X509Certificate>> subjectToCaCerts = new LinkedHashMap<X500Principal, List<X509Certificate>>();

    public RealTrustRootIndex(X509Certificate ... x509CertificateArray) {
        for (X509Certificate x509Certificate : x509CertificateArray) {
            X500Principal x500Principal = x509Certificate.getSubjectX500Principal();
            List<X509Certificate> list = this.subjectToCaCerts.get(x500Principal);
            if (list == null) {
                list = new ArrayList<X509Certificate>(1);
                this.subjectToCaCerts.put(x500Principal, list);
            }
            list.add(x509Certificate);
        }
    }

    @Override
    public X509Certificate findByIssuerAndSignature(X509Certificate x509Certificate) {
        X500Principal x500Principal = x509Certificate.getIssuerX500Principal();
        List<X509Certificate> list = this.subjectToCaCerts.get(x500Principal);
        if (list == null) {
            return null;
        }
        for (X509Certificate x509Certificate2 : list) {
            PublicKey publicKey = x509Certificate2.getPublicKey();
            try {
                x509Certificate.verify(publicKey);
                return x509Certificate2;
            }
            catch (Exception exception) {
            }
        }
        return null;
    }
}

