/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.okhttp.internal.tls;

import com.squareup.okhttp.internal.tls.TrustRootIndex;
import java.security.GeneralSecurityException;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.net.ssl.SSLPeerUnverifiedException;

public final class CertificateChainCleaner {
    private static final int MAX_SIGNERS = 9;
    private final TrustRootIndex trustRootIndex;

    public CertificateChainCleaner(TrustRootIndex trustRootIndex) {
        this.trustRootIndex = trustRootIndex;
    }

    public List<Certificate> clean(List<Certificate> list) throws SSLPeerUnverifiedException {
        ArrayDeque<Certificate> arrayDeque = new ArrayDeque<Certificate>(list);
        ArrayList<Certificate> arrayList = new ArrayList<Certificate>();
        arrayList.add((Certificate)arrayDeque.removeFirst());
        boolean bl = false;
        block0: for (int i = 0; i < 9; ++i) {
            X509Certificate x509Certificate = (X509Certificate)arrayList.get(arrayList.size() - 1);
            X509Certificate x509Certificate2 = this.trustRootIndex.findByIssuerAndSignature(x509Certificate);
            if (x509Certificate2 != null) {
                if (arrayList.size() > 1 || !x509Certificate.equals(x509Certificate2)) {
                    arrayList.add(x509Certificate2);
                }
                if (this.verifySignature(x509Certificate2, x509Certificate2)) {
                    return arrayList;
                }
                bl = true;
                continue;
            }
            Iterator iterator2 = arrayDeque.iterator();
            while (iterator2.hasNext()) {
                X509Certificate x509Certificate3 = (X509Certificate)iterator2.next();
                if (!this.verifySignature(x509Certificate, x509Certificate3)) continue;
                iterator2.remove();
                arrayList.add(x509Certificate3);
                continue block0;
            }
            if (bl) {
                return arrayList;
            }
            throw new SSLPeerUnverifiedException("Failed to find a trusted cert that signed " + x509Certificate);
        }
        throw new SSLPeerUnverifiedException("Certificate chain too long: " + arrayList);
    }

    private boolean verifySignature(X509Certificate x509Certificate, X509Certificate x509Certificate2) {
        if (!x509Certificate.getIssuerDN().equals(x509Certificate2.getSubjectDN())) {
            return false;
        }
        try {
            x509Certificate.verify(x509Certificate2.getPublicKey());
            return true;
        }
        catch (GeneralSecurityException generalSecurityException) {
            return false;
        }
    }
}

