/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.okhttp.internal.http;

import com.squareup.okhttp.Authenticator;
import com.squareup.okhttp.Challenge;
import com.squareup.okhttp.Headers;
import com.squareup.okhttp.Request;
import com.squareup.okhttp.Response;
import com.squareup.okhttp.internal.Platform;
import com.squareup.okhttp.internal.Util;
import com.squareup.okhttp.internal.http.HeaderParser;
import java.io.IOException;
import java.net.Proxy;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;

public final class OkHeaders {
    private static final Comparator<String> FIELD_NAME_COMPARATOR = new Comparator<String>(){

        @Override
        public int compare(String string, String string2) {
            if (string == string2) {
                return 0;
            }
            if (string == null) {
                return -1;
            }
            if (string2 == null) {
                return 1;
            }
            return String.CASE_INSENSITIVE_ORDER.compare(string, string2);
        }
    };
    static final String PREFIX = Platform.get().getPrefix();
    public static final String SENT_MILLIS = PREFIX + "-Sent-Millis";
    public static final String RECEIVED_MILLIS = PREFIX + "-Received-Millis";
    public static final String SELECTED_PROTOCOL = PREFIX + "-Selected-Protocol";
    public static final String RESPONSE_SOURCE = PREFIX + "-Response-Source";

    private OkHeaders() {
    }

    public static long contentLength(Request request) {
        return OkHeaders.contentLength(request.headers());
    }

    public static long contentLength(Response response) {
        return OkHeaders.contentLength(response.headers());
    }

    public static long contentLength(Headers headers) {
        return OkHeaders.stringToLong(headers.get("Content-Length"));
    }

    private static long stringToLong(String string) {
        if (string == null) {
            return -1L;
        }
        try {
            return Long.parseLong(string);
        }
        catch (NumberFormatException numberFormatException) {
            return -1L;
        }
    }

    public static Map<String, List<String>> toMultimap(Headers headers, String string) {
        TreeMap treeMap = new TreeMap(FIELD_NAME_COMPARATOR);
        int n = headers.size();
        for (int i = 0; i < n; ++i) {
            String string2 = headers.name(i);
            String string3 = headers.value(i);
            ArrayList<String> arrayList = new ArrayList<String>();
            List list = (List)treeMap.get(string2);
            if (list != null) {
                arrayList.addAll(list);
            }
            arrayList.add(string3);
            treeMap.put(string2, Collections.unmodifiableList(arrayList));
        }
        if (string != null) {
            treeMap.put(null, Collections.unmodifiableList(Collections.singletonList(string)));
        }
        return Collections.unmodifiableMap(treeMap);
    }

    public static void addCookies(Request.Builder builder, Map<String, List<String>> map) {
        for (Map.Entry<String, List<String>> entry : map.entrySet()) {
            String string = entry.getKey();
            if (!"Cookie".equalsIgnoreCase(string) && !"Cookie2".equalsIgnoreCase(string) || entry.getValue().isEmpty()) continue;
            builder.addHeader(string, OkHeaders.buildCookieHeader(entry.getValue()));
        }
    }

    private static String buildCookieHeader(List<String> list) {
        if (list.size() == 1) {
            return list.get(0);
        }
        StringBuilder stringBuilder = new StringBuilder();
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            if (i > 0) {
                stringBuilder.append("; ");
            }
            stringBuilder.append(list.get(i));
        }
        return stringBuilder.toString();
    }

    public static boolean varyMatches(Response response, Headers headers, Request request) {
        for (String string : OkHeaders.varyFields(response)) {
            if (Util.equal(headers.values(string), request.headers(string))) continue;
            return false;
        }
        return true;
    }

    public static boolean hasVaryAll(Response response) {
        return OkHeaders.hasVaryAll(response.headers());
    }

    public static boolean hasVaryAll(Headers headers) {
        return OkHeaders.varyFields(headers).contains("*");
    }

    private static Set<String> varyFields(Response response) {
        return OkHeaders.varyFields(response.headers());
    }

    public static Set<String> varyFields(Headers headers) {
        Set<String> set = Collections.emptySet();
        int n = headers.size();
        for (int i = 0; i < n; ++i) {
            if (!"Vary".equalsIgnoreCase(headers.name(i))) continue;
            String string = headers.value(i);
            if (set.isEmpty()) {
                set = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
            }
            for (String string2 : string.split(",")) {
                set.add(string2.trim());
            }
        }
        return set;
    }

    public static Headers varyHeaders(Response response) {
        Headers headers = response.networkResponse().request().headers();
        Headers headers2 = response.headers();
        return OkHeaders.varyHeaders(headers, headers2);
    }

    public static Headers varyHeaders(Headers headers, Headers headers2) {
        Set<String> set = OkHeaders.varyFields(headers2);
        if (set.isEmpty()) {
            return new Headers.Builder().build();
        }
        Headers.Builder builder = new Headers.Builder();
        int n = headers.size();
        for (int i = 0; i < n; ++i) {
            String string = headers.name(i);
            if (!set.contains(string)) continue;
            builder.add(string, headers.value(i));
        }
        return builder.build();
    }

    static boolean isEndToEnd(String string) {
        return !"Connection".equalsIgnoreCase(string) && !"Keep-Alive".equalsIgnoreCase(string) && !"Proxy-Authenticate".equalsIgnoreCase(string) && !"Proxy-Authorization".equalsIgnoreCase(string) && !"TE".equalsIgnoreCase(string) && !"Trailers".equalsIgnoreCase(string) && !"Transfer-Encoding".equalsIgnoreCase(string) && !"Upgrade".equalsIgnoreCase(string);
    }

    public static List<Challenge> parseChallenges(Headers headers, String string) {
        ArrayList<Challenge> arrayList = new ArrayList<Challenge>();
        int n = headers.size();
        block0: for (int i = 0; i < n; ++i) {
            if (!string.equalsIgnoreCase(headers.name(i))) continue;
            String string2 = headers.value(i);
            int n2 = 0;
            while (n2 < string2.length()) {
                int n3 = n2;
                n2 = HeaderParser.skipUntil(string2, n2, " ");
                String string3 = string2.substring(n3, n2).trim();
                if (!string2.regionMatches(true, n2 = HeaderParser.skipWhitespace(string2, n2), "realm=\"", 0, "realm=\"".length())) continue block0;
                int n4 = n2 += "realm=\"".length();
                n2 = HeaderParser.skipUntil(string2, n2, "\"");
                String string4 = string2.substring(n4, n2);
                ++n2;
                n2 = HeaderParser.skipUntil(string2, n2, ",");
                ++n2;
                n2 = HeaderParser.skipWhitespace(string2, n2);
                arrayList.add(new Challenge(string3, string4));
            }
        }
        return arrayList;
    }

    public static Request processAuthHeader(Authenticator authenticator, Response response, Proxy proxy) throws IOException {
        return response.code() == 407 ? authenticator.authenticateProxy(proxy, response) : authenticator.authenticate(proxy, response);
    }
}

