/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.okhttp.internal.http;

import com.squareup.okhttp.Address;
import com.squareup.okhttp.CertificatePinner;
import com.squareup.okhttp.Connection;
import com.squareup.okhttp.Headers;
import com.squareup.okhttp.HttpUrl;
import com.squareup.okhttp.Interceptor;
import com.squareup.okhttp.MediaType;
import com.squareup.okhttp.OkHttpClient;
import com.squareup.okhttp.Protocol;
import com.squareup.okhttp.Request;
import com.squareup.okhttp.Response;
import com.squareup.okhttp.ResponseBody;
import com.squareup.okhttp.Route;
import com.squareup.okhttp.internal.Internal;
import com.squareup.okhttp.internal.InternalCache;
import com.squareup.okhttp.internal.Util;
import com.squareup.okhttp.internal.Version;
import com.squareup.okhttp.internal.http.CacheRequest;
import com.squareup.okhttp.internal.http.CacheStrategy;
import com.squareup.okhttp.internal.http.HttpMethod;
import com.squareup.okhttp.internal.http.HttpStream;
import com.squareup.okhttp.internal.http.OkHeaders;
import com.squareup.okhttp.internal.http.RealResponseBody;
import com.squareup.okhttp.internal.http.RequestException;
import com.squareup.okhttp.internal.http.RetryableSink;
import com.squareup.okhttp.internal.http.RouteException;
import com.squareup.okhttp.internal.http.StreamAllocation;
import com.squareup.okhttp.internal.io.RealConnection;
import java.io.IOException;
import java.net.CookieHandler;
import java.net.ProtocolException;
import java.net.Proxy;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLSocketFactory;
import okio.Buffer;
import okio.BufferedSink;
import okio.BufferedSource;
import okio.GzipSource;
import okio.Okio;
import okio.Sink;
import okio.Source;
import okio.Timeout;

public final class HttpEngine {
    public static final int MAX_FOLLOW_UPS = 20;
    private static final ResponseBody EMPTY_BODY = new ResponseBody(){

        @Override
        public MediaType contentType() {
            return null;
        }

        @Override
        public long contentLength() {
            return 0L;
        }

        @Override
        public BufferedSource source() {
            return new Buffer();
        }
    };
    final OkHttpClient client;
    public final StreamAllocation streamAllocation;
    private final Response priorResponse;
    private HttpStream httpStream;
    long sentRequestMillis = -1L;
    private boolean transparentGzip;
    public final boolean bufferRequestBody;
    private final Request userRequest;
    private Request networkRequest;
    private Response cacheResponse;
    private Response userResponse;
    private Sink requestBodyOut;
    private BufferedSink bufferedRequestBody;
    private final boolean callerWritesRequestBody;
    private final boolean forWebSocket;
    private CacheRequest storeRequest;
    private CacheStrategy cacheStrategy;

    public HttpEngine(OkHttpClient okHttpClient, Request request, boolean bl, boolean bl2, boolean bl3, StreamAllocation streamAllocation, RetryableSink retryableSink, Response response) {
        this.client = okHttpClient;
        this.userRequest = request;
        this.bufferRequestBody = bl;
        this.callerWritesRequestBody = bl2;
        this.forWebSocket = bl3;
        this.streamAllocation = streamAllocation != null ? streamAllocation : new StreamAllocation(okHttpClient.getConnectionPool(), HttpEngine.createAddress(okHttpClient, request));
        this.requestBodyOut = retryableSink;
        this.priorResponse = response;
    }

    public void sendRequest() throws RequestException, RouteException, IOException {
        if (this.cacheStrategy != null) {
            return;
        }
        if (this.httpStream != null) {
            throw new IllegalStateException();
        }
        Request request = this.networkRequest(this.userRequest);
        InternalCache internalCache = Internal.instance.internalCache(this.client);
        Response response = internalCache != null ? internalCache.get(request) : null;
        long l = System.currentTimeMillis();
        this.cacheStrategy = new CacheStrategy.Factory(l, request, response).get();
        this.networkRequest = this.cacheStrategy.networkRequest;
        this.cacheResponse = this.cacheStrategy.cacheResponse;
        if (internalCache != null) {
            internalCache.trackResponse(this.cacheStrategy);
        }
        if (response != null && this.cacheResponse == null) {
            Util.closeQuietly(response.body());
        }
        if (this.networkRequest != null) {
            this.httpStream = this.connect();
            this.httpStream.setHttpEngine(this);
            if (this.callerWritesRequestBody && this.permitsRequestBody(this.networkRequest) && this.requestBodyOut == null) {
                long l2 = OkHeaders.contentLength(request);
                if (this.bufferRequestBody) {
                    if (l2 > Integer.MAX_VALUE) {
                        throw new IllegalStateException("Use setFixedLengthStreamingMode() or setChunkedStreamingMode() for requests larger than 2 GiB.");
                    }
                    if (l2 != -1L) {
                        this.httpStream.writeRequestHeaders(this.networkRequest);
                        this.requestBodyOut = new RetryableSink((int)l2);
                    } else {
                        this.requestBodyOut = new RetryableSink();
                    }
                } else {
                    this.httpStream.writeRequestHeaders(this.networkRequest);
                    this.requestBodyOut = this.httpStream.createRequestBody(this.networkRequest, l2);
                }
            }
        } else {
            this.userResponse = this.cacheResponse != null ? this.cacheResponse.newBuilder().request(this.userRequest).priorResponse(HttpEngine.stripBody(this.priorResponse)).cacheResponse(HttpEngine.stripBody(this.cacheResponse)).build() : new Response.Builder().request(this.userRequest).priorResponse(HttpEngine.stripBody(this.priorResponse)).protocol(Protocol.HTTP_1_1).code(504).message("Unsatisfiable Request (only-if-cached)").body(EMPTY_BODY).build();
            this.userResponse = this.unzip(this.userResponse);
        }
    }

    private HttpStream connect() throws RouteException, RequestException, IOException {
        boolean bl = !this.networkRequest.method().equals("GET");
        return this.streamAllocation.newStream(this.client.getConnectTimeout(), this.client.getReadTimeout(), this.client.getWriteTimeout(), this.client.getRetryOnConnectionFailure(), bl);
    }

    private static Response stripBody(Response response) {
        return response != null && response.body() != null ? response.newBuilder().body(null).build() : response;
    }

    public void writingRequestHeaders() {
        if (this.sentRequestMillis != -1L) {
            throw new IllegalStateException();
        }
        this.sentRequestMillis = System.currentTimeMillis();
    }

    boolean permitsRequestBody(Request request) {
        return HttpMethod.permitsRequestBody(request.method());
    }

    public Sink getRequestBody() {
        if (this.cacheStrategy == null) {
            throw new IllegalStateException();
        }
        return this.requestBodyOut;
    }

    public BufferedSink getBufferedRequestBody() {
        BufferedSink bufferedSink = this.bufferedRequestBody;
        if (bufferedSink != null) {
            return bufferedSink;
        }
        Sink sink2 = this.getRequestBody();
        return sink2 != null ? (this.bufferedRequestBody = Okio.buffer(sink2)) : null;
    }

    public boolean hasResponse() {
        return this.userResponse != null;
    }

    public Request getRequest() {
        return this.userRequest;
    }

    public Response getResponse() {
        if (this.userResponse == null) {
            throw new IllegalStateException();
        }
        return this.userResponse;
    }

    public Connection getConnection() {
        return this.streamAllocation.connection();
    }

    public HttpEngine recover(RouteException routeException) {
        if (!this.streamAllocation.recover(routeException)) {
            return null;
        }
        if (!this.client.getRetryOnConnectionFailure()) {
            return null;
        }
        StreamAllocation streamAllocation = this.close();
        return new HttpEngine(this.client, this.userRequest, this.bufferRequestBody, this.callerWritesRequestBody, this.forWebSocket, streamAllocation, (RetryableSink)this.requestBodyOut, this.priorResponse);
    }

    public HttpEngine recover(IOException iOException, Sink sink2) {
        if (!this.streamAllocation.recover(iOException, sink2)) {
            return null;
        }
        if (!this.client.getRetryOnConnectionFailure()) {
            return null;
        }
        StreamAllocation streamAllocation = this.close();
        return new HttpEngine(this.client, this.userRequest, this.bufferRequestBody, this.callerWritesRequestBody, this.forWebSocket, streamAllocation, (RetryableSink)sink2, this.priorResponse);
    }

    public HttpEngine recover(IOException iOException) {
        return this.recover(iOException, this.requestBodyOut);
    }

    private void maybeCache() throws IOException {
        InternalCache internalCache = Internal.instance.internalCache(this.client);
        if (internalCache == null) {
            return;
        }
        if (!CacheStrategy.isCacheable(this.userResponse, this.networkRequest)) {
            if (HttpMethod.invalidatesCache(this.networkRequest.method())) {
                try {
                    internalCache.remove(this.networkRequest);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            return;
        }
        this.storeRequest = internalCache.put(HttpEngine.stripBody(this.userResponse));
    }

    public void releaseStreamAllocation() throws IOException {
        this.streamAllocation.release();
    }

    public void cancel() {
        this.streamAllocation.cancel();
    }

    public StreamAllocation close() {
        if (this.bufferedRequestBody != null) {
            Util.closeQuietly(this.bufferedRequestBody);
        } else if (this.requestBodyOut != null) {
            Util.closeQuietly(this.requestBodyOut);
        }
        if (this.userResponse != null) {
            Util.closeQuietly(this.userResponse.body());
        } else {
            this.streamAllocation.connectionFailed();
        }
        return this.streamAllocation;
    }

    private Response unzip(Response response) throws IOException {
        if (!this.transparentGzip || !"gzip".equalsIgnoreCase(this.userResponse.header("Content-Encoding"))) {
            return response;
        }
        if (response.body() == null) {
            return response;
        }
        GzipSource gzipSource = new GzipSource(response.body().source());
        Headers headers = response.headers().newBuilder().removeAll("Content-Encoding").removeAll("Content-Length").build();
        return response.newBuilder().headers(headers).body(new RealResponseBody(headers, Okio.buffer(gzipSource))).build();
    }

    public static boolean hasBody(Response response) {
        if (response.request().method().equals("HEAD")) {
            return false;
        }
        int n = response.code();
        if ((n < 100 || n >= 200) && n != 204 && n != 304) {
            return true;
        }
        return OkHeaders.contentLength(response) != -1L || "chunked".equalsIgnoreCase(response.header("Transfer-Encoding"));
    }

    private Request networkRequest(Request request) throws IOException {
        CookieHandler cookieHandler;
        Request.Builder builder = request.newBuilder();
        if (request.header("Host") == null) {
            builder.header("Host", Util.hostHeader(request.httpUrl()));
        }
        if (request.header("Connection") == null) {
            builder.header("Connection", "Keep-Alive");
        }
        if (request.header("Accept-Encoding") == null) {
            this.transparentGzip = true;
            builder.header("Accept-Encoding", "gzip");
        }
        if ((cookieHandler = this.client.getCookieHandler()) != null) {
            Map<String, List<String>> map = OkHeaders.toMultimap(builder.build().headers(), null);
            Map<String, List<String>> map2 = cookieHandler.get(request.uri(), map);
            OkHeaders.addCookies(builder, map2);
        }
        if (request.header("User-Agent") == null) {
            builder.header("User-Agent", Version.userAgent());
        }
        return builder.build();
    }

    public void readResponse() throws IOException {
        Response response;
        if (this.userResponse != null) {
            return;
        }
        if (this.networkRequest == null && this.cacheResponse == null) {
            throw new IllegalStateException("call sendRequest() first!");
        }
        if (this.networkRequest == null) {
            return;
        }
        if (this.forWebSocket) {
            this.httpStream.writeRequestHeaders(this.networkRequest);
            response = this.readNetworkResponse();
        } else if (!this.callerWritesRequestBody) {
            response = new NetworkInterceptorChain(0, this.networkRequest).proceed(this.networkRequest);
        } else {
            if (this.bufferedRequestBody != null && this.bufferedRequestBody.buffer().size() > 0L) {
                this.bufferedRequestBody.emit();
            }
            if (this.sentRequestMillis == -1L) {
                if (OkHeaders.contentLength(this.networkRequest) == -1L && this.requestBodyOut instanceof RetryableSink) {
                    long l = ((RetryableSink)this.requestBodyOut).contentLength();
                    this.networkRequest = this.networkRequest.newBuilder().header("Content-Length", Long.toString(l)).build();
                }
                this.httpStream.writeRequestHeaders(this.networkRequest);
            }
            if (this.requestBodyOut != null) {
                if (this.bufferedRequestBody != null) {
                    this.bufferedRequestBody.close();
                } else {
                    this.requestBodyOut.close();
                }
                if (this.requestBodyOut instanceof RetryableSink) {
                    this.httpStream.writeRequestBody((RetryableSink)this.requestBodyOut);
                }
            }
            response = this.readNetworkResponse();
        }
        this.receiveHeaders(response.headers());
        if (this.cacheResponse != null) {
            if (HttpEngine.validate(this.cacheResponse, response)) {
                this.userResponse = this.cacheResponse.newBuilder().request(this.userRequest).priorResponse(HttpEngine.stripBody(this.priorResponse)).headers(HttpEngine.combine(this.cacheResponse.headers(), response.headers())).cacheResponse(HttpEngine.stripBody(this.cacheResponse)).networkResponse(HttpEngine.stripBody(response)).build();
                response.body().close();
                this.releaseStreamAllocation();
                InternalCache internalCache = Internal.instance.internalCache(this.client);
                internalCache.trackConditionalCacheHit();
                internalCache.update(this.cacheResponse, HttpEngine.stripBody(this.userResponse));
                this.userResponse = this.unzip(this.userResponse);
                return;
            }
            Util.closeQuietly(this.cacheResponse.body());
        }
        this.userResponse = response.newBuilder().request(this.userRequest).priorResponse(HttpEngine.stripBody(this.priorResponse)).cacheResponse(HttpEngine.stripBody(this.cacheResponse)).networkResponse(HttpEngine.stripBody(response)).build();
        if (HttpEngine.hasBody(this.userResponse)) {
            this.maybeCache();
            this.userResponse = this.unzip(this.cacheWritingResponse(this.storeRequest, this.userResponse));
        }
    }

    private Response readNetworkResponse() throws IOException {
        this.httpStream.finishRequest();
        Response response = this.httpStream.readResponseHeaders().request(this.networkRequest).handshake(this.streamAllocation.connection().getHandshake()).header(OkHeaders.SENT_MILLIS, Long.toString(this.sentRequestMillis)).header(OkHeaders.RECEIVED_MILLIS, Long.toString(System.currentTimeMillis())).build();
        if (!this.forWebSocket) {
            response = response.newBuilder().body(this.httpStream.openResponseBody(response)).build();
        }
        if ("close".equalsIgnoreCase(response.request().header("Connection")) || "close".equalsIgnoreCase(response.header("Connection"))) {
            this.streamAllocation.noNewStreams();
        }
        return response;
    }

    private Response cacheWritingResponse(final CacheRequest cacheRequest, Response response) throws IOException {
        if (cacheRequest == null) {
            return response;
        }
        Sink sink2 = cacheRequest.body();
        if (sink2 == null) {
            return response;
        }
        final BufferedSource bufferedSource = response.body().source();
        final BufferedSink bufferedSink = Okio.buffer(sink2);
        Source source2 = new Source(){
            boolean cacheRequestClosed;

            @Override
            public long read(Buffer buffer, long l) throws IOException {
                long l2;
                try {
                    l2 = bufferedSource.read(buffer, l);
                }
                catch (IOException iOException) {
                    if (!this.cacheRequestClosed) {
                        this.cacheRequestClosed = true;
                        cacheRequest.abort();
                    }
                    throw iOException;
                }
                if (l2 == -1L) {
                    if (!this.cacheRequestClosed) {
                        this.cacheRequestClosed = true;
                        bufferedSink.close();
                    }
                    return -1L;
                }
                buffer.copyTo(bufferedSink.buffer(), buffer.size() - l2, l2);
                bufferedSink.emitCompleteSegments();
                return l2;
            }

            @Override
            public Timeout timeout() {
                return bufferedSource.timeout();
            }

            @Override
            public void close() throws IOException {
                if (!this.cacheRequestClosed && !Util.discard(this, 100, TimeUnit.MILLISECONDS)) {
                    this.cacheRequestClosed = true;
                    cacheRequest.abort();
                }
                bufferedSource.close();
            }
        };
        return response.newBuilder().body(new RealResponseBody(response.headers(), Okio.buffer(source2))).build();
    }

    private static boolean validate(Response response, Response response2) {
        Date date;
        if (response2.code() == 304) {
            return true;
        }
        Date date2 = response.headers().getDate("Last-Modified");
        return date2 != null && (date = response2.headers().getDate("Last-Modified")) != null && date.getTime() < date2.getTime();
    }

    private static Headers combine(Headers headers, Headers headers2) throws IOException {
        String string;
        int n;
        Headers.Builder builder = new Headers.Builder();
        int n2 = headers.size();
        for (n = 0; n < n2; ++n) {
            string = headers.name(n);
            String string2 = headers.value(n);
            if ("Warning".equalsIgnoreCase(string) && string2.startsWith("1") || OkHeaders.isEndToEnd(string) && headers2.get(string) != null) continue;
            builder.add(string, string2);
        }
        n2 = headers2.size();
        for (n = 0; n < n2; ++n) {
            string = headers2.name(n);
            if ("Content-Length".equalsIgnoreCase(string) || !OkHeaders.isEndToEnd(string)) continue;
            builder.add(string, headers2.value(n));
        }
        return builder.build();
    }

    public void receiveHeaders(Headers headers) throws IOException {
        CookieHandler cookieHandler = this.client.getCookieHandler();
        if (cookieHandler != null) {
            cookieHandler.put(this.userRequest.uri(), OkHeaders.toMultimap(headers, null));
        }
    }

    public Request followUpRequest() throws IOException {
        if (this.userResponse == null) {
            throw new IllegalStateException();
        }
        RealConnection realConnection = this.streamAllocation.connection();
        Route route = realConnection != null ? realConnection.getRoute() : null;
        Proxy proxy = route != null ? route.getProxy() : this.client.getProxy();
        int n = this.userResponse.code();
        String string = this.userRequest.method();
        switch (n) {
            case 407: {
                if (proxy.type() != Proxy.Type.HTTP) {
                    throw new ProtocolException("Received HTTP_PROXY_AUTH (407) code while not using proxy");
                }
            }
            case 401: {
                return OkHeaders.processAuthHeader(this.client.getAuthenticator(), this.userResponse, proxy);
            }
            case 307: 
            case 308: {
                if (!string.equals("GET") && !string.equals("HEAD")) {
                    return null;
                }
            }
            case 300: 
            case 301: 
            case 302: 
            case 303: {
                if (!this.client.getFollowRedirects()) {
                    return null;
                }
                String string2 = this.userResponse.header("Location");
                if (string2 == null) {
                    return null;
                }
                HttpUrl httpUrl = this.userRequest.httpUrl().resolve(string2);
                if (httpUrl == null) {
                    return null;
                }
                boolean bl = httpUrl.scheme().equals(this.userRequest.httpUrl().scheme());
                if (!bl && !this.client.getFollowSslRedirects()) {
                    return null;
                }
                Request.Builder builder = this.userRequest.newBuilder();
                if (HttpMethod.permitsRequestBody(string)) {
                    if (HttpMethod.redirectsToGet(string)) {
                        builder.method("GET", null);
                    } else {
                        builder.method(string, null);
                    }
                    builder.removeHeader("Transfer-Encoding");
                    builder.removeHeader("Content-Length");
                    builder.removeHeader("Content-Type");
                }
                if (!this.sameConnection(httpUrl)) {
                    builder.removeHeader("Authorization");
                }
                return builder.url(httpUrl).build();
            }
        }
        return null;
    }

    public boolean sameConnection(HttpUrl httpUrl) {
        HttpUrl httpUrl2 = this.userRequest.httpUrl();
        return httpUrl2.host().equals(httpUrl.host()) && httpUrl2.port() == httpUrl.port() && httpUrl2.scheme().equals(httpUrl.scheme());
    }

    private static Address createAddress(OkHttpClient okHttpClient, Request request) {
        SSLSocketFactory sSLSocketFactory = null;
        HostnameVerifier hostnameVerifier = null;
        CertificatePinner certificatePinner = null;
        if (request.isHttps()) {
            sSLSocketFactory = okHttpClient.getSslSocketFactory();
            hostnameVerifier = okHttpClient.getHostnameVerifier();
            certificatePinner = okHttpClient.getCertificatePinner();
        }
        return new Address(request.httpUrl().host(), request.httpUrl().port(), okHttpClient.getDns(), okHttpClient.getSocketFactory(), sSLSocketFactory, hostnameVerifier, certificatePinner, okHttpClient.getAuthenticator(), okHttpClient.getProxy(), okHttpClient.getProtocols(), okHttpClient.getConnectionSpecs(), okHttpClient.getProxySelector());
    }

    class NetworkInterceptorChain
    implements Interceptor.Chain {
        private final int index;
        private final Request request;
        private int calls;

        NetworkInterceptorChain(int n, Request request) {
            this.index = n;
            this.request = request;
        }

        @Override
        public Connection connection() {
            return HttpEngine.this.streamAllocation.connection();
        }

        @Override
        public Request request() {
            return this.request;
        }

        @Override
        public Response proceed(Request request) throws IOException {
            int n;
            Object object;
            Object object2;
            ++this.calls;
            if (this.index > 0) {
                object2 = HttpEngine.this.client.networkInterceptors().get(this.index - 1);
                object = this.connection().getRoute().getAddress();
                if (!request.httpUrl().host().equals(((Address)object).getUriHost()) || request.httpUrl().port() != ((Address)object).getUriPort()) {
                    throw new IllegalStateException("network interceptor " + object2 + " must retain the same host and port");
                }
                if (this.calls > 1) {
                    throw new IllegalStateException("network interceptor " + object2 + " must call proceed() exactly once");
                }
            }
            if (this.index < HttpEngine.this.client.networkInterceptors().size()) {
                object2 = new NetworkInterceptorChain(this.index + 1, request);
                object = HttpEngine.this.client.networkInterceptors().get(this.index);
                Response response = object.intercept((Interceptor.Chain)object2);
                if (((NetworkInterceptorChain)object2).calls != 1) {
                    throw new IllegalStateException("network interceptor " + object + " must call proceed() exactly once");
                }
                if (response == null) {
                    throw new NullPointerException("network interceptor " + object + " returned null");
                }
                return response;
            }
            HttpEngine.this.httpStream.writeRequestHeaders(request);
            HttpEngine.this.networkRequest = request;
            if (HttpEngine.this.permitsRequestBody(request) && request.body() != null) {
                object2 = HttpEngine.this.httpStream.createRequestBody(request, request.body().contentLength());
                object = Okio.buffer((Sink)object2);
                request.body().writeTo((BufferedSink)object);
                object.close();
            }
            if (((n = ((Response)(object2 = HttpEngine.this.readNetworkResponse())).code()) == 204 || n == 205) && ((Response)object2).body().contentLength() > 0L) {
                throw new ProtocolException("HTTP " + n + " had non-zero Content-Length: " + ((Response)object2).body().contentLength());
            }
            return object2;
        }
    }
}

