/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.okhttp.internal.framed;

import java.util.Arrays;

public final class Settings {
    static final int DEFAULT_INITIAL_WINDOW_SIZE = 65536;
    static final int FLAG_CLEAR_PREVIOUSLY_PERSISTED_SETTINGS = 1;
    static final int PERSIST_VALUE = 1;
    static final int PERSISTED = 2;
    static final int UPLOAD_BANDWIDTH = 1;
    static final int HEADER_TABLE_SIZE = 1;
    static final int DOWNLOAD_BANDWIDTH = 2;
    static final int ENABLE_PUSH = 2;
    static final int ROUND_TRIP_TIME = 3;
    static final int MAX_CONCURRENT_STREAMS = 4;
    static final int CURRENT_CWND = 5;
    static final int MAX_FRAME_SIZE = 5;
    static final int DOWNLOAD_RETRANS_RATE = 6;
    static final int MAX_HEADER_LIST_SIZE = 6;
    static final int INITIAL_WINDOW_SIZE = 7;
    static final int CLIENT_CERTIFICATE_VECTOR_SIZE = 8;
    static final int FLOW_CONTROL_OPTIONS = 10;
    static final int COUNT = 10;
    static final int FLOW_CONTROL_OPTIONS_DISABLED = 1;
    private int set;
    private int persistValue;
    private int persisted;
    private final int[] values = new int[10];

    void clear() {
        this.persisted = 0;
        this.persistValue = 0;
        this.set = 0;
        Arrays.fill(this.values, 0);
    }

    Settings set(int n, int n2, int n3) {
        if (n >= this.values.length) {
            return this;
        }
        int n4 = 1 << n;
        this.set |= n4;
        this.persistValue = (n2 & 1) != 0 ? (this.persistValue |= n4) : (this.persistValue &= ~n4);
        this.persisted = (n2 & 2) != 0 ? (this.persisted |= n4) : (this.persisted &= ~n4);
        this.values[n] = n3;
        return this;
    }

    boolean isSet(int n) {
        int n2 = 1 << n;
        return (this.set & n2) != 0;
    }

    int get(int n) {
        return this.values[n];
    }

    int flags(int n) {
        int n2 = 0;
        if (this.isPersisted(n)) {
            n2 |= 2;
        }
        if (this.persistValue(n)) {
            n2 |= 1;
        }
        return n2;
    }

    int size() {
        return Integer.bitCount(this.set);
    }

    int getUploadBandwidth(int n) {
        int n2 = 2;
        return (n2 & this.set) != 0 ? this.values[1] : n;
    }

    int getHeaderTableSize() {
        int n = 2;
        return (n & this.set) != 0 ? this.values[1] : -1;
    }

    int getDownloadBandwidth(int n) {
        int n2 = 4;
        return (n2 & this.set) != 0 ? this.values[2] : n;
    }

    boolean getEnablePush(boolean bl) {
        int n = 4;
        return ((n & this.set) != 0 ? this.values[2] : (bl ? 1 : 0)) == 1;
    }

    int getRoundTripTime(int n) {
        int n2 = 8;
        return (n2 & this.set) != 0 ? this.values[3] : n;
    }

    int getMaxConcurrentStreams(int n) {
        int n2 = 16;
        return (n2 & this.set) != 0 ? this.values[4] : n;
    }

    int getCurrentCwnd(int n) {
        int n2 = 32;
        return (n2 & this.set) != 0 ? this.values[5] : n;
    }

    int getMaxFrameSize(int n) {
        int n2 = 32;
        return (n2 & this.set) != 0 ? this.values[5] : n;
    }

    int getDownloadRetransRate(int n) {
        int n2 = 64;
        return (n2 & this.set) != 0 ? this.values[6] : n;
    }

    int getMaxHeaderListSize(int n) {
        int n2 = 64;
        return (n2 & this.set) != 0 ? this.values[6] : n;
    }

    int getInitialWindowSize(int n) {
        int n2 = 128;
        return (n2 & this.set) != 0 ? this.values[7] : n;
    }

    int getClientCertificateVectorSize(int n) {
        int n2 = 256;
        return (n2 & this.set) != 0 ? this.values[8] : n;
    }

    boolean isFlowControlDisabled() {
        int n = 1024;
        int n2 = (n & this.set) != 0 ? this.values[10] : 0;
        return (n2 & 1) != 0;
    }

    boolean persistValue(int n) {
        int n2 = 1 << n;
        return (this.persistValue & n2) != 0;
    }

    boolean isPersisted(int n) {
        int n2 = 1 << n;
        return (this.persisted & n2) != 0;
    }

    void merge(Settings settings) {
        for (int i = 0; i < 10; ++i) {
            if (!settings.isSet(i)) continue;
            this.set(i, settings.flags(i), settings.get(i));
        }
    }
}

