/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.okhttp.internal.framed;

import com.squareup.okhttp.internal.framed.Header;
import com.squareup.okhttp.internal.framed.Spdy3;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;
import okio.Buffer;
import okio.BufferedSource;
import okio.ByteString;
import okio.ForwardingSource;
import okio.InflaterSource;
import okio.Okio;

class NameValueBlockReader {
    private final InflaterSource inflaterSource;
    private int compressedLimit;
    private final BufferedSource source;

    public NameValueBlockReader(BufferedSource bufferedSource) {
        ForwardingSource forwardingSource = new ForwardingSource(bufferedSource){

            @Override
            public long read(Buffer buffer, long l) throws IOException {
                if (NameValueBlockReader.this.compressedLimit == 0) {
                    return -1L;
                }
                long l2 = super.read(buffer, Math.min(l, (long)NameValueBlockReader.this.compressedLimit));
                if (l2 == -1L) {
                    return -1L;
                }
                NameValueBlockReader.this.compressedLimit = (int)((long)NameValueBlockReader.this.compressedLimit - l2);
                return l2;
            }
        };
        Inflater inflater = new Inflater(){

            @Override
            public int inflate(byte[] byArray, int n, int n2) throws DataFormatException {
                int n3 = super.inflate(byArray, n, n2);
                if (n3 == 0 && this.needsDictionary()) {
                    this.setDictionary(Spdy3.DICTIONARY);
                    n3 = super.inflate(byArray, n, n2);
                }
                return n3;
            }
        };
        this.inflaterSource = new InflaterSource(forwardingSource, inflater);
        this.source = Okio.buffer(this.inflaterSource);
    }

    public List<Header> readNameValueBlock(int n) throws IOException {
        this.compressedLimit += n;
        int n2 = this.source.readInt();
        if (n2 < 0) {
            throw new IOException("numberOfPairs < 0: " + n2);
        }
        if (n2 > 1024) {
            throw new IOException("numberOfPairs > 1024: " + n2);
        }
        ArrayList<Header> arrayList = new ArrayList<Header>(n2);
        for (int i = 0; i < n2; ++i) {
            ByteString byteString = this.readByteString().toAsciiLowercase();
            ByteString byteString2 = this.readByteString();
            if (byteString.size() == 0) {
                throw new IOException("name.size == 0");
            }
            arrayList.add(new Header(byteString, byteString2));
        }
        this.doneReading();
        return arrayList;
    }

    private ByteString readByteString() throws IOException {
        int n = this.source.readInt();
        return this.source.readByteString(n);
    }

    private void doneReading() throws IOException {
        if (this.compressedLimit > 0) {
            this.inflaterSource.refill();
            if (this.compressedLimit != 0) {
                throw new IOException("compressedLimit > 0: " + this.compressedLimit);
            }
        }
    }

    public void close() throws IOException {
        this.source.close();
    }
}

