/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.okhttp.internal.framed;

import com.squareup.okhttp.internal.framed.ErrorCode;
import com.squareup.okhttp.internal.framed.FramedConnection;
import com.squareup.okhttp.internal.framed.Header;
import com.squareup.okhttp.internal.framed.HeadersMode;
import java.io.EOFException;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.SocketTimeoutException;
import java.util.ArrayList;
import java.util.List;
import okio.AsyncTimeout;
import okio.Buffer;
import okio.BufferedSource;
import okio.Sink;
import okio.Source;
import okio.Timeout;

public final class FramedStream {
    long unacknowledgedBytesRead = 0L;
    long bytesLeftInWriteWindow;
    private final int id;
    private final FramedConnection connection;
    private final List<Header> requestHeaders;
    private List<Header> responseHeaders;
    private final FramedDataSource source;
    final FramedDataSink sink;
    private final StreamTimeout readTimeout = new StreamTimeout();
    private final StreamTimeout writeTimeout = new StreamTimeout();
    private ErrorCode errorCode = null;

    FramedStream(int n, FramedConnection framedConnection, boolean bl, boolean bl2, List<Header> list) {
        if (framedConnection == null) {
            throw new NullPointerException("connection == null");
        }
        if (list == null) {
            throw new NullPointerException("requestHeaders == null");
        }
        this.id = n;
        this.connection = framedConnection;
        this.bytesLeftInWriteWindow = framedConnection.peerSettings.getInitialWindowSize(65536);
        this.source = new FramedDataSource(framedConnection.okHttpSettings.getInitialWindowSize(65536));
        this.sink = new FramedDataSink();
        this.source.finished = bl2;
        this.sink.finished = bl;
        this.requestHeaders = list;
    }

    public int getId() {
        return this.id;
    }

    public synchronized boolean isOpen() {
        if (this.errorCode != null) {
            return false;
        }
        return !this.source.finished && !this.source.closed || !this.sink.finished && !this.sink.closed || this.responseHeaders == null;
    }

    public boolean isLocallyInitiated() {
        boolean bl = (this.id & 1) == 1;
        return this.connection.client == bl;
    }

    public FramedConnection getConnection() {
        return this.connection;
    }

    public List<Header> getRequestHeaders() {
        return this.requestHeaders;
    }

    public synchronized List<Header> getResponseHeaders() throws IOException {
        this.readTimeout.enter();
        try {
            while (this.responseHeaders == null && this.errorCode == null) {
                this.waitForIo();
            }
        }
        finally {
            this.readTimeout.exitAndThrowIfTimedOut();
        }
        if (this.responseHeaders != null) {
            return this.responseHeaders;
        }
        throw new IOException("stream was reset: " + (Object)((Object)this.errorCode));
    }

    public synchronized ErrorCode getErrorCode() {
        return this.errorCode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reply(List<Header> list, boolean bl) throws IOException {
        assert (!Thread.holdsLock(this));
        boolean bl2 = false;
        FramedStream framedStream = this;
        synchronized (framedStream) {
            if (list == null) {
                throw new NullPointerException("responseHeaders == null");
            }
            if (this.responseHeaders != null) {
                throw new IllegalStateException("reply already sent");
            }
            this.responseHeaders = list;
            if (!bl) {
                this.sink.finished = true;
                bl2 = true;
            }
        }
        this.connection.writeSynReply(this.id, bl2, list);
        if (bl2) {
            this.connection.flush();
        }
    }

    public Timeout readTimeout() {
        return this.readTimeout;
    }

    public Timeout writeTimeout() {
        return this.writeTimeout;
    }

    public Source getSource() {
        return this.source;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Sink getSink() {
        FramedStream framedStream = this;
        synchronized (framedStream) {
            if (this.responseHeaders == null && !this.isLocallyInitiated()) {
                throw new IllegalStateException("reply before requesting the sink");
            }
        }
        return this.sink;
    }

    public void close(ErrorCode errorCode) throws IOException {
        if (!this.closeInternal(errorCode)) {
            return;
        }
        this.connection.writeSynReset(this.id, errorCode);
    }

    public void closeLater(ErrorCode errorCode) {
        if (!this.closeInternal(errorCode)) {
            return;
        }
        this.connection.writeSynResetLater(this.id, errorCode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean closeInternal(ErrorCode errorCode) {
        assert (!Thread.holdsLock(this));
        FramedStream framedStream = this;
        synchronized (framedStream) {
            if (this.errorCode != null) {
                return false;
            }
            if (this.source.finished && this.sink.finished) {
                return false;
            }
            this.errorCode = errorCode;
            this.notifyAll();
        }
        this.connection.removeStream(this.id);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void receiveHeaders(List<Header> list, HeadersMode headersMode) {
        assert (!Thread.holdsLock(this));
        ErrorCode errorCode = null;
        boolean bl = true;
        FramedStream framedStream = this;
        synchronized (framedStream) {
            if (this.responseHeaders == null) {
                if (headersMode.failIfHeadersAbsent()) {
                    errorCode = ErrorCode.PROTOCOL_ERROR;
                } else {
                    this.responseHeaders = list;
                    bl = this.isOpen();
                    this.notifyAll();
                }
            } else if (headersMode.failIfHeadersPresent()) {
                errorCode = ErrorCode.STREAM_IN_USE;
            } else {
                ArrayList<Header> arrayList = new ArrayList<Header>();
                arrayList.addAll(this.responseHeaders);
                arrayList.addAll(list);
                this.responseHeaders = arrayList;
            }
        }
        if (errorCode != null) {
            this.closeLater(errorCode);
        } else if (!bl) {
            this.connection.removeStream(this.id);
        }
    }

    void receiveData(BufferedSource bufferedSource, int n) throws IOException {
        assert (!Thread.holdsLock(this));
        this.source.receive(bufferedSource, n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void receiveFin() {
        boolean bl;
        assert (!Thread.holdsLock(this));
        FramedStream framedStream = this;
        synchronized (framedStream) {
            this.source.finished = true;
            bl = this.isOpen();
            this.notifyAll();
        }
        if (!bl) {
            this.connection.removeStream(this.id);
        }
    }

    synchronized void receiveRstStream(ErrorCode errorCode) {
        if (this.errorCode == null) {
            this.errorCode = errorCode;
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cancelStreamIfNecessary() throws IOException {
        boolean bl;
        boolean bl2;
        assert (!Thread.holdsLock(this));
        FramedStream framedStream = this;
        synchronized (framedStream) {
            bl2 = !this.source.finished && this.source.closed && (this.sink.finished || this.sink.closed);
            bl = this.isOpen();
        }
        if (bl2) {
            this.close(ErrorCode.CANCEL);
        } else if (!bl) {
            this.connection.removeStream(this.id);
        }
    }

    void addBytesToWriteWindow(long l) {
        this.bytesLeftInWriteWindow += l;
        if (l > 0L) {
            this.notifyAll();
        }
    }

    private void checkOutNotClosed() throws IOException {
        if (this.sink.closed) {
            throw new IOException("stream closed");
        }
        if (this.sink.finished) {
            throw new IOException("stream finished");
        }
        if (this.errorCode != null) {
            throw new IOException("stream was reset: " + (Object)((Object)this.errorCode));
        }
    }

    private void waitForIo() throws InterruptedIOException {
        try {
            this.wait();
        }
        catch (InterruptedException interruptedException) {
            throw new InterruptedIOException();
        }
    }

    class StreamTimeout
    extends AsyncTimeout {
        StreamTimeout() {
        }

        @Override
        protected void timedOut() {
            FramedStream.this.closeLater(ErrorCode.CANCEL);
        }

        @Override
        protected IOException newTimeoutException(IOException iOException) {
            SocketTimeoutException socketTimeoutException = new SocketTimeoutException("timeout");
            if (iOException != null) {
                socketTimeoutException.initCause(iOException);
            }
            return socketTimeoutException;
        }

        public void exitAndThrowIfTimedOut() throws IOException {
            if (this.exit()) {
                throw this.newTimeoutException(null);
            }
        }
    }

    final class FramedDataSink
    implements Sink {
        private static final long EMIT_BUFFER_SIZE = 16384L;
        private final Buffer sendBuffer = new Buffer();
        private boolean closed;
        private boolean finished;

        FramedDataSink() {
        }

        @Override
        public void write(Buffer buffer, long l) throws IOException {
            assert (!Thread.holdsLock(FramedStream.this));
            this.sendBuffer.write(buffer, l);
            while (this.sendBuffer.size() >= 16384L) {
                this.emitDataFrame(false);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void emitDataFrame(boolean bl) throws IOException {
            long l;
            FramedStream framedStream = FramedStream.this;
            synchronized (framedStream) {
                FramedStream.this.writeTimeout.enter();
                try {
                    while (FramedStream.this.bytesLeftInWriteWindow <= 0L && !this.finished && !this.closed && FramedStream.this.errorCode == null) {
                        FramedStream.this.waitForIo();
                    }
                }
                finally {
                    FramedStream.this.writeTimeout.exitAndThrowIfTimedOut();
                }
                FramedStream.this.checkOutNotClosed();
                l = Math.min(FramedStream.this.bytesLeftInWriteWindow, this.sendBuffer.size());
                FramedStream.this.bytesLeftInWriteWindow -= l;
            }
            FramedStream.this.writeTimeout.enter();
            try {
                FramedStream.this.connection.writeData(FramedStream.this.id, bl && l == this.sendBuffer.size(), this.sendBuffer, l);
            }
            finally {
                FramedStream.this.writeTimeout.exitAndThrowIfTimedOut();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void flush() throws IOException {
            assert (!Thread.holdsLock(FramedStream.this));
            FramedStream framedStream = FramedStream.this;
            synchronized (framedStream) {
                FramedStream.this.checkOutNotClosed();
            }
            while (this.sendBuffer.size() > 0L) {
                this.emitDataFrame(false);
                FramedStream.this.connection.flush();
            }
        }

        @Override
        public Timeout timeout() {
            return FramedStream.this.writeTimeout;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() throws IOException {
            assert (!Thread.holdsLock(FramedStream.this));
            FramedStream framedStream = FramedStream.this;
            synchronized (framedStream) {
                if (this.closed) {
                    return;
                }
            }
            if (!FramedStream.this.sink.finished) {
                if (this.sendBuffer.size() > 0L) {
                    while (this.sendBuffer.size() > 0L) {
                        this.emitDataFrame(true);
                    }
                } else {
                    FramedStream.this.connection.writeData(FramedStream.this.id, true, null, 0L);
                }
            }
            framedStream = FramedStream.this;
            synchronized (framedStream) {
                this.closed = true;
            }
            FramedStream.this.connection.flush();
            FramedStream.this.cancelStreamIfNecessary();
        }
    }

    private final class FramedDataSource
    implements Source {
        private final Buffer receiveBuffer = new Buffer();
        private final Buffer readBuffer = new Buffer();
        private final long maxByteCount;
        private boolean closed;
        private boolean finished;

        private FramedDataSource(long l) {
            this.maxByteCount = l;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public long read(Buffer buffer, long l) throws IOException {
            long l2;
            if (l < 0L) {
                throw new IllegalArgumentException("byteCount < 0: " + l);
            }
            Object object = FramedStream.this;
            synchronized (object) {
                this.waitUntilReadable();
                this.checkNotClosed();
                if (this.readBuffer.size() == 0L) {
                    return -1L;
                }
                l2 = this.readBuffer.read(buffer, Math.min(l, this.readBuffer.size()));
                FramedStream.this.unacknowledgedBytesRead += l2;
                if (FramedStream.this.unacknowledgedBytesRead >= (long)(((FramedStream)FramedStream.this).connection.okHttpSettings.getInitialWindowSize(65536) / 2)) {
                    FramedStream.this.connection.writeWindowUpdateLater(FramedStream.this.id, FramedStream.this.unacknowledgedBytesRead);
                    FramedStream.this.unacknowledgedBytesRead = 0L;
                }
            }
            object = FramedStream.this.connection;
            synchronized (object) {
                ((FramedStream)FramedStream.this).connection.unacknowledgedBytesRead += l2;
                if (((FramedStream)FramedStream.this).connection.unacknowledgedBytesRead >= (long)(((FramedStream)FramedStream.this).connection.okHttpSettings.getInitialWindowSize(65536) / 2)) {
                    FramedStream.this.connection.writeWindowUpdateLater(0, ((FramedStream)FramedStream.this).connection.unacknowledgedBytesRead);
                    ((FramedStream)FramedStream.this).connection.unacknowledgedBytesRead = 0L;
                }
            }
            return l2;
        }

        private void waitUntilReadable() throws IOException {
            FramedStream.this.readTimeout.enter();
            try {
                while (this.readBuffer.size() == 0L && !this.finished && !this.closed && FramedStream.this.errorCode == null) {
                    FramedStream.this.waitForIo();
                }
            }
            finally {
                FramedStream.this.readTimeout.exitAndThrowIfTimedOut();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void receive(BufferedSource bufferedSource, long l) throws IOException {
            assert (!Thread.holdsLock(FramedStream.this));
            while (l > 0L) {
                boolean bl;
                boolean bl2;
                FramedStream framedStream = FramedStream.this;
                synchronized (framedStream) {
                    bl2 = this.finished;
                    bl = l + this.readBuffer.size() > this.maxByteCount;
                }
                if (bl) {
                    bufferedSource.skip(l);
                    FramedStream.this.closeLater(ErrorCode.FLOW_CONTROL_ERROR);
                    return;
                }
                if (bl2) {
                    bufferedSource.skip(l);
                    return;
                }
                long l2 = bufferedSource.read(this.receiveBuffer, l);
                if (l2 == -1L) {
                    throw new EOFException();
                }
                l -= l2;
                FramedStream framedStream2 = FramedStream.this;
                synchronized (framedStream2) {
                    boolean bl3 = this.readBuffer.size() == 0L;
                    this.readBuffer.writeAll(this.receiveBuffer);
                    if (bl3) {
                        FramedStream.this.notifyAll();
                    }
                }
            }
        }

        @Override
        public Timeout timeout() {
            return FramedStream.this.readTimeout;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() throws IOException {
            FramedStream framedStream = FramedStream.this;
            synchronized (framedStream) {
                this.closed = true;
                this.readBuffer.clear();
                FramedStream.this.notifyAll();
            }
            FramedStream.this.cancelStreamIfNecessary();
        }

        private void checkNotClosed() throws IOException {
            if (this.closed) {
                throw new IOException("stream closed");
            }
            if (FramedStream.this.errorCode != null) {
                throw new IOException("stream was reset: " + (Object)((Object)FramedStream.this.errorCode));
            }
        }
    }
}

