/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.okhttp;

import java.nio.charset.Charset;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class MediaType {
    private static final String TOKEN = "([a-zA-Z0-9-!#$%&'*+.^_`{|}~]+)";
    private static final String QUOTED = "\"([^\"]*)\"";
    private static final Pattern TYPE_SUBTYPE = Pattern.compile("([a-zA-Z0-9-!#$%&'*+.^_`{|}~]+)/([a-zA-Z0-9-!#$%&'*+.^_`{|}~]+)");
    private static final Pattern PARAMETER = Pattern.compile(";\\s*(?:([a-zA-Z0-9-!#$%&'*+.^_`{|}~]+)=(?:([a-zA-Z0-9-!#$%&'*+.^_`{|}~]+)|\"([^\"]*)\"))?");
    private final String mediaType;
    private final String type;
    private final String subtype;
    private final String charset;

    private MediaType(String string, String string2, String string3, String string4) {
        this.mediaType = string;
        this.type = string2;
        this.subtype = string3;
        this.charset = string4;
    }

    public static MediaType parse(String string) {
        Matcher matcher = TYPE_SUBTYPE.matcher(string);
        if (!matcher.lookingAt()) {
            return null;
        }
        String string2 = matcher.group(1).toLowerCase(Locale.US);
        String string3 = matcher.group(2).toLowerCase(Locale.US);
        String string4 = null;
        Matcher matcher2 = PARAMETER.matcher(string);
        int n = matcher.end();
        while (n < string.length()) {
            matcher2.region(n, string.length());
            if (!matcher2.lookingAt()) {
                return null;
            }
            String string5 = matcher2.group(1);
            if (string5 != null && string5.equalsIgnoreCase("charset")) {
                String string6;
                String string7 = string6 = matcher2.group(2) != null ? matcher2.group(2) : matcher2.group(3);
                if (string4 != null && !string6.equalsIgnoreCase(string4)) {
                    throw new IllegalArgumentException("Multiple different charsets: " + string);
                }
                string4 = string6;
            }
            n = matcher2.end();
        }
        return new MediaType(string, string2, string3, string4);
    }

    public String type() {
        return this.type;
    }

    public String subtype() {
        return this.subtype;
    }

    public Charset charset() {
        return this.charset != null ? Charset.forName(this.charset) : null;
    }

    public Charset charset(Charset charset) {
        return this.charset != null ? Charset.forName(this.charset) : charset;
    }

    public String toString() {
        return this.mediaType;
    }

    public boolean equals(Object object) {
        return object instanceof MediaType && ((MediaType)object).mediaType.equals(this.mediaType);
    }

    public int hashCode() {
        return this.mediaType.hashCode();
    }
}

