/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.okhttp;

import com.squareup.okhttp.internal.Util;
import java.security.Principal;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Collections;
import java.util.List;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;

public final class Handshake {
    private final String cipherSuite;
    private final List<Certificate> peerCertificates;
    private final List<Certificate> localCertificates;

    private Handshake(String string, List<Certificate> list, List<Certificate> list2) {
        this.cipherSuite = string;
        this.peerCertificates = list;
        this.localCertificates = list2;
    }

    public static Handshake get(SSLSession sSLSession) {
        Certificate[] certificateArray;
        String string = sSLSession.getCipherSuite();
        if (string == null) {
            throw new IllegalStateException("cipherSuite == null");
        }
        try {
            certificateArray = sSLSession.getPeerCertificates();
        }
        catch (SSLPeerUnverifiedException sSLPeerUnverifiedException) {
            certificateArray = null;
        }
        List<Certificate> list = certificateArray != null ? Util.immutableList(certificateArray) : Collections.emptyList();
        Certificate[] certificateArray2 = sSLSession.getLocalCertificates();
        List<Certificate> list2 = certificateArray2 != null ? Util.immutableList(certificateArray2) : Collections.emptyList();
        return new Handshake(string, list, list2);
    }

    public static Handshake get(String string, List<Certificate> list, List<Certificate> list2) {
        if (string == null) {
            throw new IllegalArgumentException("cipherSuite == null");
        }
        return new Handshake(string, Util.immutableList(list), Util.immutableList(list2));
    }

    public String cipherSuite() {
        return this.cipherSuite;
    }

    public List<Certificate> peerCertificates() {
        return this.peerCertificates;
    }

    public Principal peerPrincipal() {
        return !this.peerCertificates.isEmpty() ? ((X509Certificate)this.peerCertificates.get(0)).getSubjectX500Principal() : null;
    }

    public List<Certificate> localCertificates() {
        return this.localCertificates;
    }

    public Principal localPrincipal() {
        return !this.localCertificates.isEmpty() ? ((X509Certificate)this.localCertificates.get(0)).getSubjectX500Principal() : null;
    }

    public boolean equals(Object object) {
        if (!(object instanceof Handshake)) {
            return false;
        }
        Handshake handshake2 = (Handshake)object;
        return this.cipherSuite.equals(handshake2.cipherSuite) && this.peerCertificates.equals(handshake2.peerCertificates) && this.localCertificates.equals(handshake2.localCertificates);
    }

    public int hashCode() {
        int n = 17;
        n = 31 * n + this.cipherSuite.hashCode();
        n = 31 * n + this.peerCertificates.hashCode();
        n = 31 * n + this.localCertificates.hashCode();
        return n;
    }
}

