/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.okhttp;

import com.squareup.okhttp.CipherSuite;
import com.squareup.okhttp.TlsVersion;
import com.squareup.okhttp.internal.Util;
import java.util.Arrays;
import java.util.List;
import javax.net.ssl.SSLSocket;

public final class ConnectionSpec {
    private static final CipherSuite[] APPROVED_CIPHER_SUITES = new CipherSuite[]{CipherSuite.TLS_ECDHE_ECDSA_WITH_AES_128_GCM_SHA256, CipherSuite.TLS_ECDHE_RSA_WITH_AES_128_GCM_SHA256, CipherSuite.TLS_DHE_RSA_WITH_AES_128_GCM_SHA256, CipherSuite.TLS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA, CipherSuite.TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA, CipherSuite.TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA, CipherSuite.TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA, CipherSuite.TLS_DHE_RSA_WITH_AES_128_CBC_SHA, CipherSuite.TLS_DHE_RSA_WITH_AES_256_CBC_SHA, CipherSuite.TLS_RSA_WITH_AES_128_GCM_SHA256, CipherSuite.TLS_RSA_WITH_AES_128_CBC_SHA, CipherSuite.TLS_RSA_WITH_AES_256_CBC_SHA, CipherSuite.TLS_RSA_WITH_3DES_EDE_CBC_SHA};
    public static final ConnectionSpec MODERN_TLS = new Builder(true).cipherSuites(APPROVED_CIPHER_SUITES).tlsVersions(TlsVersion.TLS_1_2, TlsVersion.TLS_1_1, TlsVersion.TLS_1_0).supportsTlsExtensions(true).build();
    public static final ConnectionSpec COMPATIBLE_TLS = new Builder(MODERN_TLS).tlsVersions(TlsVersion.TLS_1_0).supportsTlsExtensions(true).build();
    public static final ConnectionSpec CLEARTEXT = new Builder(false).build();
    private final boolean tls;
    private final boolean supportsTlsExtensions;
    private final String[] cipherSuites;
    private final String[] tlsVersions;

    private ConnectionSpec(Builder builder) {
        this.tls = builder.tls;
        this.cipherSuites = builder.cipherSuites;
        this.tlsVersions = builder.tlsVersions;
        this.supportsTlsExtensions = builder.supportsTlsExtensions;
    }

    public boolean isTls() {
        return this.tls;
    }

    public List<CipherSuite> cipherSuites() {
        if (this.cipherSuites == null) {
            return null;
        }
        CipherSuite[] cipherSuiteArray = new CipherSuite[this.cipherSuites.length];
        for (int i = 0; i < this.cipherSuites.length; ++i) {
            cipherSuiteArray[i] = CipherSuite.forJavaName(this.cipherSuites[i]);
        }
        return Util.immutableList(cipherSuiteArray);
    }

    public List<TlsVersion> tlsVersions() {
        if (this.tlsVersions == null) {
            return null;
        }
        TlsVersion[] tlsVersionArray = new TlsVersion[this.tlsVersions.length];
        for (int i = 0; i < this.tlsVersions.length; ++i) {
            tlsVersionArray[i] = TlsVersion.forJavaName(this.tlsVersions[i]);
        }
        return Util.immutableList(tlsVersionArray);
    }

    public boolean supportsTlsExtensions() {
        return this.supportsTlsExtensions;
    }

    void apply(SSLSocket sSLSocket, boolean bl) {
        ConnectionSpec connectionSpec = this.supportedSpec(sSLSocket, bl);
        if (connectionSpec.tlsVersions != null) {
            sSLSocket.setEnabledProtocols(connectionSpec.tlsVersions);
        }
        if (connectionSpec.cipherSuites != null) {
            sSLSocket.setEnabledCipherSuites(connectionSpec.cipherSuites);
        }
    }

    private ConnectionSpec supportedSpec(SSLSocket sSLSocket, boolean bl) {
        String[] stringArray;
        String[] stringArray2 = this.cipherSuites != null ? Util.intersect(String.class, this.cipherSuites, sSLSocket.getEnabledCipherSuites()) : sSLSocket.getEnabledCipherSuites();
        String[] stringArray3 = stringArray = this.tlsVersions != null ? Util.intersect(String.class, this.tlsVersions, sSLSocket.getEnabledProtocols()) : sSLSocket.getEnabledProtocols();
        if (bl && Util.contains(sSLSocket.getSupportedCipherSuites(), "TLS_FALLBACK_SCSV")) {
            stringArray2 = Util.concat(stringArray2, "TLS_FALLBACK_SCSV");
        }
        return new Builder(this).cipherSuites(stringArray2).tlsVersions(stringArray).build();
    }

    public boolean isCompatible(SSLSocket sSLSocket) {
        if (!this.tls) {
            return false;
        }
        if (this.tlsVersions != null && !ConnectionSpec.nonEmptyIntersection(this.tlsVersions, sSLSocket.getEnabledProtocols())) {
            return false;
        }
        return this.cipherSuites == null || ConnectionSpec.nonEmptyIntersection(this.cipherSuites, sSLSocket.getEnabledCipherSuites());
    }

    private static boolean nonEmptyIntersection(String[] stringArray, String[] stringArray2) {
        if (stringArray == null || stringArray2 == null || stringArray.length == 0 || stringArray2.length == 0) {
            return false;
        }
        for (String string : stringArray) {
            if (!Util.contains(stringArray2, string)) continue;
            return true;
        }
        return false;
    }

    public boolean equals(Object object) {
        if (!(object instanceof ConnectionSpec)) {
            return false;
        }
        if (object == this) {
            return true;
        }
        ConnectionSpec connectionSpec = (ConnectionSpec)object;
        if (this.tls != connectionSpec.tls) {
            return false;
        }
        if (this.tls) {
            if (!Arrays.equals(this.cipherSuites, connectionSpec.cipherSuites)) {
                return false;
            }
            if (!Arrays.equals(this.tlsVersions, connectionSpec.tlsVersions)) {
                return false;
            }
            if (this.supportsTlsExtensions != connectionSpec.supportsTlsExtensions) {
                return false;
            }
        }
        return true;
    }

    public int hashCode() {
        int n = 17;
        if (this.tls) {
            n = 31 * n + Arrays.hashCode(this.cipherSuites);
            n = 31 * n + Arrays.hashCode(this.tlsVersions);
            n = 31 * n + (this.supportsTlsExtensions ? 0 : 1);
        }
        return n;
    }

    public String toString() {
        if (!this.tls) {
            return "ConnectionSpec()";
        }
        String string = this.cipherSuites != null ? this.cipherSuites().toString() : "[all enabled]";
        String string2 = this.tlsVersions != null ? this.tlsVersions().toString() : "[all enabled]";
        return "ConnectionSpec(cipherSuites=" + string + ", tlsVersions=" + string2 + ", supportsTlsExtensions=" + this.supportsTlsExtensions + ")";
    }

    public static final class Builder {
        private boolean tls;
        private String[] cipherSuites;
        private String[] tlsVersions;
        private boolean supportsTlsExtensions;

        Builder(boolean bl) {
            this.tls = bl;
        }

        public Builder(ConnectionSpec connectionSpec) {
            this.tls = connectionSpec.tls;
            this.cipherSuites = connectionSpec.cipherSuites;
            this.tlsVersions = connectionSpec.tlsVersions;
            this.supportsTlsExtensions = connectionSpec.supportsTlsExtensions;
        }

        public Builder allEnabledCipherSuites() {
            if (!this.tls) {
                throw new IllegalStateException("no cipher suites for cleartext connections");
            }
            this.cipherSuites = null;
            return this;
        }

        public Builder cipherSuites(CipherSuite ... cipherSuiteArray) {
            if (!this.tls) {
                throw new IllegalStateException("no cipher suites for cleartext connections");
            }
            String[] stringArray = new String[cipherSuiteArray.length];
            for (int i = 0; i < cipherSuiteArray.length; ++i) {
                stringArray[i] = cipherSuiteArray[i].javaName;
            }
            return this.cipherSuites(stringArray);
        }

        public Builder cipherSuites(String ... stringArray) {
            if (!this.tls) {
                throw new IllegalStateException("no cipher suites for cleartext connections");
            }
            if (stringArray.length == 0) {
                throw new IllegalArgumentException("At least one cipher suite is required");
            }
            this.cipherSuites = (String[])stringArray.clone();
            return this;
        }

        public Builder allEnabledTlsVersions() {
            if (!this.tls) {
                throw new IllegalStateException("no TLS versions for cleartext connections");
            }
            this.tlsVersions = null;
            return this;
        }

        public Builder tlsVersions(TlsVersion ... tlsVersionArray) {
            if (!this.tls) {
                throw new IllegalStateException("no TLS versions for cleartext connections");
            }
            String[] stringArray = new String[tlsVersionArray.length];
            for (int i = 0; i < tlsVersionArray.length; ++i) {
                stringArray[i] = tlsVersionArray[i].javaName;
            }
            return this.tlsVersions(stringArray);
        }

        public Builder tlsVersions(String ... stringArray) {
            if (!this.tls) {
                throw new IllegalStateException("no TLS versions for cleartext connections");
            }
            if (stringArray.length == 0) {
                throw new IllegalArgumentException("At least one TLS version is required");
            }
            this.tlsVersions = (String[])stringArray.clone();
            return this;
        }

        public Builder supportsTlsExtensions(boolean bl) {
            if (!this.tls) {
                throw new IllegalStateException("no TLS extensions for cleartext connections");
            }
            this.supportsTlsExtensions = bl;
            return this;
        }

        public ConnectionSpec build() {
            return new ConnectionSpec(this);
        }
    }
}

