/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.okhttp;

import com.squareup.okhttp.internal.Util;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.net.ssl.SSLPeerUnverifiedException;
import okio.ByteString;

public final class CertificatePinner {
    public static final CertificatePinner DEFAULT = new Builder().build();
    private final Map<String, Set<ByteString>> hostnameToPins;

    private CertificatePinner(Builder builder) {
        this.hostnameToPins = Util.immutableMap(builder.hostnameToPins);
    }

    public void check(String string, List<Certificate> list) throws SSLPeerUnverifiedException {
        Set<ByteString> set = this.findMatchingPins(string);
        if (set == null) {
            return;
        }
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            X509Certificate x509Certificate = (X509Certificate)list.get(i);
            if (!set.contains(CertificatePinner.sha1(x509Certificate))) continue;
            return;
        }
        StringBuilder stringBuilder = new StringBuilder().append("Certificate pinning failure!").append("\n  Peer certificate chain:");
        int n2 = list.size();
        for (n = 0; n < n2; ++n) {
            X509Certificate x509Certificate = (X509Certificate)list.get(n);
            stringBuilder.append("\n    ").append(CertificatePinner.pin(x509Certificate)).append(": ").append(x509Certificate.getSubjectDN().getName());
        }
        stringBuilder.append("\n  Pinned certificates for ").append(string).append(":");
        for (ByteString byteString : set) {
            stringBuilder.append("\n    sha1/").append(byteString.base64());
        }
        throw new SSLPeerUnverifiedException(stringBuilder.toString());
    }

    public void check(String string, Certificate ... certificateArray) throws SSLPeerUnverifiedException {
        this.check(string, Arrays.asList(certificateArray));
    }

    Set<ByteString> findMatchingPins(String string) {
        int n;
        Set<ByteString> set = this.hostnameToPins.get(string);
        Set<ByteString> set2 = null;
        int n2 = string.indexOf(46);
        if (n2 != (n = string.lastIndexOf(46))) {
            set2 = this.hostnameToPins.get("*." + string.substring(n2 + 1));
        }
        if (set == null && set2 == null) {
            return null;
        }
        if (set != null && set2 != null) {
            LinkedHashSet<ByteString> linkedHashSet = new LinkedHashSet<ByteString>();
            linkedHashSet.addAll(set);
            linkedHashSet.addAll(set2);
            return linkedHashSet;
        }
        if (set != null) {
            return set;
        }
        return set2;
    }

    public static String pin(Certificate certificate) {
        if (!(certificate instanceof X509Certificate)) {
            throw new IllegalArgumentException("Certificate pinning requires X509 certificates");
        }
        return "sha1/" + CertificatePinner.sha1((X509Certificate)certificate).base64();
    }

    private static ByteString sha1(X509Certificate x509Certificate) {
        return Util.sha1(ByteString.of(x509Certificate.getPublicKey().getEncoded()));
    }

    public static final class Builder {
        private final Map<String, Set<ByteString>> hostnameToPins = new LinkedHashMap<String, Set<ByteString>>();

        public Builder add(String string, String ... stringArray) {
            if (string == null) {
                throw new IllegalArgumentException("hostname == null");
            }
            LinkedHashSet linkedHashSet = new LinkedHashSet();
            Set set = this.hostnameToPins.put(string, Collections.unmodifiableSet(linkedHashSet));
            if (set != null) {
                linkedHashSet.addAll(set);
            }
            for (String string2 : stringArray) {
                if (!string2.startsWith("sha1/")) {
                    throw new IllegalArgumentException("pins must start with 'sha1/': " + string2);
                }
                ByteString byteString = ByteString.decodeBase64(string2.substring("sha1/".length()));
                if (byteString == null) {
                    throw new IllegalArgumentException("pins must be base64: " + string2);
                }
                linkedHashSet.add(byteString);
            }
            return this;
        }

        public CertificatePinner build() {
            return new CertificatePinner(this);
        }
    }
}

