/*
 * Decompiled with CFR 0.152.
 */
package com.qcloud.cos.utils;

import com.qcloud.cos.internal.SdkThreadLocalsRegistry;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.stream.XMLInputFactory;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class XmlUtils {
    private static final ThreadLocal<XMLInputFactory> xmlInputFactory = SdkThreadLocalsRegistry.register(new ThreadLocal<XMLInputFactory>(){

        @Override
        protected XMLInputFactory initialValue() {
            return XmlUtils.createXmlInputFactory();
        }
    });

    public static XMLReader parse(InputStream inputStream2, ContentHandler contentHandler) throws SAXException, IOException {
        XMLReader xMLReader = XMLReaderFactory.createXMLReader();
        xMLReader.setContentHandler(contentHandler);
        xMLReader.parse(new InputSource(inputStream2));
        inputStream2.close();
        return xMLReader;
    }

    public static XMLInputFactory getXmlInputFactory() {
        return xmlInputFactory.get();
    }

    private static XMLInputFactory createXmlInputFactory() {
        XMLInputFactory xMLInputFactory = XMLInputFactory.newInstance();
        xMLInputFactory.setProperty("javax.xml.stream.supportDTD", false);
        xMLInputFactory.setProperty("javax.xml.stream.isSupportingExternalEntities", false);
        return xMLInputFactory;
    }
}

