/*
 * Decompiled with CFR 0.152.
 */
package com.qcloud.cos.utils;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.qcloud.cos.exception.CosClientException;
import java.io.File;
import java.io.IOException;
import java.io.Writer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum Jackson {

    private static final Logger LOG = LoggerFactory.getLogger(Jackson.class);
    private static final ObjectMapper objectMapper = new ObjectMapper();
    private static final ObjectWriter writer;
    private static final ObjectWriter prettyWriter;

    public static String toJsonPrettyString(Object object) {
        try {
            return prettyWriter.writeValueAsString(object);
        }
        catch (Exception exception) {
            throw new IllegalStateException(exception);
        }
    }

    public static String toJsonString(Object object) {
        try {
            return writer.writeValueAsString(object);
        }
        catch (Exception exception) {
            throw new IllegalStateException(exception);
        }
    }

    public static <T> T fromJsonString(String string, Class<T> clazz) {
        if (string == null) {
            return null;
        }
        try {
            return objectMapper.readValue(string, clazz);
        }
        catch (Exception exception) {
            throw new CosClientException("Unable to parse Json String.", exception);
        }
    }

    public static <T> T fromSensitiveJsonString(String string, Class<T> clazz) {
        if (null == string) {
            return null;
        }
        try {
            return objectMapper.readValue(string, clazz);
        }
        catch (IOException iOException) {
            if (iOException instanceof JsonProcessingException) {
                LOG.warn("Failed to parse the json string.", iOException);
                throw new CosClientException("Unable to parse the json string. See warn logs for the exact error details, which may include sensitive information.");
            }
            throw new CosClientException("Unable to parse the json string.", iOException);
        }
    }

    public static JsonNode jsonNodeOf(String string) {
        return Jackson.fromJsonString(string, JsonNode.class);
    }

    public static JsonGenerator jsonGeneratorOf(Writer writer) throws IOException {
        return new JsonFactory().createGenerator(writer);
    }

    public static <T> T loadFrom(File file, Class<T> clazz) throws IOException {
        try {
            return objectMapper.readValue(file, clazz);
        }
        catch (IOException iOException) {
            throw iOException;
        }
        catch (Exception exception) {
            throw new IllegalStateException(exception);
        }
    }

    public static ObjectMapper getObjectMapper() {
        return objectMapper;
    }

    public static ObjectWriter getWriter() {
        return writer;
    }

    public static ObjectWriter getPrettywriter() {
        return prettyWriter;
    }

    static {
        objectMapper.configure(JsonParser.Feature.ALLOW_COMMENTS, true);
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        writer = objectMapper.writer();
        prettyWriter = objectMapper.writerWithDefaultPrettyPrinter();
    }
}

