/*
 * Decompiled with CFR 0.152.
 */
package com.qcloud.cos.utils;

import com.qcloud.cos.internal.Releasable;
import com.qcloud.cos.utils.StringUtils;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum IOUtils {

    private static final int BUFFER_SIZE = 4096;
    private static final Logger defaultLog = LoggerFactory.getLogger(IOUtils.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] toByteArray(InputStream inputStream2) throws IOException {
        try (ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();){
            byte[] byArray = new byte[4096];
            int n = 0;
            while ((n = inputStream2.read(byArray)) != -1) {
                byteArrayOutputStream.write(byArray, 0, n);
            }
            byte[] byArray2 = byteArrayOutputStream.toByteArray();
            return byArray2;
        }
    }

    public static String toString(InputStream inputStream2) throws IOException {
        return new String(IOUtils.toByteArray(inputStream2), StringUtils.UTF8);
    }

    public static void closeQuietly(Closeable closeable, Logger logger) {
        block3: {
            if (closeable != null) {
                try {
                    closeable.close();
                }
                catch (IOException iOException) {
                    Logger logger2;
                    Logger logger3 = logger2 = logger == null ? defaultLog : logger;
                    if (!logger2.isDebugEnabled()) break block3;
                    logger2.debug("Ignore failure in closing the Closeable", iOException);
                }
            }
        }
    }

    public static void release(Closeable closeable, Logger logger) {
        IOUtils.closeQuietly(closeable, logger);
        if (closeable instanceof Releasable) {
            Releasable releasable = (Releasable)((Object)closeable);
            releasable.release();
        }
    }

    public static long copy(InputStream inputStream2, OutputStream outputStream2) throws IOException {
        byte[] byArray = new byte[4096];
        long l = 0L;
        int n = 0;
        while ((n = inputStream2.read(byArray)) > -1) {
            outputStream2.write(byArray, 0, n);
            l += (long)n;
        }
        return l;
    }

    public static void drainInputStream(InputStream inputStream2) {
        try {
            while (inputStream2.read() != -1) {
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

