/*
 * Decompiled with CFR 0.152.
 */
package com.qcloud.cos.transfer;

import com.qcloud.cos.event.ProgressEventType;
import com.qcloud.cos.event.ProgressListenerChain;
import com.qcloud.cos.event.SDKProgressPublisher;
import com.qcloud.cos.exception.CosClientException;
import com.qcloud.cos.transfer.DownloadImpl;
import com.qcloud.cos.transfer.DownloadPart;
import com.qcloud.cos.transfer.PersistableResumeDownload;
import com.qcloud.cos.transfer.ResumableDownloadSubmitter;
import com.qcloud.cos.transfer.Transfer;
import com.qcloud.cos.transfer.TransferMonitor;
import com.qcloud.cos.utils.CRC64;
import java.io.File;
import java.io.IOException;
import java.math.BigInteger;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResumableDownloadMonitor
implements TransferMonitor,
Callable<File> {
    private static final Logger log = LoggerFactory.getLogger(ResumableDownloadMonitor.class);
    private final ProgressListenerChain listener;
    private final ResumableDownloadSubmitter downloadSubmitter;
    private final DownloadImpl transfer;
    private final PersistableResumeDownload downloadRecord;
    private final File destFile;
    private final FileChannel destFileChannel;
    private final List<Future<DownloadPart>> futures = Collections.synchronizedList(new ArrayList());
    private boolean isDownloadDone = false;
    private AtomicReference<Future<File>> futureReference = new AtomicReference<Object>(null);

    public Future<File> getFuture() {
        return this.futureReference.get();
    }

    private synchronized void cancelFuture() {
        this.futureReference.get().cancel(true);
    }

    ResumableDownloadMonitor(ProgressListenerChain progressListenerChain, ResumableDownloadSubmitter resumableDownloadSubmitter, DownloadImpl downloadImpl, PersistableResumeDownload persistableResumeDownload, File file, FileChannel fileChannel) {
        this.listener = progressListenerChain;
        this.downloadSubmitter = resumableDownloadSubmitter;
        this.transfer = downloadImpl;
        this.downloadRecord = persistableResumeDownload;
        this.destFile = file;
        this.destFileChannel = fileChannel;
    }

    public static ResumableDownloadMonitor create(ProgressListenerChain progressListenerChain, ResumableDownloadSubmitter resumableDownloadSubmitter, DownloadImpl downloadImpl, ExecutorService executorService, PersistableResumeDownload persistableResumeDownload, File file, FileChannel fileChannel) {
        ResumableDownloadMonitor resumableDownloadMonitor = new ResumableDownloadMonitor(progressListenerChain, resumableDownloadSubmitter, downloadImpl, persistableResumeDownload, file, fileChannel);
        resumableDownloadMonitor.futureReference.compareAndSet(null, executorService.submit(resumableDownloadMonitor));
        return resumableDownloadMonitor;
    }

    @Override
    public synchronized boolean isDone() {
        return this.isDownloadDone;
    }

    private synchronized void markAllDone() {
        this.isDownloadDone = true;
    }

    @Override
    public File call() throws Exception {
        this.downloadSubmitter.submit();
        this.futures.addAll(this.downloadSubmitter.getFutures());
        ArrayList<DownloadPart> arrayList = new ArrayList<DownloadPart>();
        arrayList.addAll(this.downloadSubmitter.getSkippedParts());
        try {
            for (Future<DownloadPart> future : this.futures) {
                try {
                    arrayList.add(future.get());
                }
                catch (Exception exception) {
                    throw new CosClientException("range download got exception: " + exception.getCause().getMessage() + exception.getMessage());
                }
            }
            this.downloadRecord.getDumpFile().delete();
            this.destFileChannel.close();
            if (this.downloadRecord.getCrc64ecma() != null && !this.downloadRecord.getCrc64ecma().isEmpty()) {
                this.checkCRC(arrayList);
            }
            this.downloadComplete();
            return this.destFile;
        }
        catch (CancellationException cancellationException) {
            this.transfer.setState(Transfer.TransferState.Canceled);
            SDKProgressPublisher.publishProgress(this.listener, ProgressEventType.TRANSFER_CANCELED_EVENT);
            throw new CosClientException("Download canceled");
        }
        catch (Exception exception) {
            this.downloadFailed();
            throw exception;
        }
    }

    void downloadComplete() {
        this.markAllDone();
        this.transfer.setState(Transfer.TransferState.Completed);
        SDKProgressPublisher.publishProgress(this.listener, ProgressEventType.TRANSFER_COMPLETED_EVENT);
    }

    void downloadFailed() {
        this.transfer.setState(Transfer.TransferState.Failed);
        SDKProgressPublisher.publishProgress(this.listener, ProgressEventType.TRANSFER_FAILED_EVENT);
    }

    private void cancelFutures() {
        this.cancelFuture();
        if (this.futures.size() == 0) {
            this.futures.addAll(this.downloadSubmitter.getFutures());
        }
        for (Future<DownloadPart> future : this.futures) {
            future.cancel(true);
        }
        this.futures.clear();
    }

    void performAbort() {
        this.cancelFutures();
        SDKProgressPublisher.publishProgress(this.listener, ProgressEventType.TRANSFER_CANCELED_EVENT);
    }

    void checkCRC(List<DownloadPart> list) throws IOException {
        Collections.sort(list, new Comparator<DownloadPart>(){

            @Override
            public int compare(DownloadPart downloadPart, DownloadPart downloadPart2) {
                return (int)(downloadPart.start - downloadPart2.start);
            }
        });
        CRC64 cRC64 = new CRC64();
        for (DownloadPart downloadPart : list) {
            cRC64 = CRC64.combine(cRC64, new CRC64(downloadPart.crc64), downloadPart.getContentLength());
        }
        long l = cRC64.getValue();
        long l2 = this.crc64ToLong(this.downloadRecord.getCrc64ecma());
        log.debug("download crc " + l + " cos crc " + l2);
        if (l != l2) {
            this.destFile.delete();
            throw new CosClientException("download file has diff crc64 with cos file, cos: " + l2 + " downloaded: " + l);
        }
    }

    long crc64ToLong(String string) {
        if (string.charAt(0) == '-') {
            return this.negativeCrc64ToLong(string);
        }
        return this.positiveCrc64ToLong(string);
    }

    long positiveCrc64ToLong(String string) {
        BigInteger bigInteger = new BigInteger(string);
        BigInteger bigInteger2 = new BigInteger(Long.toString(Long.MAX_VALUE));
        int n = 0;
        while (bigInteger.compareTo(bigInteger2) > 0) {
            bigInteger = bigInteger.subtract(bigInteger2);
            ++n;
        }
        return bigInteger.longValue() + Long.MAX_VALUE * (long)n;
    }

    long negativeCrc64ToLong(String string) {
        BigInteger bigInteger = new BigInteger(string);
        BigInteger bigInteger2 = new BigInteger(Long.toString(Long.MIN_VALUE));
        int n = 0;
        while (bigInteger.compareTo(bigInteger2) < 0) {
            bigInteger = bigInteger.subtract(bigInteger2);
            ++n;
        }
        return bigInteger.longValue() + Long.MIN_VALUE * (long)n;
    }
}

