/*
 * Decompiled with CFR 0.152.
 */
package com.qcloud.cos.transfer;

import com.qcloud.cos.COS;
import com.qcloud.cos.exception.CosClientException;
import com.qcloud.cos.model.COSObject;
import com.qcloud.cos.model.COSObjectInputStream;
import com.qcloud.cos.model.GetObjectRequest;
import com.qcloud.cos.model.ObjectMetadata;
import com.qcloud.cos.transfer.DownloadPart;
import com.qcloud.cos.transfer.PersistableResumeDownload;
import com.qcloud.cos.utils.CRC64;
import java.io.File;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.concurrent.Callable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RangeDownloadCallable
implements Callable<DownloadPart> {
    private static final Logger log = LoggerFactory.getLogger(RangeDownloadCallable.class);
    private final COS cos;
    private final GetObjectRequest request;
    private final File destFile;
    private FileChannel destFileChannel;
    private PersistableResumeDownload downloadRecord;

    public RangeDownloadCallable(COS cOS, GetObjectRequest getObjectRequest, File file, FileChannel fileChannel, PersistableResumeDownload persistableResumeDownload) {
        this.cos = cOS;
        this.request = getObjectRequest;
        this.destFile = file;
        this.destFileChannel = fileChannel;
        this.downloadRecord = persistableResumeDownload;
    }

    @Override
    public DownloadPart call() throws Exception {
        int n;
        COSObject cOSObject = this.cos.getObject(this.request);
        COSObjectInputStream cOSObjectInputStream = cOSObject.getObjectContent();
        ObjectMetadata objectMetadata = cOSObject.getObjectMetadata();
        long[] lArray = this.request.getRange();
        long l = lArray[0];
        long l2 = lArray[1];
        long l3 = l;
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(0x100000);
        byte[] byArray = new byte[10240];
        CRC64 cRC64 = new CRC64();
        while ((n = ((InputStream)cOSObjectInputStream).read(byArray)) > -1) {
            l += (long)n;
            cRC64.update(byArray, n);
            if (byteBuffer.remaining() < n) {
                byteBuffer.flip();
                l3 += (long)this.destFileChannel.write(byteBuffer, l3);
                byteBuffer.clear();
            }
            byteBuffer.put(byArray, 0, n);
        }
        byteBuffer.flip();
        this.destFileChannel.write(byteBuffer, l3);
        if (l != l2 + 1L) {
            this.destFileChannel.close();
            this.destFile.delete();
            String string = String.format("get object want %d bytes, but got %d bytes, reqeust_id: %s", l2 + 1L, l, objectMetadata.getRequestId());
            throw new CosClientException(string);
        }
        String string = String.format("%d-%d", lArray[0], lArray[1]);
        this.downloadRecord.putDownloadedBlocks(string);
        this.downloadRecord.dump();
        return new DownloadPart(lArray[0], lArray[1], cRC64.getValue());
    }
}

